/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flashcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashCodeUtilsZxing
implements FlashCodeUtils {
    @Override
    public List<BufferedImage> exportFlashcodeSimple(String string) throws IOException {
        try {
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, 1);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
            return Arrays.asList(bufferedImage);
        }
        catch (WriterException writerException) {
            throw new IOException("WriterException");
        }
    }

    @Override
    public List<BufferedImage> exportFlashcodeCompress(String string) throws IOException {
        try {
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            CompressionZlib compressionZlib = new CompressionZlib();
            byte[] byArray = compressionZlib.compress(string.getBytes("UTF-8"));
            BitMatrix bitMatrix = qRCodeWriter.encode(new String(byArray, "ISO-8859-1"), BarcodeFormat.QR_CODE, 1);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
            return Arrays.asList(bufferedImage);
        }
        catch (WriterException writerException) {
            throw new IOException("WriterException");
        }
    }

    @Override
    public List<BufferedImage> exportSplitCompress(String string) throws IOException {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        CompressionZlib compressionZlib = new CompressionZlib();
        byte[] byArray = compressionZlib.compress(string.getBytes("UTF-8"));
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        for (int i = 0; i < 4; ++i) {
            arrayList2.add(FlashCodeUtilsZxing.getSplited(byArray, i, 4));
        }
        arrayList2.add(FlashCodeUtilsZxing.xor(arrayList2));
        try {
            for (byte[] byArray2 : arrayList2) {
                BitMatrix bitMatrix = qRCodeWriter.encode(new String(byArray2, "ISO-8859-1"), BarcodeFormat.QR_CODE, 1);
                arrayList.add(MatrixToImageWriter.toBufferedImage(bitMatrix));
            }
        }
        catch (WriterException writerException) {
            throw new IOException("WriterException");
        }
        return Collections.unmodifiableList(arrayList);
    }

    static byte[] xor(List<byte[]> list) {
        byte[] byArray = new byte[list.get(0).length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = FlashCodeUtilsZxing.xor(list, i);
        }
        return byArray;
    }

    static byte xor(List<byte[]> list, int n) {
        byte by = 0;
        for (byte[] byArray : list) {
            by = (byte)(by ^ byArray[n]);
        }
        return by;
    }

    static byte[] getSplited(byte[] byArray, int n, int n2) {
        int n3 = (byArray.length + n2 - 1) / n2;
        assert (n3 * n2 >= byArray.length);
        byte[] byArray2 = new byte[n3 + 1];
        byArray2[0] = (byte)(1 << n);
        for (int i = 0; i < n3 && n * n2 + i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[n * n2 + i];
        }
        return byArray2;
    }
}

