/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMoveable;

class PositiveForce {
    private final Real fixedPoint;
    private final RealMoveable movingPoint;
    private final double minimunDistance;

    public PositiveForce(Real real, RealMoveable realMoveable, double d) {
        if (real == realMoveable) {
            throw new IllegalArgumentException();
        }
        this.fixedPoint = real;
        this.movingPoint = realMoveable;
        this.minimunDistance = d;
    }

    public String toString() {
        return "PositiveForce fixed=" + this.fixedPoint + " moving=" + this.movingPoint + " min=" + this.minimunDistance;
    }

    public boolean apply() {
        double d = this.movingPoint.getCurrentValue() - this.fixedPoint.getCurrentValue();
        double d2 = d - this.minimunDistance;
        if (d2 >= 0.0) {
            return false;
        }
        this.movingPoint.move(-d2);
        return true;
    }
}

