# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test;
BEGIN { plan tests => 13 };
use Config::Auto;
ok(1); # If we made it this far, we're ok.

#########################

# Insert your test code below, the Test module is use()ed here so read
# its man page ( perldoc Test ) for help writing this test script.

sub t {
    open OUT, ">test.config" or die $!;
    print OUT @_;
    close OUT;
    my $c = Config::Auto::parse("test.config");
    unlink "test.config";
    return $c;
}

my $c;
$c = t(<<EOF);
search oucs.ox.ac.uk ox.ac.uk
nameserver 163.1.2.1
nameserver 129.67.1.1
nameserver 129.67.1.180
EOF

ok(ref ($c->{nameserver}) eq "ARRAY");
ok($c->{nameserver}[0] eq "163.1.2.1");
ok(ref ($c->{search}) eq "ARRAY");

$c = t(<<EOF);
root:x:0:0:root:/root:/bin/bash
daemon:x:1:1:daemon:/usr/sbin:/bin/sh
bin:x:2:2:bin:/bin:/bin/sh
EOF

ok(ref($c->{root}) eq "ARRAY");
ok($c->{root}[0] eq "x");

$c = t(<<EOF);
# This file was generated by debconf automaticaly.
# Please use dpkg-reconfigure to edit.
# And you can copy this file to ~/.mozillarc to override.
MOZILLA_DSP=auto
USE_GDKXFT=false
EOF

ok($c->{MOZILLA_DSP} eq "auto");

$c = t(<<EOF);
# /etc/nsswitch.conf
#
# Example configuration of GNU Name Service Switch functionality.
# If you have the `glibc-doc' and `info' packages installed, try:
# `info libc "Name Service Switch"' for information about this file.

passwd:         compat
group:          compat
shadow:         compat

hosts:          files dns
EOF

ok($c->{passwd} eq "compat");
ok(ref $c->{hosts} eq "ARRAY");

$c = t(<<EOF);
test: foo=bar
test: baz
quux: zoop

EOF

ok($c->{quux} eq "zoop");
ok(ref $c->{test} eq "HASH");
ok($c->{test}{foo} eq "bar");
ok($c->{test}{baz} == 1);
