/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GroupAdjacentIterator;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.expr.sort.GroupEndingIterator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupStartingIterator;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedGroupIterator;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachGroup
extends Instruction
implements SortKeyEvaluator,
ContextMappingFunction {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Expression key;
    private Expression collationNameExpression;
    private URI baseURI;
    private StringCollator collator = null;
    private SortKeyDefinition[] sortKeyDefinitions = null;
    private transient AtomicComparer[] sortComparators = null;

    public ForEachGroup(Expression select, Expression action, byte algorithm, Expression key, StringCollator collator, Expression collationNameExpression, URI baseURI, SortKeyDefinition[] sortKeys) {
        this.select = select;
        this.action = action;
        this.algorithm = algorithm;
        this.key = key;
        this.collator = collator;
        this.collationNameExpression = collationNameExpression;
        this.baseURI = baseURI;
        this.sortKeyDefinitions = sortKeys;
        Iterator<Expression> kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = kids.next();
            this.adoptChildExpression(child);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 154;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public Expression getGroupingKey() {
        return this.key;
    }

    public SortKeyDefinition[] getSortKeyDefinitions() {
        return this.sortKeyDefinitions;
    }

    public AtomicComparer[] getSortKeyComparators() {
        return this.sortComparators;
    }

    public StringCollator getCollation() {
        return this.collator;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.action = visitor.simplify(this.action);
        this.key = visitor.simplify(this.key);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        ItemType selectedItemType = this.select.getItemType(th);
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(selectedItemType, false);
        this.action = visitor.typeCheck(this.action, cit);
        this.key = visitor.typeCheck(this.key, cit);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeyDefinitions != null) {
            boolean allFixed = true;
            for (SortKeyDefinition sk : this.sortKeyDefinitions) {
                Expression sortKey = sk.getSortKey();
                sortKey = visitor.typeCheck(sortKey, cit);
                if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
                    sortKey = FirstItemExpression.makeFirstItemExpression(sortKey);
                } else {
                    RoleLocator role = new RoleLocator(4, "xsl:sort/select", 0);
                    role.setErrorCode("XTTE1020");
                    sortKey = CardinalityChecker.makeCardinalityChecker(sortKey, 24576, role);
                }
                sk.setSortKey(sortKey, true);
                if (sk.isFixed()) {
                    AtomicComparer comp = sk.makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                    sk.setFinalComparator(comp);
                    continue;
                }
                allFixed = false;
            }
            if (allFixed) {
                this.sortComparators = new AtomicComparer[this.sortKeyDefinitions.length];
                for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                    this.sortComparators[i] = this.sortKeyDefinitions[i].getFinalComparator();
                }
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        ItemType selectedItemType = this.select.getItemType(th);
        ExpressionVisitor.ContextItemType sit = new ExpressionVisitor.ContextItemType(selectedItemType, false);
        this.action = this.action.optimize(visitor, sit);
        this.key = this.key.optimize(visitor, sit);
        this.adoptChildExpression(this.select);
        this.adoptChildExpression(this.action);
        this.adoptChildExpression(this.key);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                Expression sortKey = skd.getSortKey();
                sortKey = visitor.optimize(sortKey, sit);
                skd.setSortKey(sortKey, true);
            }
        }
        if (this.collator == null && this.collationNameExpression instanceof StringLiteral) {
            String collation = ((StringLiteral)this.collationNameExpression).getStringValue();
            try {
                URI collationURI = new URI(collation);
                if (!collationURI.isAbsolute()) {
                    collationURI = this.baseURI.resolve(collationURI);
                    String collationNameString = collationURI.toString();
                    this.collationNameExpression = new StringLiteral(collationNameString);
                    this.collator = visitor.getStaticContext().getCollation(collationNameString);
                    if (this.collator == null) {
                        XPathException err = new XPathException("Unknown collation " + Err.wrap(collationURI.toString(), 7));
                        err.setErrorCode("XTDE1110");
                        err.setLocator(this);
                        throw err;
                    }
                }
            }
            catch (URISyntaxException err) {
                XPathException e = new XPathException("Collation name '" + this.collationNameExpression + "' is not a valid URI");
                e.setErrorCode("XTDE1110");
                e.setLocator(this);
                throw e;
            }
        }
        return this;
    }

    @Override
    public Expression copy() {
        SortKeyDefinition[] newKeyDef = null;
        if (this.sortKeyDefinitions != null) {
            newKeyDef = new SortKeyDefinition[this.sortKeyDefinitions.length];
            for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                newKeyDef[i] = this.sortKeyDefinitions[i].copy();
            }
        }
        return new ForEachGroup(this.select.copy(), this.action.copy(), this.algorithm, this.key.copy(), this.collator, this.collationNameExpression.copy(), this.baseURI, newKeyDef);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.key.getDependencies() & 0xFFFFFFE1;
        dependencies |= this.action.getDependencies() & 0xFFFFFFC1;
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                dependencies |= skd.getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression e = skd.getCaseOrder();
                if (e != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getDataTypeExpression()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getLanguage()) == null || e instanceof Literal) continue;
                dependencies |= e.getDependencies();
            }
        }
        if (this.collationNameExpression != null) {
            dependencies |= this.collationNameExpression.getDependencies();
        }
        return dependencies;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p |= this.action.getSpecialProperties() & 0x4000000;
    }

    @Override
    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        if (offer.action == 12 || offer.action == 15) {
            this.action = this.doPromotion(this.action, offer);
            this.key = this.doPromotion(this.key, offer);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(8);
        list.add(this.select);
        list.add(this.action);
        list.add(this.key);
        if (this.collationNameExpression != null) {
            list.add(this.collationNameExpression);
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                list.add(skd.getSortKey());
                Expression e = skd.getOrder();
                if (e != null) {
                    list.add(e);
                }
                if ((e = skd.getCaseOrder()) != null) {
                    list.add(e);
                }
                if ((e = skd.getDataTypeExpression()) != null) {
                    list.add(e);
                }
                if ((e = skd.getLanguage()) != null) {
                    list.add(e);
                }
                if ((e = skd.getCollationNameExpression()) == null) continue;
                list.add(e);
            }
        }
        return list.iterator();
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(8);
        list.add(this.select);
        if (this.collationNameExpression != null) {
            list.add(this.collationNameExpression);
        }
        return list.iterator();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        if (this.collationNameExpression != null) {
            this.collationNameExpression.addToPathMap(pathMap, pathMapNodeSet);
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                skd.getSortKey().addToPathMap(pathMap, target);
                Expression e = skd.getOrder();
                if (e != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getCaseOrder()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getDataTypeExpression()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getLanguage()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getCollationNameExpression()) == null) continue;
                e.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return this.action.addToPathMap(pathMap, target);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action || child == this.key;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        if (this.collationNameExpression == original) {
            this.collationNameExpression = replacement;
            found = true;
        }
        if (this.key == original) {
            this.key = replacement;
            found = true;
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                if (skd.getSortKey() == original) {
                    skd.setSortKey(replacement, true);
                    found = true;
                }
                if (skd.getOrder() == original) {
                    skd.setOrder(replacement);
                    found = true;
                }
                if (skd.getCaseOrder() == original) {
                    skd.setCaseOrder(replacement);
                    found = true;
                }
                if (skd.getDataTypeExpression() == original) {
                    skd.setDataTypeExpression(replacement);
                    found = true;
                }
                if (skd.getLanguage() != original) continue;
                skd.setLanguage(replacement);
                found = true;
            }
        }
        return found;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        GroupIterator groupIterator = this.getGroupIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(groupIterator);
        c2.setCurrentGroupIterator(groupIterator);
        c2.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Object item;
            TraceListener listener = controller.getTraceListener();
            assert (listener != null);
            while ((item = groupIterator.next()) != null) {
                listener.startCurrentItem((Item)item);
                this.action.process(c2);
                listener.endCurrentItem((Item)item);
            }
        } else {
            Object item;
            while ((item = groupIterator.next()) != null) {
                this.action.process(c2);
            }
        }
        return null;
    }

    public Expression getCollationNameExpression() {
        return this.collationNameExpression;
    }

    private StringCollator getCollator(XPathContext context) throws XPathException {
        if (this.collationNameExpression != null) {
            StringValue collationValue = (StringValue)this.collationNameExpression.evaluateItem(context);
            assert (collationValue != null);
            String cname = collationValue.getStringValue();
            cname = CollatingFunction.expandCollationURI(cname, this.baseURI, context);
            return context.getCollation(cname);
        }
        return CodepointCollator.getInstance();
    }

    private GroupIterator getGroupIterator(XPathContext context) throws XPathException {
        GroupIterator groupIterator;
        SequenceIterator<? extends Item> population = this.select.iterate(context);
        switch (this.algorithm) {
            case 0: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                XPathContextMinor c2 = context.newMinorContext();
                c2.setCurrentIterator(population);
                groupIterator = new GroupByIterator(population, this.key, c2, coll);
                break;
            }
            case 1: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                groupIterator = new GroupAdjacentIterator(population, this.key, context, coll);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeyDefinitions != null) {
            AtomicComparer[] comps = this.sortComparators;
            XPathContextMinor xpc = context.newMinorContext();
            if (comps == null) {
                comps = new AtomicComparer[this.sortKeyDefinitions.length];
                for (int s = 0; s < this.sortKeyDefinitions.length; ++s) {
                    comps[s] = this.sortKeyDefinitions[s].makeComparator(xpc);
                }
            }
            groupIterator = new SortedGroupIterator(xpc, groupIterator, this, comps);
        }
        return groupIterator;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        GroupIterator master = this.getGroupIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(master);
        c2.setCurrentGroupIterator(master);
        c2.setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, c2);
    }

    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.action.iterate(context);
    }

    @Override
    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        return (AtomicValue)this.sortKeyDefinitions[n].getSortKey().evaluateItem(c);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("forEachGroup");
        out.emitAttribute("algorithm", ForEachGroup.getAlgorithmName(this.algorithm));
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("key");
        this.key.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    private static String getAlgorithmName(byte algorithm) {
        switch (algorithm) {
            case 0: {
                return "group-by";
            }
            case 1: {
                return "group-adjacent";
            }
            case 2: {
                return "group-starting-with";
            }
            case 3: {
                return "group-ending-with";
            }
        }
        return "** unknown algorithm **";
    }
}

