/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.tools;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class PunctEquivalenceClasser {
    private static final String[] eolClassRaw = new String[]{".", "?", "!"};
    private static final Set<String> sfClass = new HashSet<String>(Arrays.asList(eolClassRaw));
    private static final String[] colonClassRaw = new String[]{":", ";", "-", "_"};
    private static final Set<String> colonClass = new HashSet<String>(Arrays.asList(colonClassRaw));
    private static final String[] commaClassRaw = new String[]{",", "\u0631"};
    private static final Set<String> commaClass = new HashSet<String>(Arrays.asList(commaClassRaw));
    private static final String[] currencyClassRaw = new String[]{"$", "#", "="};
    private static final Set<String> currencyClass = new HashSet<String>(Arrays.asList(currencyClassRaw));
    private static final Pattern pEllipsis = Pattern.compile("\\.\\.+");
    private static final String[] slashClassRaw = new String[]{"/", "\\"};
    private static final Set<String> slashClass = new HashSet<String>(Arrays.asList(slashClassRaw));
    private static final String[] lBracketClassRaw = new String[]{"-LRB-", "(", "[", "<"};
    private static final Set<String> lBracketClass = new HashSet<String>(Arrays.asList(lBracketClassRaw));
    private static final String[] rBracketClassRaw = new String[]{"-RRB-", ")", "]", ">"};
    private static final Set<String> rBracketClass = new HashSet<String>(Arrays.asList(rBracketClassRaw));
    private static final String[] quoteClassRaw = new String[]{"\"", "``", "''", "'", "`"};
    private static final Set<String> quoteClass = new HashSet<String>(Arrays.asList(quoteClassRaw));

    public static String getPunctClass(String punc) {
        if (punc.equals("%") || punc.equals("-PLUS-")) {
            return "perc";
        }
        if (punc.startsWith("*")) {
            return "bullet";
        }
        if (sfClass.contains(punc)) {
            return "sf";
        }
        if (colonClass.contains(punc) || pEllipsis.matcher(punc).matches()) {
            return "colon";
        }
        if (commaClass.contains(punc)) {
            return "comma";
        }
        if (currencyClass.contains(punc)) {
            return "curr";
        }
        if (slashClass.contains(punc)) {
            return "slash";
        }
        if (lBracketClass.contains(punc)) {
            return "lrb";
        }
        if (rBracketClass.contains(punc)) {
            return "rrb";
        }
        if (quoteClass.contains(punc)) {
            return "quote";
        }
        return "";
    }
}

