/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.Type3StreamParser;

public class PDType3Font
extends PDSimpleFont {
    private Map images = new HashMap();

    public PDType3Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE3);
    }

    public PDType3Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    private Image createImageIfNecessary(char character) throws IOException {
        COSDictionary charProcs;
        COSStream stream;
        Character c = new Character(character);
        Image retval = (Image)this.images.get(c);
        if (retval == null && (stream = (COSStream)(charProcs = (COSDictionary)this.font.getDictionaryObject(COSName.CHAR_PROCS)).getDictionaryObject(COSName.getPDFName("" + character))) != null) {
            Type3StreamParser parser = new Type3StreamParser();
            retval = parser.createImage(stream);
            this.images.put(c, retval);
        }
        return retval;
    }

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Image image = this.createImageIfNecessary(c);
            if (image == null) continue;
            int newWidth = (int)(0.12 * (double)image.getWidth(null));
            int newHeight = (int)(0.12 * (double)image.getHeight(null));
            if (newWidth <= 0 || newHeight <= 0) continue;
            image = image.getScaledInstance(newWidth, newHeight, 4);
            g.drawImage(image, (int)x, (int)y, null);
            x += (float)newWidth;
        }
    }

    public void setFontMatrix(PDMatrix matrix) {
        this.font.setItem("FontMatrix", (COSObjectable)matrix);
    }
}

