# Generated by default/object.tt
package Paws::CloudFront::FunctionAssociation;
  use Moose;
  has EventType => (is => 'ro', isa => 'Str', required => 1);
  has FunctionARN => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::FunctionAssociation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::FunctionAssociation object:

  $service_obj->Method(Att1 => { EventType => $value, ..., FunctionARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::FunctionAssociation object:

  $result = $service_obj->Method(...);
  $result->Att1->EventType

=head1 DESCRIPTION

A CloudFront function that is associated with a cache behavior in a
CloudFront distribution.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EventType => Str

The event type of the function, either C<viewer-request> or
C<viewer-response>. You cannot use origin-facing event types
(C<origin-request> and C<origin-response>) with a CloudFront function.


=head2 B<REQUIRED> FunctionARN => Str

The Amazon Resource Name (ARN) of the function.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

