# Generated by default/object.tt
package Paws::SSMContacts::ContactTargetInfo;
  use Moose;
  has ContactId => (is => 'ro', isa => 'Str');
  has IsEssential => (is => 'ro', isa => 'Bool', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::ContactTargetInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::ContactTargetInfo object:

  $service_obj->Method(Att1 => { ContactId => $value, ..., IsEssential => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::ContactTargetInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactId

=head1 DESCRIPTION

The contact that Incident Manager is engaging during an incident.

=head1 ATTRIBUTES


=head2 ContactId => Str

The Amazon Resource Name (ARN) of the contact.


=head2 B<REQUIRED> IsEssential => Bool

A Boolean value determining if the contact's acknowledgement stops the
progress of stages in the plan.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

