#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::Tools::Hardware;
use FusionInventory::Test::Hardware;

my %tests = (
    'alcatel/unknown.1.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'E8:E7:32:2B:C1:E2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'E8:E7:32:2B:C1:E2',
            MODELSNMP    => 'Networking2189',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                COMMENTS        => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                SERIAL          => 'M4682816',
                ID              => undef,
                CONTACT         => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                UPTIME          => '(1442631100) 166 days, 23:18:31.00',
                NAME            => 'CB-C005-127-os6400',
                TYPE            => 'NETWORKING',
                MAC             => 'E8:E7:32:2B:C1:E2',
                MANUFACTURER    => 'Alcatel-Lucent',
                MODEL           => 'OS6400-P24',
                FIRMWARE        => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                IPS             => {
                    IP => [
                        '127.0.0.1',
                        '192.168.1.127'
                    ]
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFMTU            => '9216',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:E4',
                        IFNAME           => '1/1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1001',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0'
                    },
                    {
                        IFMTU            => '9216',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFNAME           => '1/2',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:E5',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFNUMBER         => '1002',
                        IFLASTCHANGE     => '(7100) 0:01:11.00'
                    },
                    {
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFNUMBER         => '1003',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNAME           => '1/3',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:E6',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFSPEED          => '0',
                        IFMTU            => '9216'
                    },
                    {
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        IFOUTOCTETS      => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:E7',
                    },
                    {
                        IFNAME           => '1/5',
                        MAC              => 'E8:E7:32:2B:C1:E8',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1005',
                        IFMTU            => '9216',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFSPEED          => '0'
                    },
                    {
                        IFNAME           => '1/6',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:E9',
                        IFOUTOCTETS      => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFNUMBER         => '1006',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFMTU            => '9216',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0'
                    },
                    {
                        IFNAME           => '1/7',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:EA',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1007',
                        IFMTU            => '9216',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0'
                    },
                    {
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFNUMBER         => '1008',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNAME           => '1/8',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:EB',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFMTU            => '9216'
                    },
                    {
                        MAC              => 'E8:E7:32:2B:C1:EC',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFNAME           => '1/9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1009',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFMTU            => '9216',
                        IFSPEED          => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFINOCTETS       => '0'
                    },
                    {
                        IFMTU            => '9216',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFSPEED          => '0',
                        IFNAME           => '1/10',
                        MAC              => 'E8:E7:32:2B:C1:ED',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1010'
                    },
                    {
                        IFNAME           => '1/11',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:EE',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFNUMBER         => '1011',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFMTU            => '9216',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFSPEED          => '0'
                    },
                    {
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFNUMBER         => '1012',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNAME           => '1/12',
                        MAC              => 'E8:E7:32:2B:C1:EF',
                        IFTYPE           => 'ethernetCsmacd(6)'
                    },
                    {
                        IFNAME           => '1/13',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:F0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1013',
                        IFMTU            => '9216',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFSPEED          => '0'
                    },
                    {
                        IFNUMBER         => '1014',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFOUTOCTETS      => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        MAC              => 'E8:E7:32:2B:C1:F1',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFNAME           => '1/14',
                        IFSPEED          => '0',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFMTU            => '9216'
                    },
                    {
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:F2',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFMTU            => '9216'
                    },
                    {
                        IFNAME           => '1/16',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:F3',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFNUMBER         => '1016',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFMTU            => '9216',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0'
                    },
                    {
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFINOCTETS       => '0',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        MAC              => 'E8:E7:32:2B:C1:F4',
                        IFTYPE           => 'ethernetCsmacd(6)'
                    },
                    {
                        IFMTU            => '9216',
                        IFSPEED          => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFINOCTETS       => '0',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:F5',
                        IFNAME           => '1/18',
                        IFNUMBER         => '1018',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFSPEED          => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFINOCTETS       => '0',
                        IFMTU            => '9216',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1019',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFOUTOCTETS      => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        MAC              => 'E8:E7:32:2B:C1:F6',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        IFNAME           => '1/19'
                    },
                    {
                        IFINOCTETS       => '2695194882',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'up(1)',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462639524',
                        IFOUTERRORS      => '0',
                        IFNUMBER         => '1020',
                        IFLASTCHANGE     => '(1009388000) 116 days, 19:51:20.00',
                        IFNAME           => '1/20',
                        MAC              => 'E8:E7:32:2B:C1:F7',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:6F:47:52:F9',
                                    '00:25:4B:71:76:EC',
                                    '10:93:E9:0F:D7:CC',
                                    'C4:85:08:3C:04:B0',
                                    '14:10:9F:D1:9A:DB',
                                    'D8:24:BD:E8:79:20',
                                    'F0:B4:79:15:A4:03',
                                    '28:94:0F:D6:BD:94',
                                    '4C:0F:6E:FE:E9:78',
                                    '54:26:96:09:33:A4'
                                ]
                            }
                        },
                    },
                    {
                        IFINOCTETS       => '2824635082',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        IFOUTOCTETS      => '464602515',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'up(1)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(1441734300) 166 days, 20:49:03.00',
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        MAC              => 'E8:E7:32:2B:C1:F8',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '98:0C:82:C9:D4:70',
                                    'D8:24:BD:B4:92:C0',
                                    '28:94:0F:C1:1C:3B'
                                ]
                            }
                        },
                    },
                    {
                        IFMTU            => '9216',
                        IFSPEED          => '1000000000',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFINOCTETS       => '1952393561',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:F9',
                        IFNAME           => '1/22',
                        IFNUMBER         => '1022',
                        IFLASTCHANGE     => '(492727000) 57 days, 0:41:10.00',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'up(1)',
                        IFOUTOCTETS      => '211370716',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0C:EE:E6:B0:86:7A',
                                    '7C:D1:C3:F7:D7:C3',
                                    '98:B8:E3:66:FD:2C',
                                    'D8:24:BD:B4:92:B0',
                                    'DC:85:DE:69:44:24',
                                    '28:94:0F:C1:1D:89',
                                    '28:CF:DA:48:1F:4B'
                                ]
                            }
                        },
                    },
                    {
                        IFNAME           => '1/23',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:FA',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '0',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFNUMBER         => '1023',
                        IFMTU            => '9216',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFSPEED          => '0'
                    },
                    {
                        IFINOCTETS       => '826699557',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFOUTOCTETS      => '3448622558',
                        IFSTATUS         => 'up(1)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(128821500) 14 days, 21:50:15.00',
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFTYPE           => 'ethernetCsmacd(6)',
                        MAC              => 'E8:E7:32:2B:C1:FB',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5E:00:01:02',
                                    '00:0B:5F:CC:D8:80',
                                    '00:0B:5F:CC:D8:81',
                                    '00:80:9F:AF:B1:10',
                                    '00:80:9F:AF:B1:11',
                                    '00:80:9F:AF:B1:15',
                                    '00:80:9F:AF:B1:1B',
                                    '00:80:9F:AF:B1:2E',
                                    '00:80:9F:AF:B1:32',
                                    '00:80:9F:B3:AA:8D',
                                    '00:80:9F:B3:AA:8E',
                                    '00:80:9F:B3:AA:8F',
                                    '00:80:9F:B3:AA:93',
                                    '00:80:9F:B3:AA:95',
                                    '00:80:9F:B3:AA:96',
                                    '00:80:9F:B3:AA:99',
                                    '00:80:9F:B3:AA:9C',
                                    '00:80:9F:B3:AA:9D',
                                    '00:80:9F:B3:AA:A1',
                                    '00:80:9F:B3:AA:A2',
                                    '00:80:9F:B3:AA:A6',
                                    '00:80:9F:B3:AA:A8',
                                    '00:80:9F:B3:AD:51',
                                    '00:80:9F:B3:AD:5C',
                                    '00:80:9F:BA:8B:D2',
                                    '00:80:9F:BA:8D:90',
                                    '00:80:9F:BA:8D:91',
                                    '00:80:9F:BA:8D:D4',
                                    '00:80:9F:BA:8D:D5',
                                    '00:0D:BC:BD:66:D8',
                                    '00:88:65:A9:B5:E3',
                                    '00:13:5F:FA:ED:70',
                                    '00:13:5F:FA:ED:F0',
                                    '00:13:5F:FA:ED:20',
                                    '00:13:5F:FA:EE:90',
                                    '00:13:5F:FA:EE:F0',
                                    '00:13:5F:FA:EE:20',
                                    '00:13:5F:FA:EE:50',
                                    '00:13:5F:FA:EF:90',
                                    '00:13:5F:FA:F0:80',
                                    '00:13:5F:FA:F1:90',
                                    '00:13:5F:FA:F1:A0',
                                    '00:13:5F:FA:F1:30',
                                    '00:13:5F:FA:F2:00',
                                    '00:13:5F:FA:F2:A0',
                                    '00:13:5F:FA:F2:50',
                                    '00:13:5F:FA:F3:20',
                                    '00:13:5F:FA:F4:80',
                                    '00:13:5F:FA:F4:D0',
                                    '00:13:5F:FA:F5:70',
                                    '00:13:5F:FA:F6:C0',
                                    '00:13:5F:FA:F7:20',
                                    '00:13:5F:FA:F8:50',
                                    '00:13:5F:FA:F9:A0',
                                    '00:13:5F:FA:F9:B0',
                                    '00:13:5F:FA:F9:E0',
                                    '00:13:5F:FA:FA:50',
                                    '00:13:5F:FA:FA:60',
                                    '00:13:5F:FA:FB:80',
                                    '00:13:5F:FA:FB:B0',
                                    '00:13:5F:FA:FB:60',
                                    '00:13:5F:FA:FC:80',
                                    '00:13:5F:FA:FC:D0',
                                    '00:14:6A:D6:B1:76',
                                    '00:14:6A:D6:B1:94',
                                    '00:14:6A:D6:B1:AA',
                                    '00:14:6A:D6:B1:B6',
                                    '00:14:6A:D6:B1:B8',
                                    '00:14:6A:D6:B1:C4',
                                    '00:14:6A:D6:B1:CE',
                                    '00:14:6A:D6:B1:D8',
                                    '00:14:6A:D6:B1:E8',
                                    '00:14:6A:D6:B1:28',
                                    '00:14:6A:D6:B1:32',
                                    '00:14:6A:D6:B1:42',
                                    '00:14:6A:D6:B1:48',
                                    '00:14:6A:D6:B1:4E',
                                    '00:14:6A:D6:B1:56',
                                    '00:14:6A:D6:B1:62',
                                    '00:14:6A:D6:B2:68',
                                    '00:14:6A:D6:B2:8E',
                                    '00:14:6A:D6:B2:B8',
                                    '00:14:6A:D6:B2:BA',
                                    '00:14:6A:D6:B2:C0',
                                    '00:14:6A:D6:B2:14',
                                    '00:14:6A:D6:B2:CE',
                                    '00:14:6A:D6:B2:D0',
                                    '00:14:6A:D6:B2:F0',
                                    '00:14:6A:D6:B2:F4',
                                    '00:14:6A:D6:B2:FA',
                                    '00:14:6A:D6:B2:1E',
                                    '00:14:6A:D6:B2:32',
                                    '00:14:6A:D6:B2:5C',
                                    '00:14:6A:D6:B3:14',
                                    '00:14:6A:D6:B3:1E',
                                    '00:D0:95:17:51:A3',
                                    '00:D0:95:3E:96:83',
                                    '00:15:AF:B4:88:3A',
                                    '00:15:F2:D5:B3:F6',
                                    '00:16:D4:50:F1:FF',
                                    '00:16:EA:28:EF:7C',
                                    '00:17:C4:65:E1:CB',
                                    '00:17:C4:AE:C8:B8',
                                    '00:18:DE:E1:43:BF',
                                    '00:F4:B9:53:B7:A2',
                                    '00:19:D1:92:0C:4C',
                                    '00:1B:77:DF:5D:E1',
                                    '00:1B:77:49:52:59',
                                    '00:1B:A9:A2:A8:8E',
                                    '00:1B:B1:A0:48:B8',
                                    '00:1B:B1:A6:13:A2',
                                    '00:1B:B1:4A:51:47',
                                    '00:1B:B1:4C:10:34',
                                    '00:1B:63:CB:45:98',
                                    '00:1C:B3:BC:B5:F0',
                                    '00:1C:B3:C4:7E:68',
                                    '00:1C:BF:B3:31:73',
                                    '00:1C:C0:D8:8D:7F',
                                    '00:1E:64:0A:41:AE',
                                    '00:1E:64:35:1C:38',
                                    '00:1E:64:3C:E3:80',
                                    '00:1E:65:EB:75:C0',
                                    '00:1E:65:2C:6C:AA',
                                    '00:1E:C2:AE:F4:C5',
                                    '00:1E:C2:C4:92:49',
                                    '00:1E:4C:13:CE:44',
                                    '00:1E:52:6F:AA:33',
                                    '00:1E:52:C8:8F:81',
                                    '00:1F:3C:A5:CC:EF',
                                    '00:1F:3C:E1:9A:87',
                                    '00:1F:5B:C1:0E:17',
                                    '00:1F:5B:D7:41:1F',
                                    '00:20:A6:49:7E:D7',
                                    '00:20:A6:49:7E:DA',
                                    '00:20:A6:49:7E:F8',
                                    '00:20:A6:49:7E:FB',
                                    '00:20:A6:49:7F:04',
                                    '00:20:A6:49:7F:07',
                                    '00:21:00:30:65:1C',
                                    '00:21:6A:0F:10:68',
                                    '00:21:6A:B6:86:96',
                                    '00:21:6B:C7:95:50',
                                    '00:21:6B:31:E5:88',
                                    '00:21:E9:DB:C8:5C',
                                    '00:21:5D:AC:05:C0',
                                    '00:21:5D:08:76:58',
                                    '00:22:FA:31:CD:40',
                                    '00:22:FB:60:9A:40',
                                    '00:22:41:86:60:D7',
                                    '00:22:41:F6:E1:0F',
                                    '00:22:41:28:17:55',
                                    '00:22:43:70:AC:5F',
                                    '00:22:43:25:F8:02',
                                    '00:22:4D:47:F6:65',
                                    '00:22:5F:36:13:A2',
                                    '00:23:6C:7A:2D:67',
                                    '00:23:6C:82:7A:E6',
                                    '00:23:6C:85:B9:61',
                                    '00:23:6C:89:6F:5E',
                                    '00:23:6C:8A:00:B0',
                                    '00:23:6C:8A:56:09',
                                    '00:23:6C:8B:88:6C',
                                    '00:23:6C:8B:1C:A2',
                                    '00:23:6C:94:C6:40',
                                    '00:23:6C:99:48:86',
                                    '00:23:6C:09:BB:50',
                                    '00:23:12:0D:33:DC',
                                    '00:23:12:02:DC:D6',
                                    '00:23:12:57:99:6E',
                                    '00:23:14:1B:A7:D0',
                                    '00:23:14:3E:A1:2C',
                                    '00:23:14:56:47:D8',
                                    '00:23:4D:4F:93:97',
                                    '00:23:4E:D7:2A:75',
                                    '00:23:08:A4:E8:EC',
                                    '00:24:BE:B6:4C:20',
                                    '00:24:D6:0A:D1:94',
                                    '00:24:D6:98:03:5A',
                                    '00:24:D6:06:E2:64',
                                    '00:25:00:37:19:E8',
                                    '00:25:00:3D:C4:72',
                                    '00:25:00:3F:7C:C5',
                                    '00:25:00:3F:1D:F0',
                                    '00:25:00:46:71:2C',
                                    '00:25:00:4F:12:88',
                                    '00:25:D3:79:55:24',
                                    '00:25:D3:87:4F:AF',
                                    '00:25:D3:D4:3E:20',
                                    '00:25:D3:D4:52:D1',
                                    '00:25:D3:3F:65:6B',
                                    '00:25:D3:45:A2:E3',
                                    '00:25:D3:45:A7:EC',
                                    '00:25:D3:5F:26:09',
                                    '00:25:4B:85:A6:4F',
                                    '00:25:4B:8F:61:CB',
                                    '00:25:4B:92:CA:A1',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:B0:C7',
                                    '00:26:82:A0:97:B6',
                                    '00:26:B0:BE:84:A0',
                                    '00:26:B0:F1:25:3E',
                                    '00:26:B0:1F:07:4F',
                                    '00:26:B6:66:E9:D5',
                                    '00:26:B6:84:64:AB',
                                    '00:26:B6:97:D1:99',
                                    '00:26:B6:C3:A6:C5',
                                    '00:26:BB:10:3A:02',
                                    '00:26:BB:15:DD:9F',
                                    '00:26:BB:18:80:63',
                                    '00:26:BB:18:B3:2B',
                                    '00:26:BB:1B:AD:65',
                                    '00:26:BB:03:A5:36',
                                    '00:26:C7:A7:38:9A',
                                    '00:26:C7:B2:ED:F0',
                                    '00:26:C7:C1:70:1E',
                                    '00:26:4D:43:92:01',
                                    '00:26:4D:59:B3:5C',
                                    '00:26:08:E6:73:9A',
                                    '00:26:08:E6:9D:2D',
                                    '00:26:08:E7:21:BF',
                                    '00:26:08:E7:24:C3',
                                    '00:26:08:E7:38:0B',
                                    '00:26:08:EC:E3:96',
                                    '00:26:08:F5:87:FB',
                                    '00:26:08:F7:BA:9E',
                                    '00:26:08:F7:21:3F',
                                    '00:26:5E:F7:45:0E',
                                    '00:26:5E:37:43:99',
                                    '00:27:10:F2:A3:18',
                                    '00:27:10:42:50:14',
                                    '00:07:E9:06:A6:BE',
                                    '00:08:CA:9C:CD:84',
                                    '00:08:CA:9E:57:E1',
                                    '00:08:CA:E6:B3:26',
                                    '00:08:CA:E7:2F:6B',
                                    '00:08:CA:21:42:9D',
                                    '00:08:CA:43:CF:1B',
                                    '00:08:CA:46:9B:A1',
                                    '00:50:56:B7:2C:4E',
                                    '00:09:3D:00:73:29',
                                    '00:09:43:08:EA:D8',
                                    '64:A3:CB:BF:57:F0',
                                    '64:B9:E8:1A:CC:0D',
                                    '64:B9:E8:08:75:6D',
                                    '68:96:7B:30:09:60',
                                    '68:A3:C4:85:93:FC',
                                    '68:A3:C4:DB:F2:5E',
                                    '68:A3:C4:DD:E6:21',
                                    '68:A3:C4:E2:5E:03',
                                    '68:A3:C4:25:2F:4D',
                                    '68:A3:C4:32:76:C6',
                                    '68:A3:C4:37:E4:6A',
                                    '68:A8:6D:0C:E4:12',
                                    '68:A8:6D:10:EA:2E',
                                    '68:A8:6D:25:C9:0C',
                                    '68:A8:6D:04:A4:5E',
                                    '68:A8:6D:2A:55:CC',
                                    '68:A8:6D:37:C5:D8',
                                    '68:A8:6D:37:37:F2',
                                    '68:A8:6D:42:20:3C',
                                    '68:A8:6D:42:5E:84',
                                    '68:A8:6D:45:C1:1E',
                                    '68:A8:6D:45:1F:2A',
                                    '68:A8:6D:4A:F8:A0',
                                    '68:A8:6D:56:12:22',
                                    '68:09:27:F1:C9:B9',
                                    '70:D4:F2:A1:27:D7',
                                    '70:DE:E2:88:51:43',
                                    '70:F1:A1:89:2A:2B',
                                    '70:F1:A1:DA:A6:9E',
                                    '70:F1:A1:16:56:86',
                                    '70:F1:A1:ED:42:B7',
                                    '70:F3:95:B5:4C:E4',
                                    '70:F3:95:36:76:93',
                                    '70:1A:04:EF:CD:F4',
                                    '70:1A:04:34:27:90',
                                    '70:1A:04:36:F0:B2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:B9:17',
                                    '70:56:81:8D:CA:91',
                                    '70:56:81:8F:79:69',
                                    '70:56:81:92:9E:31',
                                    '70:56:81:9C:A2:85',
                                    '70:56:81:9C:E7:D9',
                                    '70:56:81:9C:EF:EF',
                                    '70:56:81:9D:15:39',
                                    '70:56:81:AA:68:11',
                                    '70:56:81:AA:BF:85',
                                    '70:56:81:AC:22:8B',
                                    '70:56:81:AC:33:81',
                                    '70:56:81:B6:2E:8D',
                                    '70:56:81:B8:55:93',
                                    '74:DE:2B:69:96:FF',
                                    '74:DE:2B:9D:1C:45',
                                    '74:DE:2B:C4:EA:49',
                                    '74:DE:2B:17:35:B6',
                                    '74:DE:2B:F3:5C:74',
                                    '74:DE:2B:25:DD:18',
                                    '74:E2:F5:C0:BC:72',
                                    '74:E2:F5:04:09:4E',
                                    '74:E5:43:A4:1A:43',
                                    '74:E5:43:A4:04:C6',
                                    '74:E5:43:11:63:E6',
                                    '74:E5:43:BB:6B:70',
                                    '74:E5:43:08:6C:20',
                                    '74:F0:6D:8B:D9:D9',
                                    '74:F0:6D:0E:09:1E',
                                    '74:F0:6D:22:AE:2E',
                                    '74:F0:6D:30:05:D2',
                                    '74:F0:6D:50:CE:CE',
                                    '74:F0:6D:53:3F:C2',
                                    '74:F0:6D:55:AD:68',
                                    '74:F0:6D:09:69:1B',
                                    '74:2F:68:8A:3A:33',
                                    '74:2F:68:8C:33:9F',
                                    '74:2F:68:A5:6F:D4',
                                    '74:2F:68:CC:B5:06',
                                    '74:2F:68:CD:75:49',
                                    '74:2F:68:30:DE:80',
                                    '74:2F:68:31:5A:C5',
                                    '74:2F:68:32:A3:59',
                                    '74:2F:68:33:DD:F7',
                                    '74:2F:68:33:EB:50',
                                    '74:2F:68:4B:11:49',
                                    '0C:74:C2:0E:7A:9F',
                                    '0C:74:C2:90:F5:28',
                                    '0C:74:C2:4F:7C:34',
                                    '0C:77:1A:1F:D9:78',
                                    '0C:D2:92:03:0D:7C',
                                    '0C:D2:92:03:DA:6D',
                                    '0C:EE:E6:BF:51:76',
                                    '0C:EE:E6:FE:4F:18',
                                    '0C:60:76:44:92:09',
                                    '0C:60:76:59:62:D0',
                                    '78:6C:1C:BD:E1:F4',
                                    '78:92:9C:29:8F:62',
                                    '78:92:9C:06:FD:A2',
                                    '78:CA:39:A4:E8:4D',
                                    '78:CA:39:AE:65:DF',
                                    '78:CA:39:AE:9E:D0',
                                    '78:CA:39:B0:1F:F1',
                                    '78:CA:39:B1:19:54',
                                    '78:CA:39:B1:34:D9',
                                    '78:CA:39:B3:F3:79',
                                    '78:CA:39:B8:3D:CB',
                                    '78:CA:39:B8:5C:E1',
                                    '78:CA:39:B9:CC:16',
                                    '78:CA:39:B9:D0:D2',
                                    '78:CA:39:BA:57:D3',
                                    '78:CA:39:BB:24:E3',
                                    '78:CA:39:BC:D1:44',
                                    '78:CA:39:BD:55:20',
                                    '78:CA:39:BE:3D:5B',
                                    '78:CA:39:34:B2:B6',
                                    '78:CA:39:40:F7:96',
                                    '78:DD:08:D4:B1:D2',
                                    '78:DD:08:E1:36:9D',
                                    '78:DD:08:F6:36:47',
                                    '78:E4:00:88:41:6D',
                                    '78:E4:00:91:82:D4',
                                    '78:E4:00:04:A9:7F',
                                    '7C:11:BE:B2:42:08',
                                    '7C:C3:A1:0B:AD:EB',
                                    '7C:C5:37:92:85:85',
                                    '7C:C5:37:BF:34:60',
                                    '7C:C5:37:07:1B:A7',
                                    '7C:D1:C3:6C:BE:9A',
                                    '7C:D1:C3:70:EF:8E',
                                    '7C:D1:C3:75:A7:84',
                                    '7C:D1:C3:83:52:6C',
                                    '7C:D1:C3:89:AE:F2',
                                    '7C:D1:C3:95:46:B6',
                                    '7C:D1:C3:98:70:E2',
                                    '7C:D1:C3:99:00:42',
                                    '7C:D1:C3:9A:80:60',
                                    '7C:D1:C3:9A:84:7A',
                                    '7C:D1:C3:9C:3F:24',
                                    '7C:D1:C3:EB:E0:CD',
                                    '7C:D1:C3:EC:1A:CB',
                                    '7C:D1:C3:EC:09:FF',
                                    '7C:D1:C3:F1:BC:35',
                                    '7C:D1:C3:F4:E7:89',
                                    '7C:D1:C3:F5:17:51',
                                    '7C:D1:C3:F6:DC:15',
                                    '7C:E9:D3:6D:8C:D2',
                                    '7C:61:93:F5:37:96',
                                    '80:60:07:78:5A:21',
                                    '80:60:07:DC:F3:C9',
                                    '84:00:D2:BC:D3:1A',
                                    '84:85:06:77:86:FC',
                                    '84:85:06:18:68:9E',
                                    '84:A6:C8:0D:D4:F5',
                                    '84:A6:C8:5D:B1:E1',
                                    '84:29:99:79:AD:8D',
                                    '84:29:99:54:32:C6',
                                    '84:4B:F5:C2:6E:59',
                                    '84:4B:F5:CA:B4:7D',
                                    '84:4B:F5:26:B7:86',
                                    '84:4B:F5:4C:34:8B',
                                    '84:4B:F5:54:9F:03',
                                    '88:9F:FA:69:D8:51',
                                    '88:9F:FA:03:FA:4C',
                                    '88:9F:FA:28:92:AE',
                                    '88:53:2E:B2:E0:6C',
                                    '8C:7B:9D:D5:C5:82',
                                    '8C:7B:9D:D5:E8:55',
                                    '8C:89:A5:3A:B8:84',
                                    '8C:89:A5:3A:BA:1A',
                                    '8C:A9:82:14:56:C6',
                                    '8C:2D:AA:76:59:6B',
                                    '8C:2D:AA:77:CF:91',
                                    '90:00:4E:91:AB:B3',
                                    '90:00:4E:61:24:43',
                                    '90:84:0D:78:95:D2',
                                    '90:84:0D:F5:53:4F',
                                    '90:A4:DE:72:C0:91',
                                    '90:A4:DE:C1:FE:0E',
                                    '90:FB:A6:9E:ED:CF',
                                    '90:27:E4:13:A6:10',
                                    '90:27:E4:EB:6F:DC',
                                    '90:27:E4:ED:4A:3A',
                                    '90:27:E4:F2:2D:90',
                                    '90:27:E4:F3:97:2F',
                                    '90:27:E4:F3:A8:87',
                                    '90:27:E4:F5:4D:6B',
                                    '90:27:E4:F7:31:30',
                                    '90:27:E4:FD:40:FC',
                                    '90:4C:E5:A2:55:E6',
                                    '90:4C:E5:A9:C2:E9',
                                    '94:DB:C9:99:32:1C',
                                    '94:DB:C9:A2:C4:2B',
                                    '94:DB:C9:B1:DB:01',
                                    '94:DB:C9:E0:DF:51',
                                    '94:39:E5:B0:54:4F',
                                    '94:39:E5:B5:6F:C5',
                                    '98:0C:82:B3:C2:39',
                                    '98:0C:82:CC:01:2C',
                                    '98:0C:82:5B:71:FF',
                                    '98:FE:94:3F:C8:94',
                                    '98:FE:94:41:65:D4',
                                    '98:FE:94:45:B6:8C',
                                    '98:FE:94:47:36:3E',
                                    '98:FE:94:4A:BF:8E',
                                    '98:03:D8:B7:D8:F9',
                                    '9C:B7:0D:7B:D3:67',
                                    '9C:B7:0D:7B:2F:A3',
                                    '9C:B7:0D:D2:C1:A9',
                                    '9C:B7:0D:1C:44:41',
                                    '9C:B7:0D:39:B9:7A',
                                    '9C:04:EB:66:46:67',
                                    '9C:4E:36:53:76:74',
                                    '9C:4E:36:58:D0:94',
                                    '10:93:E9:03:64:CC',
                                    '10:93:E9:04:E0:C6',
                                    '10:93:E9:5D:4A:43',
                                    '10:93:E9:5E:37:5E',
                                    '10:9A:DD:0C:43:62',
                                    '10:9A:DD:A5:32:33',
                                    '10:9A:DD:B2:FB:61',
                                    '10:9A:DD:C2:42:39',
                                    '10:BF:48:D0:57:57',
                                    '10:40:F3:7B:BC:78',
                                    '10:40:F3:80:06:34',
                                    '10:40:F3:86:39:6E',
                                    '10:40:F3:8D:83:0C',
                                    '10:40:F3:8D:85:32',
                                    '10:40:F3:8F:16:90',
                                    '10:40:F3:99:50:8E',
                                    '10:40:F3:9C:35:AC',
                                    '10:40:F3:A5:45:30',
                                    '10:40:F3:A7:95:8E',
                                    '10:40:F3:A7:42:56',
                                    '10:40:F3:EF:BA:BE',
                                    'A4:D1:D2:82:1A:A7',
                                    'A4:D1:D2:AC:32:1B',
                                    'A4:D1:D2:35:43:BE',
                                    'A4:D1:D2:45:1B:FE',
                                    'A8:26:D9:E9:D6:63',
                                    'AC:72:89:4E:76:4A',
                                    'AC:81:12:8C:A2:10',
                                    'AC:81:12:24:67:35',
                                    'AC:81:12:2F:8B:B4',
                                    'AC:81:12:47:D1:A5',
                                    'B0:65:BD:01:F6:C9',
                                    'B0:65:BD:6B:7B:A9',
                                    'B0:65:BD:60:12:7D',
                                    'B0:65:BD:60:60:17',
                                    '12:41:9B:00:62:FA',
                                    'B4:74:9F:7C:55:EC',
                                    'B4:14:89:38:2D:93',
                                    'B4:F0:AB:B1:4A:7F',
                                    'B8:8D:12:0C:3F:3A',
                                    'B8:8D:12:0D:49:64',
                                    'B8:8D:12:0E:52:86',
                                    'B8:8D:12:10:9F:4E',
                                    'B8:8D:12:10:4B:3A',
                                    'B8:8D:12:12:F6:E8',
                                    'B8:8D:12:16:E3:7C',
                                    'B8:8D:12:1A:E9:6A',
                                    'B8:8D:12:1B:DC:1A',
                                    'B8:8D:12:1C:58:A6',
                                    'B8:8D:12:1E:21:1E',
                                    'B8:8D:12:20:04:78',
                                    'B8:8D:12:22:FC:E2',
                                    'B8:8D:12:2B:08:6C',
                                    'B8:8D:12:2E:C4:C0',
                                    'B8:8D:12:05:12:56',
                                    'B8:8D:12:34:99:32',
                                    'B8:8D:12:34:B1:84',
                                    'B8:8D:12:34:F5:A2',
                                    'B8:8D:12:38:FA:6A',
                                    'B8:8D:12:39:D7:E4',
                                    'B8:8D:12:39:F9:E4',
                                    'B8:8D:12:06:D5:74',
                                    'B8:8D:12:40:21:AE',
                                    'B8:8D:12:07:FC:32',
                                    'B8:AC:6F:94:57:ED',
                                    'B8:C7:5D:3C:D9:AB',
                                    'B8:F6:B1:A7:F2:7C',
                                    'B8:F6:B1:11:0F:0D',
                                    'B8:FF:61:B1:90:D6',
                                    'B8:03:05:2C:68:02',
                                    'BC:3B:AF:6D:10:85',
                                    'BC:52:B7:25:17:C9',
                                    'C0:9F:42:52:9A:5E',
                                    'C0:CB:38:01:35:18',
                                    'C0:18:85:6F:2C:56',
                                    'C0:18:85:79:24:E7',
                                    'C0:F8:DA:A7:E9:FE',
                                    'C4:64:13:11:23:B9',
                                    'C4:64:13:11:24:D6',
                                    'C4:85:08:69:9C:18',
                                    'C4:85:08:6A:0B:C6',
                                    'C4:85:08:22:D6:93',
                                    'C4:85:08:22:FF:74',
                                    'C4:85:08:24:B8:C3',
                                    'C4:85:08:34:39:74',
                                    'C4:85:08:37:C7:38',
                                    'C4:85:08:41:97:E5',
                                    'C4:85:08:56:D8:D5',
                                    'C4:85:08:57:0C:C4',
                                    'C4:17:FE:B5:48:8A',
                                    'C4:17:FE:55:91:75',
                                    'C4:17:FE:5C:24:68',
                                    'C4:2C:03:00:E7:8C',
                                    'C4:46:19:15:9F:88',
                                    'C4:46:19:5F:74:EF',
                                    '14:74:11:9E:33:49',
                                    '14:8F:C6:8E:63:34',
                                    '14:8F:C6:94:84:B8',
                                    '14:8F:C6:59:D7:CE',
                                    '14:8F:C6:5B:80:FE',
                                    '14:10:9F:CE:46:57',
                                    '14:10:9F:E9:A3:D0',
                                    '14:10:9F:F1:0E:A2',
                                    '14:10:9F:F1:99:A6',
                                    '14:10:9F:F1:9B:5A',
                                    '14:5A:05:A0:F0:A7',
                                    'C8:BC:C8:BC:E7:28',
                                    'C8:BC:C8:CC:8E:85',
                                    'C8:BC:C8:CC:9A:B6',
                                    'C8:BC:C8:CE:3E:88',
                                    'C8:BC:C8:D5:FF:25',
                                    'C8:BC:C8:D7:28:04',
                                    'C8:BC:C8:D9:92:35',
                                    'C8:BC:C8:DD:B7:01',
                                    'C8:BC:C8:DD:E5:56',
                                    'C8:BC:C8:EA:0C:60',
                                    'C8:F7:33:20:A6:89',
                                    'C8:60:00:0D:8F:8B',
                                    'C8:60:00:47:19:6B',
                                    'CC:AF:78:73:A6:A0',
                                    'CC:AF:78:15:18:89',
                                    'CC:AF:78:2A:02:7C',
                                    'CC:AF:78:4D:78:BA',
                                    'CC:08:E0:A2:23:90',
                                    'CC:52:AF:5E:B7:67',
                                    'D0:C1:B1:82:2B:7F',
                                    'D0:DF:9A:71:D8:2D',
                                    'D0:DF:9A:81:09:37',
                                    'D0:DF:9A:94:72:96',
                                    'D0:DF:9A:E3:3D:EE',
                                    'D0:DF:9A:21:F2:97',
                                    'D0:DF:9A:04:4E:4A',
                                    'D0:DF:9A:42:70:90',
                                    'D0:23:DB:E4:A7:32',
                                    'D0:51:62:64:B5:68',
                                    'D4:9A:20:65:3A:98',
                                    'D4:9A:20:66:3F:0D',
                                    'D4:9A:20:66:51:4D',
                                    'D4:9A:20:6B:0E:E8',
                                    'D4:9A:20:6E:1C:23',
                                    'D4:9A:20:71:D6:DB',
                                    'D4:9A:20:71:2D:A5',
                                    'D4:9A:20:72:B8:1E',
                                    'D4:9A:20:72:BA:28',
                                    'D4:9A:20:72:D6:83',
                                    'D4:9A:20:72:E4:7E',
                                    'D4:9A:20:5D:08:9B',
                                    'D8:9E:3F:7D:07:A6',
                                    'D8:A2:5E:8C:88:79',
                                    'D8:A2:5E:8E:FF:28',
                                    'D8:A2:5E:8E:48:C4',
                                    'D8:A2:5E:91:9E:E5',
                                    'D8:A2:5E:91:A1:34',
                                    'D8:A2:5E:91:36:12',
                                    'D8:A2:5E:96:F9:8A',
                                    'D8:A2:5E:97:F7:91',
                                    'D8:A2:5E:98:14:B1',
                                    'D8:A2:5E:13:00:F2',
                                    'D8:24:BD:D4:D3:10',
                                    'D8:24:BD:D4:E0:80',
                                    'D8:24:BD:E8:75:F0',
                                    'D8:24:BD:E8:5D:70',
                                    'D8:30:62:81:6E:9F',
                                    'DC:85:DE:13:B1:7A',
                                    'DC:85:DE:15:D1:21',
                                    'E0:B9:A5:80:12:73',
                                    'E0:B9:A5:83:1B:D5',
                                    'E0:B9:A5:9D:00:F8',
                                    'E0:B9:A5:AE:01:43',
                                    'E0:B9:A5:C5:E8:12',
                                    'E0:B9:A5:CC:81:0D',
                                    'E0:B9:BA:87:F0:31',
                                    'E0:B9:BA:D5:47:BA',
                                    'E0:B9:BA:2B:EB:F0',
                                    'E0:C9:7A:E1:1E:2E',
                                    'E0:CA:94:8D:3E:05',
                                    'E0:CA:94:1D:15:AE',
                                    'E0:CA:94:24:EC:6F',
                                    'E0:CA:94:5E:BE:1A',
                                    'E0:F8:47:12:76:EA',
                                    'E0:F8:47:13:02:B4',
                                    'E0:F8:47:17:B6:38',
                                    'E0:F8:47:1A:4D:48',
                                    'E0:F8:47:1B:F9:00',
                                    'E0:F8:47:2B:8B:44',
                                    'E0:F8:47:35:7B:F6',
                                    'E0:F8:47:39:8F:2C',
                                    'E0:F8:47:39:E3:0E',
                                    'E0:F8:47:43:CC:74',
                                    'E0:2A:82:58:DF:FE',
                                    'E0:06:E6:6A:6C:0E',
                                    'E0:06:E6:93:5B:21',
                                    'E0:06:E6:96:D4:A1',
                                    'E0:06:E6:11:70:B7',
                                    'E0:06:E6:41:D7:D7',
                                    'E0:06:E6:4C:EB:9F',
                                    'E4:CE:8F:0F:1C:64',
                                    'E4:CE:8F:0F:04:58',
                                    'E4:CE:8F:16:FC:00',
                                    'E4:CE:8F:35:BB:F2',
                                    'E4:CE:8F:36:00:EE',
                                    'E4:CE:8F:47:8E:FC',
                                    'E4:CE:8F:4A:BD:8E',
                                    'E4:CE:8F:4B:21:16',
                                    'E4:CE:8F:50:71:0C',
                                    'E4:D5:3D:4C:D7:F7',
                                    'E8:E7:32:27:23:5F',
                                    'E8:E7:32:27:31:02',
                                    'E8:E7:32:27:38:30',
                                    'E8:E7:32:27:63:A0',
                                    'E8:E7:32:27:63:F4',
                                    'E8:E7:32:2A:E0:9E',
                                    'E8:E7:32:2A:E0:B6',
                                    'E8:E7:32:2A:E8:A4',
                                    'E8:E7:32:2A:E8:BC',
                                    'E8:E7:32:2B:CC:E7',
                                    'E8:E7:32:4B:78:F8',
                                    'E8:E7:32:4B:79:13',
                                    'E8:E7:32:4B:7B:B4',
                                    'E8:E7:32:4B:86:DB',
                                    'E8:E7:32:4B:8A:CC',
                                    'E8:E7:32:4B:9B:D8',
                                    'E8:E7:32:5C:BE:B8',
                                    'E8:E7:32:5C:BE:D3',
                                    'E8:03:9A:8B:6D:12',
                                    'E8:39:DF:6C:B3:07',
                                    'E8:39:DF:84:76:CC',
                                    'E8:39:DF:3F:05:C5',
                                    'E8:06:88:64:16:09',
                                    'E8:3E:B6:88:C2:8B',
                                    'E8:3E:B6:40:A8:27',
                                    'EC:55:F9:6F:ED:DE',
                                    '18:A9:05:E3:0C:F5',
                                    '18:E2:C2:96:78:48',
                                    '18:20:32:BD:67:77',
                                    '18:34:51:17:FF:78',
                                    '18:3D:A2:51:82:40',
                                    'F0:7B:CB:01:A5:2C',
                                    'F0:7B:CB:18:CE:2A',
                                    'F0:B4:79:13:51:14',
                                    'F0:B4:79:14:AA:E7',
                                    'F0:B4:79:14:AF:78',
                                    'F0:B4:79:14:B2:C6',
                                    'F0:B4:79:14:D5:04',
                                    'F0:B4:79:15:40:F2',
                                    'F0:B4:79:15:4A:4D',
                                    'F0:B4:79:16:D5:1C',
                                    'F0:B4:79:18:E4:4F',
                                    'F0:B4:79:19:71:E2',
                                    'F0:B4:79:1B:E1:D5',
                                    'F0:B4:79:1B:E4:5B',
                                    'F0:B4:79:1C:00:C4',
                                    'F0:B4:79:1C:12:90',
                                    'F0:B4:79:1C:4F:99',
                                    'F0:B4:79:1F:5B:76',
                                    'F0:CB:A1:C5:24:F0',
                                    'F0:CB:A1:CA:DA:F7',
                                    'F0:DC:E2:6B:35:48',
                                    'F8:1E:DF:D9:9F:79',
                                    'F8:1E:DF:E2:AB:87',
                                    'F8:1E:DF:E4:86:B6',
                                    'F8:1E:DF:E9:69:37',
                                    'F8:1E:DF:E9:EE:30',
                                    'F8:1E:DF:EB:11:47',
                                    'F8:1E:DF:F2:77:95',
                                    'F8:1E:DF:F2:63:C8',
                                    'F8:1E:DF:32:A2:50',
                                    '1C:69:A5:51:15:8C',
                                    '1C:4B:D6:6F:78:90',
                                    '1C:4B:D6:80:6C:00',
                                    '1C:4B:D6:F2:D2:B8',
                                    '1C:4B:D6:1F:D4:05',
                                    '1C:62:B8:5F:8D:00',
                                    '20:68:9D:BB:FD:17',
                                    '20:68:9D:E9:5C:58',
                                    '20:7C:8F:6B:79:0F',
                                    '20:C9:D0:7C:FC:3D',
                                    '20:C9:D0:80:C8:F5',
                                    '20:C9:D0:C3:10:F9',
                                    '20:C9:D0:C9:25:37',
                                    '20:C9:D0:D0:42:E9',
                                    '20:C9:D0:D1:45:05',
                                    '20:C9:D0:D1:56:0D',
                                    '20:C9:D0:D2:05:39',
                                    '20:C9:D0:D4:C8:AD',
                                    '20:C9:D0:D6:75:03',
                                    '20:C9:D0:DA:82:61',
                                    '20:C9:D0:DA:B2:81',
                                    '20:C9:D0:DD:D1:FB',
                                    '20:C9:D0:E0:83:DB',
                                    '20:C9:D0:E4:2F:85',
                                    '20:C9:D0:44:8C:CB',
                                    '20:54:76:90:5C:5D',
                                    '24:77:03:E2:30:74',
                                    '24:EC:99:23:1C:C6',
                                    '24:EC:99:4C:24:8A',
                                    '04:0C:CE:D3:ED:18',
                                    '04:0C:CE:D5:9F:A8',
                                    '04:0C:CE:D5:19:DA',
                                    '04:0C:CE:D5:1C:4E',
                                    '04:0C:CE:DC:82:50',
                                    '04:0C:CE:DC:C3:40',
                                    '04:0C:CE:DE:70:90',
                                    '04:0C:CE:E4:62:42',
                                    '04:0C:CE:20:B9:AA',
                                    '04:1E:64:73:D2:B3',
                                    '04:1E:64:F8:5A:BD',
                                    '04:1E:64:3B:91:24',
                                    '04:1E:64:45:98:DA',
                                    '04:54:53:91:F4:D7',
                                    '28:6A:BA:7B:5D:D0',
                                    '28:6A:BA:27:D2:3C',
                                    '28:6A:BA:3D:18:A8',
                                    '28:6A:BA:4B:95:EC',
                                    '28:94:0F:C1:1D:90',
                                    '28:94:0F:D6:BD:81',
                                    '28:94:0F:D6:BD:02',
                                    '28:CF:DA:D6:81:FC',
                                    '28:CF:DA:DF:C4:50',
                                    '28:CF:DA:E0:F1:1E',
                                    '28:CF:DA:E7:68:26',
                                    '28:CF:DA:E7:16:84',
                                    '28:CF:DA:E8:6E:6C',
                                    '28:CF:DA:E8:F6:C6',
                                    '28:CF:DA:EC:03:D2',
                                    '28:CF:DA:ED:96:88',
                                    '28:37:37:24:94:1A',
                                    '28:37:37:4D:96:F5',
                                    '2C:81:58:FD:18:17',
                                    '30:85:A9:E4:08:89',
                                    '30:39:26:E5:84:84',
                                    '34:BB:1F:35:B7:11',
                                    '34:C0:59:2C:97:52',
                                    '34:15:9E:8D:D4:71',
                                    '34:15:9E:91:F8:F0',
                                    '34:15:9E:94:10:71',
                                    '34:15:9E:95:E1:1A',
                                    '34:15:9E:E8:39:4F',
                                    '34:51:C9:4C:71:D1',
                                    '38:59:F9:44:5F:B2',
                                    '3C:07:54:23:60:58',
                                    '40:6C:8F:1D:C0:7F',
                                    '40:6C:8F:42:B0:90',
                                    '44:6D:57:0D:03:2A',
                                    '44:6D:57:87:BE:AF',
                                    '44:6D:57:03:11:09',
                                    '44:2A:60:6B:D6:60',
                                    '44:2A:60:94:F3:1D',
                                    '44:2A:60:F2:F1:10',
                                    '44:4C:0C:DD:2A:B9',
                                    '48:5D:60:10:5A:39',
                                    '48:5D:60:B0:8C:AC',
                                    '48:5D:60:BE:DE:0E',
                                    '48:5D:60:BF:18:A1',
                                    '48:5D:60:F5:96:80',
                                    '48:5D:60:25:DA:CE',
                                    '48:5D:60:39:91:49',
                                    '48:5D:60:5A:24:F8',
                                    '4C:0F:6E:01:4D:9F',
                                    '4C:0F:6E:12:A1:FC',
                                    '4C:0F:6E:E1:0D:BF',
                                    '4C:0F:6E:FA:2B:FD',
                                    '4C:B1:99:CC:85:9F',
                                    '4C:BC:A5:AD:BF:6C',
                                    '4C:ED:DE:65:5E:8E',
                                    '4C:ED:DE:67:AD:2A',
                                    '08:ED:B9:72:6B:33',
                                    '08:ED:B9:F8:65:D1',
                                    '08:ED:B9:F8:57:07',
                                    '08:ED:B9:04:94:12',
                                    '08:ED:B9:34:C2:F4',
                                    '08:ED:B9:06:23:A2',
                                    '08:3E:8E:B2:99:ED',
                                    '08:3E:8E:B2:C5:E1',
                                    '08:3E:8E:CD:23:B3',
                                    '50:CC:F8:21:C2:58',
                                    '50:EA:D6:E3:1B:0F',
                                    '50:46:5D:29:77:C3',
                                    '54:04:A6:96:01:E1',
                                    '54:04:A6:07:54:9D',
                                    '58:94:6B:6B:C2:FC',
                                    '58:94:6B:D2:D4:E4',
                                    '58:B0:35:66:11:6E',
                                    '58:B0:35:6C:F7:E4',
                                    '58:B0:35:6D:02:35',
                                    '58:B0:35:75:F3:93',
                                    '58:B0:35:7E:CF:D3',
                                    '58:B0:35:80:A8:93',
                                    '58:B0:35:FC:6B:30',
                                    '58:B0:35:5C:95:64',
                                    '58:1F:AA:C8:62:D9',
                                    '58:55:CA:F5:64:A9',
                                    '58:55:CA:F6:86:6F',
                                    '58:55:CA:F6:EF:83',
                                    '58:55:CA:F8:15:4D',
                                    '58:55:CA:F8:5B:39',
                                    '5C:0A:5B:69:1D:C7',
                                    '5C:96:9D:70:20:C7',
                                    '5C:96:9D:76:2A:7F',
                                    '5C:96:9D:7A:9C:FB',
                                    '5C:96:9D:7C:71:C9',
                                    '5C:96:9D:7C:5A:15',
                                    '5C:96:9D:7D:1B:63',
                                    '5C:96:9D:8A:96:2F',
                                    '5C:96:9D:8B:05:DB',
                                    '5C:96:9D:DD:D0:4D',
                                    '5C:59:48:66:E8:90',
                                    '5C:59:48:8F:1F:80',
                                    '60:C5:47:0A:CB:34',
                                    '60:C5:47:72:76:C3',
                                    '60:C5:47:79:34:85',
                                    '60:C5:47:8C:75:E0',
                                    '60:C5:47:96:70:32',
                                    '60:C5:47:96:C3:26',
                                    '60:C5:47:97:25:8A',
                                    '60:C5:47:04:7F:C0',
                                    '60:C5:47:04:81:D8',
                                    '60:C5:47:07:6D:90',
                                    '60:D8:19:65:C4:DF',
                                    '60:D8:19:08:A2:92',
                                    '60:33:4B:01:C7:D8',
                                    '60:33:4B:01:DD:F5',
                                    '60:33:4B:23:73:CF',
                                    '60:33:4B:23:62:E2',
                                    '60:33:4B:26:86:B9',
                                    '60:33:4B:26:8B:B7',
                                    '60:33:4B:26:BC:8F',
                                    '60:45:BD:24:DE:76'
                                ]
                            }
                        },
                    },
                    {
                        IFOUTOCTETS      => '0',
                        IFINERRORS       => '0',
                        IFOUTERRORS      => '0',
                        IFINTERNALSTATUS => 'up(1)',
                        IFSTATUS         => 'down(2)',
                        IFNUMBER         => '1025',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFNAME           => ' Stacking Port 1/StackA',
                        MAC              => '00:00:00:00:00:00',
                        IFTYPE           => 'propVirtual(53)',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFSPEED          => '0',
                        IFMTU            => '0'
                    },
                    {
                        IFOUTERRORS      => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFSTATUS         => 'down(2)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFTYPE           => 'propVirtual(53)',
                        MAC              => '00:00:00:00:00:00',
                        IFINOCTETS       => '0',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFSPEED          => '0',
                        IFMTU            => '0'
                    },
                    {
                        IFMTU            => '1500',
                        IFSPEED          => '0',
                        IFDESCR          => 'admin',
                        IFINOCTETS       => '173601851',
                        MAC              => 'E8:E7:32:2B:C1:E2',
                        IFTYPE           => 'l3ipvlan(136)',
                        IFNAME           => 'admin',
                        IFLASTCHANGE     => '(57238810) 6 days, 14:59:48.10',
                        IFNUMBER         => '13600001',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205881648',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'up(1)',
                        IFINTERNALSTATUS => 'up(1)'
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1305406678',
                        IFOUTERRORS      => '0',
                        IFSTATUS         => 'up(1)',
                        IFINTERNALSTATUS => 'up(1)',
                        IFTYPE           => 'softwareLoopback(24)',
                        IFNAME           => 'Loopback',
                        IFSPEED          => '0',
                        IFDESCR          => 'Loopback',
                        IFINOCTETS       => '1305305095',
                        IFMTU            => '32768'
                    }
                ]
            },
        }
    ],
    'alcatel/unknown.2.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'E8:E7:32:2B:C1:E2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'E8:E7:32:2B:C1:E2',
            MODELSNMP    => 'Networking2189',
            MODEL        => undef,
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                MAC          => 'E8:E7:32:2B:C1:E2',
                NAME         => 'CP-153-127',
                ID           => undef,
                FIRMWARE     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                MODEL        => 'OS6400-P24',
                SERIAL       => 'M4682816',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise'
            },
            PORTS => {
                PORT => [
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/1',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '11031705',
                        IFLASTCHANGE => '(163281300) 18 days, 21:33:33.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1001',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '135933304',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E4'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/2',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1002',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E5'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/3',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1003',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E6'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/4',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1004',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E7'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/5',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1005',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E8'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/6',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1006',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:E9'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/7',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1007',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:EA'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9F:AF:B1:09'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/8',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '68783504',
                        IFLASTCHANGE => '(133316300) 15 days, 10:19:23.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1008',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '167030715',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:EB'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/9',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1009',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:EC'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/10',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1010',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:ED'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9F:AF:B1:2E'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/11',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '197055100',
                        IFLASTCHANGE => '(34170400) 3 days, 22:55:04.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1011',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '347793172',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:EE'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9F:AF:B0:FE'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/12',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '257499013',
                        IFLASTCHANGE => '(34163100) 3 days, 22:53:51.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1012',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '408235574',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:EF'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9F:AF:B1:0C'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/13',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '603370409',
                        IFLASTCHANGE => '(34193000) 3 days, 22:58:50.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1013',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '754298162',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F0'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9F:AF:B1:32'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/14',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '28001214',
                        IFLASTCHANGE => '(103428100) 11 days, 23:18:01.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1014',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '126345688',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F1'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/15',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1015',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F2'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/16',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1016',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F3'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/17',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1017',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F4'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/18',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1018',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F5'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/19',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1019',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F6'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/20',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1020',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F7'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/21',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1021',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F8'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/22',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1022',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:F9'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent 1/23',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(7100) 0:01:11.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1023',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:FA'
                    },
                    {
                        CONNECTIONS => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5E:00:01:02',
                                    '00:0B:5F:CC:D8:80',
                                    '00:80:9F:AF:B0:F2',
                                    '00:80:9F:AF:B0:F8',
                                    '00:80:9F:AF:B1:01',
                                    '00:80:9F:AF:B1:0A',
                                    '00:80:9F:AF:B1:10',
                                    '00:80:9F:AF:B1:13',
                                    '00:80:9F:AF:B1:15',
                                    '00:80:9F:AF:B1:16',
                                    '00:80:9F:AF:B1:18',
                                    '00:80:9F:AF:B1:1A',
                                    '00:80:9F:AF:B1:1B',
                                    '00:80:9F:AF:B1:1E',
                                    '00:80:9F:AF:B1:21',
                                    '00:80:9F:AF:B1:22',
                                    '00:80:9F:AF:B1:24',
                                    '00:80:9F:AF:B1:25',
                                    '00:80:9F:AF:B1:2D',
                                    '00:80:9F:AF:B1:2F',
                                    '00:80:9F:AF:B1:3C',
                                    '00:80:9F:B3:AA:6C',
                                    '00:13:5F:FA:EE:20',
                                    '00:13:5F:FA:F1:90',
                                    '00:13:5F:FA:F1:30',
                                    '00:13:5F:FA:F2:A0',
                                    '00:13:5F:FA:F4:D0',
                                    '00:13:5F:FA:F5:70',
                                    '00:13:5F:FA:FA:60',
                                    '00:13:5F:FA:FB:B0',
                                    '00:14:6A:D6:B1:94',
                                    '00:14:6A:D6:B1:AA',
                                    '00:14:6A:D6:B1:B6',
                                    '00:14:6A:D6:B1:B8',
                                    '00:14:6A:D6:B1:CE',
                                    '00:14:6A:D6:B1:D8',
                                    '00:14:6A:D6:B1:E8',
                                    '00:14:6A:D6:B1:28',
                                    '00:14:6A:D6:B1:32',
                                    '00:14:6A:D6:B1:42',
                                    '00:14:6A:D6:B1:48',
                                    '00:14:6A:D6:B1:4E',
                                    '00:14:6A:D6:B1:56',
                                    '00:14:6A:D6:B1:5E',
                                    '00:14:6A:D6:B1:62',
                                    '00:14:6A:D6:B2:68',
                                    '00:14:6A:D6:B2:8E',
                                    '00:14:6A:D6:B2:B8',
                                    '00:14:6A:D6:B2:BA',
                                    '00:14:6A:D6:B2:C0',
                                    '00:14:6A:D6:B2:14',
                                    '00:14:6A:D6:B2:D0',
                                    '00:14:6A:D6:B2:F0',
                                    '00:14:6A:D6:B2:F4',
                                    '00:14:6A:D6:B2:FA',
                                    '00:14:6A:D6:B2:1E',
                                    '00:14:6A:D6:B2:32',
                                    '00:14:6A:D6:B3:14',
                                    '00:14:6A:D6:B3:1E',
                                    '00:19:D1:92:0C:4C',
                                    '00:1B:B1:F4:5E:10',
                                    '00:1B:53:FD:D5:84',
                                    '00:1B:54:D6:39:1A',
                                    '00:1C:C0:21:C6:A8',
                                    '00:1C:C4:49:5D:32',
                                    '00:1F:E2:12:56:70',
                                    '00:20:A6:49:7E:D7',
                                    '00:20:A6:49:7E:DA',
                                    '00:20:A6:49:7E:F8',
                                    '00:20:A6:49:7E:FB',
                                    '00:20:A6:49:7F:04',
                                    '00:20:A6:49:7F:07',
                                    '00:21:59:92:FB:7F',
                                    '00:22:43:61:2E:F2',
                                    '00:23:7D:88:0C:11',
                                    '00:23:12:57:DC:52',
                                    '00:24:D2:72:A3:E2',
                                    '00:24:E8:D0:38:38',
                                    '00:24:2C:63:FF:08',
                                    '00:26:B6:15:21:25',
                                    '00:26:BB:1D:3C:1C',
                                    '00:09:3D:00:73:29',
                                    '00:09:3D:00:56:97',
                                    '64:20:0C:CE:8A:89',
                                    '68:A8:6D:23:EB:50',
                                    '74:E1:B6:8B:7E:AC',
                                    '74:2F:68:6F:D7:FC',
                                    '78:92:9C:78:D9:F6',
                                    '78:A3:E4:BF:CC:B2',
                                    '78:DD:08:CB:1A:BA',
                                    '7C:D1:C3:72:E3:EA',
                                    '7C:61:93:90:95:E3',
                                    '88:9F:FA:1A:9F:8C',
                                    '8C:89:A5:3A:B8:84',
                                    '10:9A:DD:A5:32:33',
                                    'B8:AC:6F:94:57:ED',
                                    'D0:DF:9A:21:F6:11',
                                    'D4:87:D8:8E:2F:D5',
                                    'D8:30:62:60:12:7C',
                                    'E0:F8:47:41:B5:CC',
                                    'E8:E7:32:27:23:5E',
                                    'E8:E7:32:27:31:02',
                                    'E8:E7:32:27:38:30',
                                    'E8:E7:32:27:63:A0',
                                    'E8:E7:32:27:63:F4',
                                    'E8:E7:32:2A:E0:9E',
                                    'E8:E7:32:2A:E8:A4',
                                    'E8:E7:32:2B:CC:CE',
                                    'EC:85:2F:04:68:CA',
                                    'F8:1E:DF:D6:B7:0F',
                                    '04:54:53:04:B3:76',
                                    '30:39:26:26:26:9A',
                                    '40:6C:8F:1D:C0:7F',
                                    '40:6C:8F:42:B0:90',
                                    '5C:AC:4C:1A:44:73'
                                ]
                            }
                        },
                        IFDESCR      => 'Alcatel-Lucent 1/24',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '2236854165',
                        IFLASTCHANGE => '(11700) 0:01:57.00',
                        IFMTU        => '9216',
                        IFNUMBER     => '1024',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '1199596145',
                        IFSPEED      => '1000000000',
                        IFTYPE       => 'ethernetCsmacd(6)',
                        MAC          => 'E8:E7:32:2B:C1:FB'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(3300) 0:00:33.00',
                        IFMTU        => '0',
                        IFNUMBER     => '1025',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'propVirtual(53)',
                        MAC          => '00:00:00:00:00:00'
                    },
                    {
                        IFDESCR      => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '0',
                        IFLASTCHANGE => '(3300) 0:00:33.00',
                        IFMTU        => '0',
                        IFNUMBER     => '1026',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '0',
                        IFSPEED      => '0',
                        IFTYPE       => 'propVirtual(53)',
                        MAC          => '00:00:00:00:00:00'
                    },
                    {
                        IFDESCR      => 'admin',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '25252490',
                        IFLASTCHANGE => '(11801) 0:01:58.01',
                        IFMTU        => '1500',
                        IFNUMBER     => '13600001',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '26159026',
                        IFSPEED      => '0',
                        IFTYPE       => 'l3ipvlan(136)',
                        MAC          => 'E8:E7:32:2B:C1:E2'
                    },
                    {
                        IFDESCR      => 'Loopback',
                        IFINERRORS   => '0',
                        IFINOCTETS   => '3686859309',
                        IFLASTCHANGE => '(511) 0:00:05.11',
                        IFMTU        => '32768',
                        IFNUMBER     => '13600154',
                        IFOUTERRORS  => '0',
                        IFOUTOCTETS  => '3686952587',
                        IFSPEED      => '0',
                        IFTYPE       => 'softwareLoopback(24)'
                    }
                ]
            }
        }
    ]
);

setPlan(scalar keys %tests);

my $dictionary = getDictionnary();
my $index      = getIndex();

foreach my $test (sort keys %tests) {
    my $snmp  = getSNMP($test);
    my $model = getModel($index, $tests{$test}->[1]->{MODELSNMP});

    my %device0 = getDeviceInfo($snmp);
    cmp_deeply(\%device0, $tests{$test}->[0], "$test: base stage");

    my %device1 = getDeviceInfo($snmp, $dictionary);
    cmp_deeply(\%device1, $tests{$test}->[1], "$test: base + dictionnary stage");

    my $device3 = getDeviceFullInfo(
        snmp  => $snmp,
        model => $model,
    );
    cmp_deeply($device3, $tests{$test}->[2], "$test: base + model stage");
}
