# Generated by default/object.tt
package Paws::AppRunner::ImageRepository;
  use Moose;
  has ImageConfiguration => (is => 'ro', isa => 'Paws::AppRunner::ImageConfiguration');
  has ImageIdentifier => (is => 'ro', isa => 'Str', required => 1);
  has ImageRepositoryType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::ImageRepository

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::ImageRepository object:

  $service_obj->Method(Att1 => { ImageConfiguration => $value, ..., ImageRepositoryType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::ImageRepository object:

  $result = $service_obj->Method(...);
  $result->Att1->ImageConfiguration

=head1 DESCRIPTION

Describes a source image repository.

=head1 ATTRIBUTES


=head2 ImageConfiguration => L<Paws::AppRunner::ImageConfiguration>

Configuration for running the identified image.


=head2 B<REQUIRED> ImageIdentifier => Str

The identifier of an image.

For an image in Amazon Elastic Container Registry (Amazon ECR), this is
an image name. For the image name format, see Pulling an image
(https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html)
in the I<Amazon ECR User Guide>.


=head2 B<REQUIRED> ImageRepositoryType => Str

The type of the image repository. This reflects the repository provider
and whether the repository is private or public.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

