# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::S3ContentBaseLocation;
  use Moose;
  has BasePath => (is => 'ro', isa => 'Str');
  has BucketARN => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::S3ContentBaseLocation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::S3ContentBaseLocation object:

  $service_obj->Method(Att1 => { BasePath => $value, ..., BucketARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::S3ContentBaseLocation object:

  $result = $service_obj->Method(...);
  $result->Att1->BasePath

=head1 DESCRIPTION

The S3 bucket that holds the application information.

=head1 ATTRIBUTES


=head2 BasePath => Str

The base path for the S3 bucket.


=head2 B<REQUIRED> BucketARN => Str

The Amazon Resource Name (ARN) of the S3 bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

