# NAME

Test::MixedScripts - test text for mixed and potentially confusable Unicode scripts

# SYNOPSIS

```perl
use Test::V0;
use Test::MixedScripts v0.3.0 qw( all_perl_files_scripts_ok file_scripts_ok );

all_perl_files_scripts_ok();

file_scripts_ok( 'assets/site.js' );

done_testing;
```

# DESCRIPTION

This is a module to test that Perl code and other text files do not have potentially malicious or confusing Unicode
combinations.

For example, the text for the domain names "оnе.example.com" and "one.example.com" look indistinguishable in many fonts,
but the first one has Cyrillic letters.  If your software interacted with a service on the second domain, then someone
can operate a service on the first domain and attempt to fool developers into using their domain instead.

This might be through a malicious patch submission, or even text from an email or web page that they have convinced a
developer to copy and paste into their code.

# RECENT CHANGES

Changes for version v0.6.3 (2025-08-03)

- Documentation
    - Added SUPPORT section and merged BUGS into it.
    - README is now generated by Dist::Zilla::Plugin::UsefulReadme.
    - Refer users to CONTRIBUTING.md.
- Toolchain
    - Fixed Dist::Zilla configuration.

See the `Changes` file for more details.

# REQUIREMENTS

This module lists the following modules as runtime dependencies:

- [Carp](https://metacpan.org/pod/Carp)
- [Exporter](https://metacpan.org/pod/Exporter) version 5.57 or later
- [File::Basename](https://metacpan.org/pod/File%3A%3ABasename)
- [File::Spec](https://metacpan.org/pod/File%3A%3ASpec)
- [IO](https://metacpan.org/pod/IO)
- [List::Util](https://metacpan.org/pod/List%3A%3AUtil)
- [Test2::API](https://metacpan.org/pod/Test2%3A%3AAPI) version 1.302200 or later
- [Test2::Util::DistFiles](https://metacpan.org/pod/Test2%3A%3AUtil%3A%3ADistFiles) version v0.2.0 or later
- [Unicode::UCD](https://metacpan.org/pod/Unicode%3A%3AUCD)
- [perl](https://metacpan.org/pod/perl) version v5.16.0 or later
- [utf8](https://metacpan.org/pod/utf8)
- [warnings](https://metacpan.org/pod/warnings)

See the `cpanfile` file for the full list of prerequisites.

# INSTALLATION

The latest version of this module (along with any dependencies) can be installed from [CPAN](https://www.cpan.org) with the `cpan` tool that is included with Perl:

```
cpan Test::MixedScripts
```

You can also extract the distribution archive and install this module (along with any dependencies):

```
cpan .
```

You can also install this module manually using the following commands:

```
perl Makefile.PL
make
make test
make install
```

If you are working with the source repository, then it may not have a `Makefile.PL` file.  But you can use the [Dist::Zilla](https://dzil.org/) tool in anger to build and install this module:

```
dzil build
dzil test
dzil install --install-command="cpan ."
```

For more information, see the `INSTALL` file included with this distribution.

# SUPPORT

Only the latest version of this module will be supported.

This module requires Perl v5.16 or later.  Future releases may only support Perl versions released in the last ten
years.

## Reporting Bugs and Submitting Feature Requests

Please report any bugs or feature requests on the bugtracker website
[https://github.com/robrwo/perl-Test-MixedScripts/issues](https://github.com/robrwo/perl-Test-MixedScripts/issues)

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

If the bug you are reporting has security implications which make it inappropriate to send to a public issue tracker,
then see `SECURITY.md` for instructions how to report security vulnerabilities.

# SOURCE

The development version is on github at [https://github.com/robrwo/perl-Test-MixedScripts](https://github.com/robrwo/perl-Test-MixedScripts)
and may be cloned from [git://github.com/robrwo/perl-Test-MixedScripts.git](git://github.com/robrwo/perl-Test-MixedScripts.git)

See `CONTRIBUTING.md` for more information.

# AUTHOR

Robert Rothenberg <rrwo@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by Robert Rothenberg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

# SEE ALSO

[Test::PureASCII](https://metacpan.org/pod/Test%3A%3APureASCII) tests that only ASCII characters are used.

[Unicode::Confuse](https://metacpan.org/pod/Unicode%3A%3AConfuse) identifies [Unicode Confusables](https://util.unicode.org/UnicodeJsps/confusables.jsp).

[Unicode::Security](https://metacpan.org/pod/Unicode%3A%3ASecurity) implements several security mechanisms described in
[Unicode Security Mechanisms](https://www.unicode.org/reports/tr39/).

[Detecting malicious Unicode](https://daniel.haxx.se/blog/2025/05/16/detecting-malicious-unicode/)
