# Generated by default/object.tt
package Paws::Kendra::OneDriveUsers;
  use Moose;
  has OneDriveUserList => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has OneDriveUserS3Path => (is => 'ro', isa => 'Paws::Kendra::S3Path');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::OneDriveUsers

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::OneDriveUsers object:

  $service_obj->Method(Att1 => { OneDriveUserList => $value, ..., OneDriveUserS3Path => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::OneDriveUsers object:

  $result = $service_obj->Method(...);
  $result->Att1->OneDriveUserList

=head1 DESCRIPTION

User accounts whose documents should be indexed.

=head1 ATTRIBUTES


=head2 OneDriveUserList => ArrayRef[Str|Undef]

A list of users whose documents should be indexed. Specify the user
names in email format, for example, C<username@tenantdomain>. If you
need to index the documents of more than 100 users, use the
C<OneDriveUserS3Path> field to specify the location of a file
containing a list of users.


=head2 OneDriveUserS3Path => L<Paws::Kendra::S3Path>

The S3 bucket location of a file containing a list of users whose
documents should be indexed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

