/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: _dtos18.c,v 1.2 1994/11/27 13:05:20 mura Exp $
 */

/* System headers */
#include <stdlib.h>
#include <sys/xstdlib.h>

/*
** ܴؿưѴƤʸˤ뤿ᡢŪˤ
** ˳ǼǤޤǤȤǤʤäƺǹ
** 18Ǥ롣
*/

/* File scope variables */
static double _pos1[32] = {
    1.0e+17,					/* + 0 */
    1.0e+18,					/* + 1 */
    1.0e+19,					/* + 2 */
    1.0e+20,					/* + 3 */
    1.0e+21,					/* + 4 */
    1.0e+22,					/* + 5 */
    1.0e+23,					/* + 6 */
    1.0e+24,					/* + 7 */
    1.0e+25,					/* + 8 */
    1.0e+26,					/* + 9 */
    1.0e+27,					/* +10 */
    1.0e+28,					/* +11 */
    1.0e+29,					/* +12 */
    1.0e+30,					/* +13 */
    1.0e+31,					/* +14 */
    1.0e+32,					/* +15 */
    1.0e+33,					/* +16 */
    1.0e+34,					/* +17 */
    1.0e+35,					/* +18 */
    1.0e+36,					/* +19 */
    1.0e+37,					/* +20 */
    1.0e+38,					/* +21 */
    1.0e+39,					/* +22 */
    1.0e+40,					/* +23 */
    1.0e+41,					/* +24 */
    1.0e+42,					/* +25 */
    1.0e+43,					/* +26 */
    1.0e+44,					/* +27 */
    1.0e+45,					/* +28 */
    1.0e+46,					/* +29 */
    1.0e+47,					/* +30 */
    1.0e+48,					/* +31 */
};

/* File scope variables */
static double _neg1[32] = {
    1.0e+17,					/* - 0 */
    1.0e+16,					/* - 1 */
    1.0e+15,					/* - 2 */
    1.0e+14,					/* - 3 */
    1.0e+13,					/* - 4 */
    1.0e+12,					/* - 5 */
    1.0e+11,					/* - 6 */
    1.0e+10,					/* - 7 */
    1.0e+9,					/* - 8 */
    1.0e+8,					/* - 9 */
    1.0e+7,					/* -10 */
    1.0e+6,					/* -11 */
    1.0e+5,					/* -12 */
    1.0e+4,					/* -13 */
    1.0e+3,					/* -14 */
    1.0e+2,					/* -15 */
    1.0e+1,					/* -16 */
    1.0e+0,					/* -17 */
    1.0e-1,					/* -18 */
    1.0e-2,					/* -19 */
    1.0e-3,					/* -20 */
    1.0e-4,					/* -21 */
    1.0e-5,					/* -22 */
    1.0e-6,					/* -23 */
    1.0e-7,					/* -24 */
    1.0e-8,					/* -25 */
    1.0e-9,					/* -26 */
    1.0e-10,					/* -27 */
    1.0e-11,					/* -28 */
    1.0e-12,					/* -29 */
    1.0e-13,					/* -30 */
    1.0e-14,					/* -31 */
};

/* File scope variables */
static double _pos2[10] = {
    1.0e+0,					/* 000 */
    1.0e+32,					/* 001 */
    1.0e+64,					/* 010 */
    1.0e+96,					/* 011 */
    1.0e+128,					/* 100 */
    1.0e+160,					/* 101 */
    1.0e+192,					/* 110 */
    1.0e+224,					/* 111 */
    1.0e+256,					/* 1000 */
    1.0e+288,					/* 1001 */
};

/* File scope variables */
static double _neg2[10] = {
    1.0e-0,					/* 000 */
    1.0e-32,					/* 001 */
    1.0e-64,					/* 010 */
    1.0e-96,					/* 011 */
    1.0e-128,					/* 100 */
    1.0e-160,					/* 101 */
    1.0e-192,					/* 110 */
    1.0e-224,					/* 111 */
    1.0e-256,					/* 1000 */
    1.0e-288,					/* 1001 */
};

/* File scope functions */
static int _cmpd (double x, double y)
{
    unsigned long vx, vy, rc;
    unsigned long *x_ptr = (unsigned long *) &x;
    unsigned long *y_ptr = (unsigned long *) &y;

    /* xλؿӥåȤФ */
    vx = x_ptr[0] & 0x7FF00000;

    /* yλؿӥåȤФ */
    vy = y_ptr[0] & 0x7FF00000;

    /* ؿӥåȤȽǤ */
    if ((rc = vy - vx) != 0)
	return rc;

    /* xͭξ̥ӥåȤФ */
    vx = x_ptr[0] & 0x000FFFFF;

    /* yͭξ̥ӥåȤФ */
    vy = y_ptr[0] & 0x000FFFFF;

    /* ̥ӥåȤȽǤ */
    if ((rc = vy - vx) != 0)
	return rc;

    /* xͭβ̥ӥåȤФ */
    vx = x_ptr[1];

    /* yͭβ̥ӥåȤФ */
    vy = y_ptr[1];

    /* ǽȽ */
    return vy - vx;
}

/* Functions */
void _dtos18 (double x, int *decpt, int *sign, char *buffer)
{
    short e2;
    int e, n;

    /* 2λؿ(Хʤξ) */
    e2 = (((unsigned short *) &x)[0] & 0x7FF0U) >> 4;

    /* ؿ0ξϡ0.0å */
    if (e2 == 0) {

	unsigned long hi = ((unsigned long *) &x)[0] & 0xFFFFF;
	unsigned long lo = ((unsigned long *) &x)[1];

	/* ͭ0ɤ */
	if (hi == 0 && lo == 0) {

	    /* ʸ */
	    buffer[0] = '0';

	    /* NUL */
	    buffer[1] = '\0';

	    /* ֤׻ */
	    *decpt = 1;

	    /* ׻ */
	    /* *sign = hi & 0x80000000UL; */
	    *sign = 0;

	    /*  */
	    return;

	}

    }

    /* 2λؿ˥Х򤫤Ƥ10λؿ򳵻 (approx. log10(2)) */
    e = ((int) ((e2 - 1023) * 77)) >> 8;

    /* ؿξ */
    if (e >= 0) {

	/* ؿ32꾮ϥơ֥1 */
	if (e < 32)
	    x *= _neg1[e];

	/* ؿ32礭ϥơ֥1,2 */
	else
	    x *= _neg1[e & 31] * _neg2[e >> 5];

    }

    /* ؿξ */
    else {

	/* ͤ׻ */
	n = -e;

	/* ͤ32꾮ϥơ֥1 */
	if (n < 32)
	    x *= _pos1[n];

	/* ͤ32礭ϥơ֥1,2 */
	else {
	    x *= _pos1[n & 31];
	    x *= _pos2[n >> 5];
	}

    }

    /* 󥰤᤹ */
    if (_cmpd (1.0e+18, x) >= 0) {
	e++;
	x *= 1.0e-1;
    }

    /* 󥰤­ʤɲ */
    else if (_cmpd (1.0e+17, x) < 0) {
	e--;
	x *= 1.0e+1;
    }

    /* ֤׻ */
    *decpt = e + 1;

    /* ׻ */
    *sign = ((unsigned char *) &x)[0] & 0x80U;

    /* ʸѴ */
    _ulltoa ((unsigned long long) x, buffer);
}
