### sync_m.rb			-*- Mode: ruby; tab-width: 8; -*- 

## $Revision: 1.1 $
## $Date: 1997/08/10 14:11:37 $

## Usage:
##
## require "sync_m"
##
## obj = Object.new
## obj.extend Synchronizable
## obj.setup_synchronizer
##
## ... Then use as well as Synchronizer

### Code:

require "sync"

module Synchronizable
   
   Synchronizers = Hash.new
   
   def ensure_synchronizer
      unless Synchronizers.has_key?(self.id)
	 Synchronizers[self.id] = Synchronizer.new
      end
   end
   
   def locked?
      ensure_synchronizer
      Synchronizers[self.id].locked?
   end
   
   def shared?
      ensure_synchronizer
      Synchronizers[self.id].shared?
   end
   
   def exclusive?
      ensure_synchronizer
      Synchronizers[self.id].exclusive?
   end
   
   def try_lock(mode = :EX)
      ensure_synchronizer
      Synchronizers[self.id].try_lock(mode)
   end
   
   def lock(mode = :EX)
      ensure_synchronizer
      Synchronizers[self.id].lock(mode)
   end
   
   def unlock
      ensure_synchronizer
      Synchronizers[self.id].unlock
   end
   
   def synchronize(mode = :EX)
      ensure_synchronizer
      Synchronizers[self.id].synchronize(mode) do
	 yield
      end
   end
end
