= Rational

== スーパークラス:

* ((<Numeric>))

== インクルードしているモジュール:

* ((<Comparable>))

== メソッド:

Integer < Rational < Float の順に強いです。つまり other が Float なら、
self を Float に変換してから演算子を適用します。other が Integer なら other を
Rational に変換してから演算子を適用します。冪乗は例外です。

--- numerator
    分子を Fixnum として返します。

--- denominator
    分母を Fixnum として返します。

--- self + other
    和を計算します。

      Rational(3, 4) + 2               # => Rational(11, 4)
      Rational(3, 4) + Rational(2, 1)  # => Rational(11, 4)
      Rational(3, 4) + 2.0             # => 2.75

--- self - other
    差を計算します。

--- self * other
    積を計算します。

--- self / other
    商を計算します。
    other が 0 の時は、例外 ((<ZeroDivisionError>)) を投げます。

      Rational(3, 4) / 2              # => Rational(3, 8)
      Rational(3, 4) / Rational(2, 1) # => Rational(3, 8)
      Rational(3, 4) / 2.0            # => 0.375

--- self % other
    剰余を計算します。絶対値が self の絶対値を越えない、符合が self と同じ
    Numeric を返します。

     Rational(3, 4) % 2               # => Rational(3, 4)
     Rational(3, 4) % Rational(2, 1)  # => Rational(3, 4)
     Rational(3, 4) % 2.0             # => 0.75

--- self ** other
    冪を計算します。

      Rational(3, 4) ** 2              # => Rational(9, 16)
      Rational(3, 4) ** Rational(2, 1) # => 0.5625
      Rational(3, 4) ** 2.0            # => 0.5625

--- divmod(other)
    self を other で割った、商と余りの配列を返します。
    商は Fixnum、余りは絶対値が other の絶対値を越えず、符合が other と同じ
    Numeric です。((<Numeric#divmod|Numeric/divmod>)) も参照して下さい。

     Rational(3,4).divmod(Rational(2,3))  # => [1, Rational(1, 12)]
     Rational(-3,4).divmod(Rational(2,3)) # => [-2, Rational(7, 12)]     
     Rational(3,4).divmod(Rational(-2,3)) # => [-2, Rational(-7, 12)]

     Rational(9,4).divmod(2)              # => [1, Rational(1, 4)]
     Rational(9,4).divmod(Rational(2, 1)) # => [1, Rational(1, 4)]
     Rational(9,4).divmod(2.0)            # => [1, 0.25]

--- abs
    self が正なら self、負なら -1 * self を返します。
--- self <=> other
    other と比べて self が大きいなら 1、同じなら 0、小さいなら -1 を返します。
--- to_i
    ((<Fixnum>)) に変換します。
--- to_f
    ((<Float>)) に変換します。
--- to_s
    文字列に変換します。
      Rational(-3,4).to_s # => "-3/4"
