= Mutex_m

スレッド同期機構である ((<Mutex>)) のモジュール版です。普通のオブジェクトを
extend により Mutex にする事ができます。

((<ruby-list:1991>))

== 例

  require "mutex_m"
  obj = Object.new
  obj.extend(Mutex_m)
  obj.lock
  obj.unlock

== メソッド

--- mu_synchronize{ ... }
--- synchronize{ ... }
    Mutex_m をロックし、ブロックを実行します。実行後に必ず Mutex_m 
    のロックを開放します。

--- mu_lock
--- lock
    Mutex_m をロックします。一度にひとつのスレッドしかロックできません。
    既にロックされている mutex に対してロックを行おうとしたスレッドは
    Mutex_m のロックが開放されるまで、実行が停止されます。

    self を返します。

--- mu_locked?
--- locked?
    Mutex_m がロックされている時、真を返します。

--- mu_try_lock
--- try_lock
    Mutex_m をロックしようとして、ロックが成功した場合、真を返します。
    ロックできなかった場合にはブロックせず偽を返します。

--- mu_unlock
--- unlock
    Mutex_m のロックを開放します。
    Mutex_m のロック待ちになっていたスレッドの実行は再開されます。

    self がロックされていなければ nil を返します。そうでなければself を返します。
