/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import sun.rmi.server.RMIClassLoader;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.Utils;

public final class RemoteProxy
extends RemoteStub {
    static int logLevel = RemoteProxy.getLogLevel();
    private static Class classRemote = null;

    private static int getLogLevel() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        return LogStream.parseLevel(Utils.getProperty("sun.rmi.server.logLevel"));
    }

    private RemoteProxy() {
    }

    public static RemoteStub getStub(Remote remote, RemoteRef remoteRef) throws StubNotFoundException {
        Class clazz = null;
        try {
            clazz = RemoteProxy.getRemoteClass(remote);
            return RemoteProxy.getStub(clazz.getName(), clazz, remoteRef);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + remote.getClass().getName());
        }
    }

    public static RemoteStub getStub(String string, RemoteRef remoteRef) throws StubNotFoundException {
        return RemoteProxy.getStub(string, null, remoteRef);
    }

    public static RemoteStub getStub(String string, Class clazz, RemoteRef remoteRef) throws StubNotFoundException {
        String string2 = String.valueOf(string) + "_Stub";
        RemoteStub remoteStub = null;
        try {
            RMIClassLoader rMIClassLoader = RMIClassLoader.getLocalLoader();
            Class clazz2 = rMIClassLoader == null ? RemoteProxy.loadClass(string2, clazz) : rMIClassLoader.loadClass(string2);
            remoteStub = (RemoteStub)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("Class not found: " + string2, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new StubNotFoundException("Can't create stub: " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new StubNotFoundException("No public constructor: " + string2, illegalAccessException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new StubNotFoundException("Malformed URL", malformedURLException);
        }
        catch (ClassCastException classCastException) {
            throw new StubNotFoundException("Stub not of correct class: " + string2, classCastException);
        }
        RemoteStub.setRef(remoteStub, remoteRef);
        return remoteStub;
    }

    public static RemoteStub getProxy(Remote remote) throws RemoteException {
        RemoteStub remoteStub;
        if (remote instanceof RemoteStub) {
            remoteStub = (RemoteStub)remote;
        } else {
            Target target = ObjectTable.getTarget(remote);
            if (target != null) {
                remoteStub = target.getStub();
            } else {
                throw new StubNotFoundException("Remote object not exported: " + remote.getClass().getName());
            }
        }
        return remoteStub;
    }

    public static Skeleton getSkeleton(Remote remote) throws SkeletonNotFoundException {
        Class clazz;
        try {
            clazz = RemoteProxy.getRemoteClass(remote);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + remote.getClass().getName());
        }
        String string = String.valueOf(clazz.getName()) + "_Skel";
        try {
            RMIClassLoader rMIClassLoader = RMIClassLoader.getLocalLoader();
            Class clazz2 = rMIClassLoader == null ? RemoteProxy.loadClass(string, clazz) : rMIClassLoader.loadClass(string);
            return (Skeleton)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("Skeleton class not found: " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SkeletonNotFoundException("Can't create skeleton: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SkeletonNotFoundException("No public constructor: " + string, illegalAccessException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SkeletonNotFoundException("Malformed URL", malformedURLException);
        }
        catch (ClassCastException classCastException) {
            throw new SkeletonNotFoundException("Skeleton not of correct class: " + string, classCastException);
        }
    }

    private static Class loadClass(String string, Class clazz) throws ClassNotFoundException {
        Class<?> clazz2;
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = null;
            if (clazz != null) {
                classLoader = clazz.getClassLoader();
            }
            if (classLoader != null) {
                clazz2 = classLoader.loadClass(string);
            }
            throw classNotFoundException;
        }
        return clazz2;
    }

    private static Class getRemoteClass(Remote remote) throws ClassNotFoundException {
        Class<?> clazz = remote.getClass();
        while (clazz != null) {
            if (RemoteProxy.extendsRemote(clazz.getInterfaces())) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        throw new ClassNotFoundException("java.rmi.Remote");
    }

    private static boolean extendsRemote(Class[] classArray) throws ClassNotFoundException {
        if (classRemote == null) {
            classRemote = Class.forName("java.rmi.Remote");
        }
        int n = classArray.length - 1;
        while (n >= 0) {
            if (classArray[n].equals(classRemote)) {
                return true;
            }
            if (RemoteProxy.extendsRemote(classArray[n].getInterfaces())) {
                return true;
            }
            --n;
        }
        return false;
    }
}

