#ifndef __ARCH_SPARC_POSIX_TYPES_H
#define __ARCH_SPARC_POSIX_TYPES_H

/*
 * This file is generally used by user-level software, so you need to
 * be a little careful about namespace pollution etc.  Also, we cannot
 * assume GCC is being used.
 */

/* When cross-compilation is no longer an issue, fix this. */
#ifdef __svr4__
typedef unsigned int           __kernel_size_t;      /* solaris sucks */
#else
typedef long unsigned int      __kernel_size_t;      /* sunos is much better */
#endif /* !(__svr4__) */

typedef int                    __kernel_ssize_t;
typedef long int               __kernel_ptrdiff_t;
typedef long                   __kernel_time_t;
typedef long                   __kernel_clock_t;
typedef int                    __kernel_pid_t;
typedef unsigned short         __kernel_uid_t;
typedef unsigned short         __kernel_gid_t;
typedef unsigned short         __kernel_dev_t;
typedef unsigned long          __kernel_ino_t;
typedef unsigned short         __kernel_mode_t;
typedef unsigned short         __kernel_umode_t;
typedef short                  __kernel_nlink_t;
typedef long                   __kernel_daddr_t;
typedef long                   __kernel_off_t;
typedef char *                 __kernel_caddr_t;

#ifdef __GNUC__
typedef long long	__kernel_loff_t;
#endif

#undef __FD_SET
static __inline__ void __FD_SET(unsigned long fd, __kernel_fd_set *fdsetp)
{
	unsigned long _tmp = fd / __NFDBITS;
	unsigned long _rem = fd % __NFDBITS;
	fdsetp->fds_bits[_tmp] |= (1UL<<_rem);
}

#undef __FD_CLR
static __inline__ void __FD_CLR(unsigned long fd, __kernel_fd_set *fdsetp)
{
	unsigned long _tmp = fd / __NFDBITS;
	unsigned long _rem = fd % __NFDBITS;
	fdsetp->fds_bits[_tmp] &= ~(1UL<<_rem);
}

#undef __FD_ISSET
static __inline__ int __FD_ISSET(unsigned long fd, __kernel_fd_set *p)
{ 
	unsigned long _tmp = fd / __NFDBITS;
	unsigned long _rem = fd % __NFDBITS;
	return (p->fds_bits[_tmp] & (1UL<<_rem)) != 0;
}

/*
 * This will unroll the loop for the normal constant cases (4 or 8 longs,
 * for 256 and 512-bit fd_sets respectively)
 */
#undef __FD_ZERO
static __inline__ void __FD_ZERO(__kernel_fd_set *p)
{
	unsigned int *tmp = p->fds_bits;
	int i;

	if (__builtin_constant_p(__FDSET_INTS)) {
		switch (__FDSET_INTS) {
			case 8:
				tmp[0] = 0; tmp[1] = 0; tmp[2] = 0; tmp[3] = 0;
				tmp[4] = 0; tmp[5] = 0; tmp[6] = 0; tmp[7] = 0;
				return;
			case 4:
				tmp[0] = 0; tmp[1] = 0; tmp[2] = 0; tmp[3] = 0;
				return;
		}
	}
	i = __FDSET_INTS;
	while (i) {
		i--;
		*tmp = 0;
		tmp++;
	}
}

#endif /* !(__ARCH_SPARC_POSIX_TYPES_H) */
