/*
 * $Id: cap_sys.c,v 1.1.1.1.2.1 1999/04/23 06:16:31 morgan Exp $
 *
 * Copyright (c) 1997-8 Andrew G. Morgan   <morgan@linux.kernel.org>
 *
 * This file contains the system calls for getting and setting
 * capabilities
 */

#include "libcap.h"
#define __LIBRARY__
#include <linux/unistd.h>

_syscall2(int, capget,
	  cap_user_header_t, header,
	  cap_user_data_t, data)

_syscall2(int, capset,
	  cap_user_header_t, header,
	  const cap_user_data_t, data)

/* library defaults to agreeing with the kernel under which it was
   compiled */

unsigned int _libcap_kernel_version = 0;
unsigned int _libcap_kernel_features = 0;

/* internally resync the library's idea of the kernel api */

void _libcap_establish_api(void)
{
    struct __user_cap_header_struct ch;
    struct __user_cap_data_struct cs;

    if (_libcap_kernel_version) {
	_cap_debug("already identified kernal api 0x%.8x",
		   _libcap_kernel_version);
	return;
    }

    memset(&ch, 0, sizeof(ch));
    memset(&cs, 0, sizeof(cs));

    (void) capget(&ch, &cs);

    switch (ch.version) {

    case 0x19980330:
	_libcap_kernel_version = 0x19980330;
	_libcap_kernel_features = CAP_FEATURE_PROC;
	break;

    case 0x19990414:
	_libcap_kernel_version = 0x19990414;
	_libcap_kernel_features = CAP_FEATURE_PROC|CAP_FEATURE_FILE;
	break;

    default:
	_libcap_kernel_version = 0x00000000;
	_libcap_kernel_features = 0x00000000;
    }

    _cap_debug("version: %x, features: %x\n",
	       _libcap_kernel_version, _libcap_kernel_features);
}

/*
 * $Log: cap_sys.c,v $
 * Revision 1.1.1.1.2.1  1999/04/23 06:16:31  morgan
 * added support for revised kernel interface (with file cap support)
 *
 * Revision 1.1.1.1  1999/04/17 22:16:31  morgan
 * release 1.0 of libcap
 *
 * Revision 1.4  1998/06/08 00:14:01  morgan
 * change to accommodate alpha (glibc?)
 *
 * Revision 1.3  1998/05/24 22:54:09  morgan
 * updated for 2.1.104
 *
 * Revision 1.2  1997/04/28 00:57:11  morgan
 * fixes and zefram's patches
 *
 * Revision 1.1  1997/04/21 04:32:52  morgan
 * Initial revision
 *
 */
