/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;

public class StepFilterManager
implements ILaunchListener {
    protected StepFilterManager() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(ILaunch launch) {
        boolean useStepFilters = this.isUseStepFilters();
        IDebugTarget[] targets = launch.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IStepFilters filters;
            IDebugTarget target = targets[i];
            if (target instanceof IStepFilters && (filters = (IStepFilters)target).isStepFiltersEnabled() != useStepFilters) {
                filters.setStepFiltersEnabled(useStepFilters);
            }
            ++i;
        }
    }

    public boolean isUseStepFilters() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_USE_STEP_FILTERS);
    }

    public void setUseStepFilters(boolean useFilters) {
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_USE_STEP_FILTERS, useFilters);
        ILaunch[] launchs = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launchs.length) {
            ILaunch launch = launchs[i];
            this.launchChanged(launch);
            ++i;
        }
    }

    public void launchRemoved(ILaunch launch) {
    }
}

