/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IWatchpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModifyWatchpointAction
implements IObjectActionDelegate,
IActionDelegate2 {
    private IStructuredSelection fWatchpoints = null;

    public void run(IAction action) {
        try {
            if (this.fWatchpoints != null) {
                Iterator iterator = this.fWatchpoints.iterator();
                while (iterator.hasNext()) {
                    IWatchpoint watchpoint = (IWatchpoint)iterator.next();
                    this.toggleWatchpoint(watchpoint, action.isChecked());
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.getString("ModifyWatchpointAction.0"), ActionMessages.getString("ModifyWatchpointAction.1"), e.getStatus());
        }
    }

    protected abstract void toggleWatchpoint(IWatchpoint var1, boolean var2) throws CoreException;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fWatchpoints = (IStructuredSelection)selection;
            if (!selection.isEmpty()) {
                Iterator iterator = this.fWatchpoints.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof IWatchpoint)) continue;
                    IWatchpoint watchpoint = (IWatchpoint)next;
                    action.setChecked(this.isChecked(watchpoint));
                    if (this.isEnabled(watchpoint)) continue;
                    action.setEnabled(false);
                    return;
                }
                action.setEnabled(true);
                return;
            }
        }
        action.setEnabled(false);
    }

    protected abstract boolean isChecked(IWatchpoint var1);

    protected abstract boolean isEnabled(IWatchpoint var1);

    public void init(IAction action) {
    }

    public void dispose() {
        this.fWatchpoints = null;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }
}

