/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveBreakpointAction
extends AbstractRemoveActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object newSelection = this.computeNewSelection(selection);
        final Iterator itr = selection.iterator();
        final CoreException[] exception = new CoreException[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                ArrayList breakpointsToDelete = new ArrayList();
                boolean deleteContainers = false;
                while (itr.hasNext()) {
                    Object next = itr.next();
                    if (next instanceof IBreakpoint) {
                        breakpointsToDelete.add(next);
                        continue;
                    }
                    if (!(next instanceof IBreakpointContainer)) continue;
                    if (!deleteContainers && !(deleteContainers = MessageDialog.openConfirm((Shell)RemoveBreakpointAction.this.getView().getSite().getShell(), (String)ActionMessages.getString("RemoveBreakpointAction.0"), (String)ActionMessages.getString("RemoveBreakpointAction.1")))) {
                        return;
                    }
                    IBreakpoint[] breakpoints = ((IBreakpointContainer)next).getBreakpoints();
                    int i = 0;
                    while (i < breakpoints.length) {
                        breakpointsToDelete.add(breakpoints[i]);
                        ++i;
                    }
                }
                IBreakpoint[] breakpoints = breakpointsToDelete.toArray(new IBreakpoint[0]);
                try {
                    breakpointManager.removeBreakpoints(breakpoints, true);
                    if (newSelection != null) {
                        ((BreakpointsView)RemoveBreakpointAction.this.getView()).getCheckboxViewer().setSelection((ISelection)new StructuredSelection(newSelection));
                    }
                }
                catch (CoreException ce) {
                    exception[0] = ce;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException ce) {
            exception[0] = ce;
        }
        if (exception[0] != null) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("RemoveBreakpointAction.Removing_a_breakpoint_4"), ActionMessages.getString("RemoveBreakpointAction.Exceptions_occurred_attempting_to_remove_a_breakpoint._5"), exception[0]);
            } else {
                DebugUIPlugin.log(exception[0]);
            }
        }
    }

    protected Object computeNewSelection(IStructuredSelection selection) {
        Object newSelection = null;
        Object[] selected = selection.toArray();
        Object firstSelection = selected[0];
        BreakpointsView view = (BreakpointsView)this.getView();
        CheckboxTreeViewer viewer = view.getCheckboxViewer();
        ITreeContentProvider provider = view.getTreeContentProvider();
        Object parent = provider.getParent(firstSelection);
        if (parent != null) {
            Object[] peers = provider.getChildren(parent);
            viewer.getSorter().sort((Viewer)viewer, peers);
            int i = 0;
            while (i < peers.length) {
                Object peer = peers[i];
                if (peer == firstSelection) {
                    newSelection = this.findUnselected(peers, i, selected);
                    break;
                }
                ++i;
            }
            if (newSelection == null && (parent = provider.getParent(parent)) != null) {
                newSelection = parent;
            }
        }
        return newSelection;
    }

    private Object findUnselected(Object[] peers, int fromIndex, Object[] selected) {
        if (fromIndex < peers.length - 1) {
            int i = fromIndex + 1;
            while (i < peers.length) {
                Object candidate = peers[i];
                boolean unselected = true;
                int j = 0;
                while (j < selected.length) {
                    if (selected[j] == candidate) {
                        unselected = false;
                        break;
                    }
                    ++j;
                }
                if (unselected) {
                    return candidate;
                }
                ++i;
            }
        }
        if (fromIndex > 0) {
            return peers[fromIndex - 1];
        }
        return null;
    }

    protected void doAction(Object element) {
    }
}

