/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ResumeActionDelegate
extends AbstractListenerActionDelegate {
    protected void doAction(Object object) throws DebugException {
        if (this.isEnabledFor(object)) {
            ISuspendResume resume = (ISuspendResume)object;
            resume.resume();
        } else {
            this.doActionForAllThreads(object);
        }
    }

    protected void doActionForAllThreads(Object object) throws DebugException {
        if (this.isEnabledForAllThreads(object)) {
            IDebugElement debugElement = (IDebugElement)object;
            IThread[] threads = debugElement.getDebugTarget().getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.canResume()) {
                    thread.resume();
                }
                ++i;
            }
        }
    }

    protected boolean isRunInBackground() {
        return true;
    }

    protected boolean isEnabledFor(Object element) {
        return element instanceof ISuspendResume && ((ISuspendResume)element).canResume();
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (this.isEnabledFor(element) || this.isEnabledForAllThreads(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledForAllThreads(Object element) {
        if (element instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            try {
                IThread[] threads = debugElement.getDebugTarget().getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].canResume()) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    protected String getStatusMessage() {
        return ActionMessages.getString("ResumeActionDelegate.Exceptions_occurred_attempting_to_resume._2");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("ResumeActionDelegate.Resume_failed._1");
    }

    protected String getErrorDialogTitle() {
        return ActionMessages.getString("ResumeActionDelegate.Resume_3");
    }
}

