/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.AbstractBreakpointsViewAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.SelectBreakpointGroupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AddBreakpointToGroupAction
extends AbstractBreakpointsViewAction {
    private Object[] fBreakpoints = null;

    public void run(IAction action) {
        SelectBreakpointGroupDialog dialog;
        int dialogResult;
        IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String initialValue = preferenceStore.getString(".lastBreakpointGroup");
        if (initialValue == null || initialValue.length() < 1) {
            initialValue = DebugPlugin.getDefault().getBreakpointManager().getAutoGroup();
        }
        if ((dialogResult = (dialog = new SelectBreakpointGroupDialog(this.fView, BreakpointGroupMessages.getString("AddBreakpointToGroupAction.0"), BreakpointGroupMessages.getString("AddBreakpointToGroupAction.1"), initialValue, null)).open()) == 0) {
            String value = dialog.getValue();
            preferenceStore.putValue(".lastBreakpointGroup", value);
            try {
                int i = 0;
                while (i < this.fBreakpoints.length) {
                    ((IBreakpoint)this.fBreakpoints[i]).setGroup(value);
                    ++i;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(dialog.getShell(), BreakpointGroupMessages.getString("AddBreakpointToGroupAction.3"), BreakpointGroupMessages.getString("AddBreakpointToGroupAction.4"), e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IBreakpoint) continue;
            action.setEnabled(false);
            this.fBreakpoints = null;
            return;
        }
        action.setEnabled(true);
        this.fBreakpoints = selection.toArray();
    }
}

