/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainerFactoryManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;

public class GroupBreakpointsByDialog
extends Dialog {
    private BreakpointsView fView;
    private TableViewer fAvailableViewer;
    private AvailableContainersProvider fAvailableContainersProvider = new AvailableContainersProvider();
    private TreeViewer fSelectedViewer;
    private SelectedContainerProvider fSelectedContainersProvider = new SelectedContainerProvider();
    private List fResult = new ArrayList();
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == GroupBreakpointsByDialog.this.fAddButton) {
                GroupBreakpointsByDialog.this.handleAddPressed();
            } else if (source == GroupBreakpointsByDialog.this.fRemoveButton) {
                GroupBreakpointsByDialog.this.handleRemovePressed();
            } else if (source == GroupBreakpointsByDialog.this.fMoveUpButton) {
                GroupBreakpointsByDialog.this.handleMoveUpPressed();
            } else if (source == GroupBreakpointsByDialog.this.fMoveDownButton) {
                GroupBreakpointsByDialog.this.handleMoveDownPressed();
            }
        }
    };

    protected GroupBreakpointsByDialog(BreakpointsView view) {
        super(view.getSite().getShell());
        this.fView = view;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        BreakpointContainerFactoryLabelProvider labelProvider = new BreakpointContainerFactoryLabelProvider();
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parentComposite.setFont(parent.getFont());
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = 400;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(BreakpointGroupMessages.getString("GroupBreakpointsByDialog.0"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createAvailableViewer(composite, (ILabelProvider)labelProvider);
        this.createButtons(composite);
        this.createSelectedViewer(composite, (ILabelProvider)labelProvider);
        this.initializeContent();
        this.updateViewers();
        Dialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private void initializeContent() {
        IBreakpointContainerFactory[] factories = BreakpointContainerFactoryManager.getDefault().getFactories();
        int i = 0;
        while (i < factories.length) {
            this.fAvailableContainersProvider.addAvailable(factories[i]);
            ++i;
        }
        List activeFactories = this.fView.getBreakpointContainerFactories();
        Iterator iter = activeFactories.iterator();
        while (iter.hasNext()) {
            this.fSelectedContainersProvider.addSelected((IBreakpointContainerFactory)iter.next());
        }
    }

    private void createAvailableViewer(Composite parent, ILabelProvider labelProvider) {
        Composite availableComposite = new Composite(parent, 0);
        availableComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        availableComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 225;
        availableComposite.setLayoutData((Object)gridData);
        Label label = new Label(availableComposite, 64);
        label.setText(BreakpointGroupMessages.getString("GroupBreakpointsByDialog.1"));
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.fAvailableViewer = new TableViewer(availableComposite);
        this.fAvailableViewer.setContentProvider((IContentProvider)this.fAvailableContainersProvider);
        this.fAvailableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fAvailableViewer.setInput(new Object());
        Table table = this.fAvailableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(parent.getFont());
        this.fAvailableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GroupBreakpointsByDialog.this.handleAddPressed();
            }
        });
        this.fAvailableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GroupBreakpointsByDialog.this.updateAddButton();
            }
        });
    }

    private void createSelectedViewer(Composite parent, ILabelProvider labelProvider) {
        Composite selectedComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        selectedComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 225;
        selectedComposite.setLayoutData((Object)gridData);
        selectedComposite.setFont(parent.getFont());
        Label label = new Label(selectedComposite, 64);
        label.setText(BreakpointGroupMessages.getString("GroupBreakpointsByDialog.3"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fSelectedViewer = new TreeViewer(selectedComposite);
        this.fSelectedViewer.setContentProvider((IContentProvider)this.fSelectedContainersProvider);
        this.fSelectedViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fSelectedViewer.setInput(new Object());
        Tree tree = this.fSelectedViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(parent.getFont());
        this.fSelectedViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GroupBreakpointsByDialog.this.handleRemovePressed();
            }
        });
        this.fSelectedViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GroupBreakpointsByDialog.this.updateSelectedButtons();
            }
        });
    }

    public void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData());
        buttonComposite.setFont(parent.getFont());
        this.fAddButton = SWTUtil.createPushButton(buttonComposite, BreakpointGroupMessages.getString("GroupBreakpointsByDialog.2"), null);
        this.fAddButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fRemoveButton = SWTUtil.createPushButton(buttonComposite, BreakpointGroupMessages.getString("GroupBreakpointsByDialog.4"), null);
        this.fRemoveButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fMoveUpButton = SWTUtil.createPushButton(buttonComposite, BreakpointGroupMessages.getString("GroupBreakpointsByDialog.5"), null);
        this.fMoveUpButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fMoveDownButton = SWTUtil.createPushButton(buttonComposite, BreakpointGroupMessages.getString("GroupBreakpointsByDialog.6"), null);
        this.fMoveDownButton.addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    public List getSelectedContainers() {
        return this.fResult;
    }

    protected void okPressed() {
        Object[] factories = this.fSelectedContainersProvider.getElements(null);
        while (factories.length > 0) {
            Object factory = factories[0];
            this.fResult.add(factory);
            factories = this.fSelectedContainersProvider.getChildren(factory);
        }
        super.okPressed();
    }

    public void handleAddPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fAvailableViewer.getSelection();
        if (selection.size() < 1) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fSelectedContainersProvider.addSelected((IBreakpointContainerFactory)iter.next());
        }
        this.updateViewers();
    }

    public void handleRemovePressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        if (selection.size() < 1) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fAvailableContainersProvider.addAvailable((IBreakpointContainerFactory)iter.next());
        }
        this.updateViewers();
    }

    public void handleMoveUpPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fSelectedContainersProvider.moveUp(iter.next());
        }
        this.updateViewers();
    }

    public void handleMoveDownPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        Object[] elements = selection.toArray();
        int i = elements.length - 1;
        while (i >= 0) {
            this.fSelectedContainersProvider.moveDown(elements[i]);
            --i;
        }
        this.updateViewers();
    }

    public void updateViewers() {
        this.fAvailableViewer.refresh();
        this.fSelectedViewer.refresh();
        this.fSelectedViewer.expandAll();
        this.updateAddButton();
        this.updateSelectedButtons();
    }

    public void updateSelectedButtons() {
        this.updateRemoveButton();
        this.updateMoveUpButton();
        this.updateMoveDownButton();
    }

    public void updateAddButton() {
        IStructuredSelection selection = (IStructuredSelection)this.fAvailableViewer.getSelection();
        this.fAddButton.setEnabled(selection.size() > 0);
    }

    public void updateRemoveButton() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        this.fRemoveButton.setEnabled(selection.size() > 0);
    }

    public void updateMoveUpButton() {
        boolean enabled = true;
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        if (selection.size() == 0) {
            enabled = false;
        } else {
            Object firstSelected = selection.getFirstElement();
            Object parent = this.fSelectedContainersProvider.getParent(firstSelected);
            if (!(parent instanceof IBreakpointContainerFactory)) {
                enabled = false;
            }
        }
        this.fMoveUpButton.setEnabled(enabled);
    }

    public void updateMoveDownButton() {
        boolean enabled = true;
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedViewer.getSelection();
        if (selection.size() == 0) {
            enabled = false;
        } else {
            Object lastSelected = selection.toList().get(selection.size() - 1);
            Object[] children = this.fSelectedContainersProvider.getChildren(lastSelected);
            if (children.length < 1) {
                enabled = false;
            }
        }
        this.fMoveDownButton.setEnabled(enabled);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(BreakpointGroupMessages.getString("GroupBreakpointsByDialog.7"));
    }

    private class AvailableContainersProvider
    implements IStructuredContentProvider {
        protected List availableFactories = new ArrayList();

        AvailableContainersProvider() {
        }

        public void addAvailable(IBreakpointContainerFactory factory) {
            this.availableFactories.add(factory);
            ((GroupBreakpointsByDialog)GroupBreakpointsByDialog.this).fSelectedContainersProvider.selectedFactories.remove(factory);
        }

        public Object[] getElements(Object inputElement) {
            return this.availableFactories.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SelectedContainerProvider
    implements ITreeContentProvider {
        protected List selectedFactories = new ArrayList();

        SelectedContainerProvider() {
        }

        public void addSelected(IBreakpointContainerFactory factory) {
            this.selectedFactories.add(factory);
            ((GroupBreakpointsByDialog)GroupBreakpointsByDialog.this).fAvailableContainersProvider.availableFactories.remove(factory);
        }

        public void moveUp(Object object) {
            int index = this.selectedFactories.indexOf(object);
            if (index > 0) {
                this.selectedFactories.remove(object);
                this.selectedFactories.add(index - 1, object);
            }
        }

        public void moveDown(Object object) {
            int index = this.selectedFactories.indexOf(object);
            if (index < this.selectedFactories.size() - 1) {
                this.selectedFactories.remove(object);
                this.selectedFactories.add(index + 1, object);
            }
        }

        public Object[] getChildren(Object parentElement) {
            int index = this.selectedFactories.indexOf(parentElement);
            if (index < this.selectedFactories.size() - 1) {
                return new Object[]{this.selectedFactories.get(index + 1)};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            int index = this.selectedFactories.indexOf(element);
            if (index <= 0 || this.selectedFactories.size() <= 1) {
                return null;
            }
            return this.selectedFactories.get(index - 1);
        }

        public boolean hasChildren(Object element) {
            int index = this.selectedFactories.indexOf(element);
            return index != -1 && index < this.selectedFactories.size() - 1;
        }

        public Object[] getElements(Object inputElement) {
            if (this.selectedFactories.size() > 0) {
                return new Object[]{this.selectedFactories.get(0)};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BreakpointContainerFactoryLabelProvider
    extends ViewLabelProvider {
        private HashMap fImageCache = new HashMap();

        BreakpointContainerFactoryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBreakpointContainerFactory) {
                return ((IBreakpointContainerFactory)element).getLabel();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor;
            if (element instanceof IBreakpointContainerFactory && (imageDescriptor = ((IBreakpointContainerFactory)element).getImageDescriptor()) != null) {
                Image image = (Image)this.fImageCache.get(imageDescriptor);
                if (image == null && (image = imageDescriptor.createImage()) != null) {
                    this.fImageCache.put(imageDescriptor, image);
                }
                return image;
            }
            return super.getImage(element);
        }

        public void dispose() {
            Iterator imageIter = this.fImageCache.values().iterator();
            while (imageIter.hasNext()) {
                ((Image)imageIter.next()).dispose();
            }
            super.dispose();
        }
    }
}

