/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerLabelProvider;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupPanel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class SourceContainerViewer
extends TreeViewer {
    private boolean fEnabled = true;
    private SourceLookupPanel fPanel;
    protected List fEntries = new ArrayList();

    public SourceContainerViewer(Composite parent, SourceLookupPanel panel) {
        super(parent);
        this.setContentProvider((IContentProvider)new ContentProvider());
        SourceContainerLabelProvider lp = new SourceContainerLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)lp);
        this.fPanel = panel;
    }

    public void setEntries(ISourceContainer[] entries) {
        this.fEntries.clear();
        int i = 0;
        while (i < entries.length) {
            if (entries[i] != null) {
                this.fEntries.add(entries[i]);
            }
            ++i;
        }
        if (this.getInput() == null) {
            this.setInput(this.fEntries);
            if (!this.fEntries.isEmpty() && this.fEntries.get(0) != null) {
                this.setSelection((ISelection)new StructuredSelection(this.fEntries.get(0)));
            }
        } else {
            this.refresh();
        }
        this.fPanel.setDirty(true);
        this.fPanel.updateLaunchConfigurationDialog();
    }

    public ISourceContainer[] getEntries() {
        return this.fEntries.toArray(new ISourceContainer[this.fEntries.size()]);
    }

    public void addEntries(ISourceContainer[] entries) {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel.isEmpty()) {
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(entries[i]);
                }
                ++i;
            }
        } else {
            int index = this.fEntries.indexOf(sel.getFirstElement());
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(index, entries[i]);
                    ++index;
                }
                ++i;
            }
        }
        if (!this.fEntries.isEmpty() && this.fEntries.get(0) != null) {
            this.setSelection((ISelection)new StructuredSelection(this.fEntries.get(0)));
        }
        this.refresh();
        this.fPanel.setDirty(true);
        this.fPanel.updateLaunchConfigurationDialog();
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.setSelection(this.getSelection());
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public int indexOf(ISourceContainer entry) {
        return this.fEntries.indexOf(entry);
    }

    public ISourceLookupDirector getSourceLocator() {
        return this.fPanel.fLocator;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SourceContainerViewer.this.getEntries();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            try {
                return ((ISourceContainer)parentElement).getSourceContainers();
            }
            catch (CoreException coreException) {
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return ((ISourceContainer)element).isComposite();
        }
    }
}

