/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.WorkbenchJob;

public class RemoteTreeContentManager
extends DeferredTreeContentManager {
    private RemoteTreeViewer fViewer;

    public RemoteTreeContentManager(ITreeContentProvider provider, RemoteTreeViewer viewer, IWorkbenchPartSite site) {
        super(provider, (AbstractTreeViewer)viewer, site);
        this.fViewer = viewer;
    }

    protected IElementCollector createElementCollector(final Object parent, PendingUpdateAdapter placeholder) {
        return new IElementCollector(){
            int offset = 0;

            public void add(Object element, IProgressMonitor monitor) {
                this.add(new Object[]{element}, monitor);
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                Object[] filtered = RemoteTreeContentManager.this.fViewer.filter(elements);
                RemoteTreeContentManager.this.replaceChildren(parent, filtered, this.offset, monitor);
                this.offset += filtered.length;
            }

            public void done() {
                RemoteTreeContentManager.this.prune(parent, this.offset);
            }
        };
    }

    public Object[] getChildren(Object parent) {
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        Object[] currentChildren = this.fViewer.getCurrentChildren(parent);
        PendingUpdateAdapter placeholder = null;
        if (currentChildren == null || currentChildren.length == 0) {
            placeholder = new PendingUpdateAdapter();
        }
        this.startFetchingDeferredChildren(parent, element, placeholder);
        if (placeholder == null) {
            return currentChildren;
        }
        return new Object[]{placeholder};
    }

    protected void replaceChildren(final Object parent, final Object[] children, final int offset, IProgressMonitor monitor) {
        WorkbenchJob updateJob = new WorkbenchJob(DebugUIViewsMessages.getString("IncrementalDeferredTreeContentManager.0")){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.getControl().setRedraw(false);
                RemoteTreeContentManager.this.fViewer.replace(parent, children, offset);
                RemoteTreeContentManager.this.fViewer.getControl().setRedraw(true);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void prune(final Object parent, final int offset) {
        WorkbenchJob updateJob = new WorkbenchJob(DebugUIViewsMessages.getString("IncrementalDeferredTreeContentManager.1")){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.getControl().setRedraw(false);
                RemoteTreeContentManager.this.fViewer.prune(parent, offset);
                RemoteTreeContentManager.this.fViewer.getControl().setRedraw(true);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void runClearPlaceholderJob(PendingUpdateAdapter placeholder) {
        if (placeholder != null) {
            super.runClearPlaceholderJob(placeholder);
        }
    }
}

