/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactoryDelegate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class BreakpointContainerFactory
implements IBreakpointContainerFactory {
    private ImageDescriptor fImage;
    private IBreakpointContainerFactoryDelegate fDelegate;
    private IConfigurationElement fConfigurationElement;

    public BreakpointContainerFactory(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public String getLabel() {
        return this.fConfigurationElement.getAttribute("label");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImage == null) {
            this.fImage = this.loadImageDescriptor();
        }
        return this.fImage;
    }

    public String getIdentifier() {
        return this.fConfigurationElement.getAttribute("id");
    }

    public IBreakpointContainerFactoryDelegate getDelegate() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (IBreakpointContainerFactoryDelegate)this.fConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.fDelegate;
    }

    public IBreakpointContainer[] getContainers(IBreakpointContainer parentContainer) {
        IBreakpoint[] breakpoints = this.getBreakpoints(parentContainer);
        IBreakpointContainerFactoryDelegate delegate = this.getDelegate();
        if (delegate == null) {
            return new IBreakpointContainer[]{new BreakpointContainer(breakpoints, this, DebugUIViewsMessages.getString("BreakpointContainerFactory.0"))};
        }
        IBreakpointContainer[] containers = delegate.createContainers(breakpoints, this);
        if (parentContainer != null) {
            parentContainer.setContainers(containers);
            int i = 0;
            while (i < containers.length) {
                containers[i].setParentContainer(parentContainer);
                ++i;
            }
        }
        return containers;
    }

    public void dispose() {
        if (this.fDelegate != null) {
            this.fDelegate.dispose();
        }
    }

    public IBreakpoint[] getBreakpoints(IBreakpointContainer container) {
        if (container != null) {
            return container.getBreakpoints();
        }
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
    }

    protected ImageDescriptor loadImageDescriptor() {
        ImageDescriptor descriptor = null;
        String iconPath = this.fConfigurationElement.getAttribute("icon");
        if (iconPath != null) {
            try {
                Bundle bundle = Platform.getBundle((String)this.fConfigurationElement.getNamespace());
                URL iconURL = bundle.getEntry("/");
                iconURL = new URL(iconURL, iconPath);
                descriptor = ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException e) {
                DebugUIPlugin.log(e);
            }
        }
        return descriptor;
    }
}

