/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactoryDelegate;
import org.eclipse.swt.graphics.Image;

public class BreakpointTypeContainerFactoryDelegate
implements IBreakpointContainerFactoryDelegate {
    private Image fContainerImage = null;

    public IBreakpointContainer[] createContainers(IBreakpoint[] breakpoints, IBreakpointContainerFactory factory) {
        if (this.fContainerImage == null) {
            this.fContainerImage = factory.getImageDescriptor().createImage();
        }
        HashMap<String, ArrayList<IBreakpoint>> map = new HashMap<String, ArrayList<IBreakpoint>>();
        int i = 0;
        while (i < breakpoints.length) {
            ArrayList<IBreakpoint> list;
            IBreakpoint breakpoint = breakpoints[i];
            String typeName = DebugPlugin.getDefault().getBreakpointManager().getTypeName(breakpoint);
            if (typeName == null) {
                typeName = DebugUIViewsMessages.getString("BreakpointTypeContainerFactory.0");
            }
            if ((list = (ArrayList<IBreakpoint>)map.get(typeName)) == null) {
                list = new ArrayList<IBreakpoint>();
                map.put(typeName, list);
            }
            list.add(breakpoint);
            ++i;
        }
        ArrayList<BreakpointContainer> containers = new ArrayList<BreakpointContainer>(map.size());
        Set typeNames = map.keySet();
        Iterator breakpointIter = typeNames.iterator();
        while (breakpointIter.hasNext()) {
            String typeName = (String)breakpointIter.next();
            List list = (List)map.get(typeName);
            BreakpointContainer container = new BreakpointContainer(list.toArray(new IBreakpoint[0]), factory, typeName);
            container.setContainerImage(this.fContainerImage);
            containers.add(container);
        }
        return containers.toArray(new IBreakpointContainer[containers.size()]);
    }

    public void dispose() {
        if (this.fContainerImage != null) {
            this.fContainerImage.dispose();
            this.fContainerImage = null;
        }
    }
}

