/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class ProcessConsoleManager
implements ILaunchListener {
    private Map fColorProviders;
    private IConsoleColorProvider fDefaultColorProvider;
    private Map fLineTrackers;
    private Map fProcesses;

    public void launchRemoved(ILaunch launch) {
        this.removeLaunch(launch);
    }

    protected void removeLaunch(ILaunch launch) {
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            IProcess iProcess = processes[i];
            this.removeProcess(iProcess);
            ++i;
        }
        if (this.fProcesses != null) {
            this.fProcesses.remove(launch);
        }
    }

    private void removeProcess(IProcess iProcess) {
        IConsole console = this.getConsole(iProcess);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
        }
    }

    public IConsole getConsole(IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ProcessConsole pc;
            IConsole console = consoles[i];
            if (console instanceof ProcessConsole && (pc = (ProcessConsole)console).getProcess().equals(process)) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(ILaunch launch) {
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            IProcess process;
            if (this.getConsoleDocument(processes[i]) == null && (process = processes[i]).getStreamsProxy() != null) {
                ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
                IConsoleColorProvider colorProvider = this.getColorProvider(process.getAttribute(IProcess.ATTR_PROCESS_TYPE));
                String encoding = null;
                try {
                    if (launchConfiguration != null) {
                        encoding = launchConfiguration.getAttribute(IDebugUIConstants.ATTR_CONSOLE_ENCODING, null);
                    }
                }
                catch (CoreException coreException) {}
                ProcessConsole pc = new ProcessConsole(process, colorProvider, encoding);
                pc.setAttribute(IDebugUIConstants.ATTR_CONSOLE_PROCESS, process);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pc});
            }
            ++i;
        }
        List removed = this.getRemovedProcesses(launch);
        if (removed != null) {
            Iterator iterator = removed.iterator();
            while (iterator.hasNext()) {
                IProcess p = (IProcess)iterator.next();
                this.removeProcess(p);
            }
        }
    }

    public IDocument getConsoleDocument(IProcess process) {
        ProcessConsole console = (ProcessConsole)this.getConsole(process);
        return console != null ? console.getDocument() : null;
    }

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public void shutdown() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            this.removeLaunch(launch);
            ++i;
        }
        launchManager.removeLaunchListener((ILaunchListener)this);
        if (this.fProcesses != null) {
            this.fProcesses.clear();
        }
    }

    protected void aboutToWriteSystemErr(IProcess process) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnErr")) {
            this.showConsole(process);
        }
    }

    protected void aboutToWriteSystemOut(IProcess process) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnOut")) {
            this.showConsole(process);
        }
    }

    protected void showConsole(IProcess process) {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(this.getConsole(process));
    }

    public IConsoleColorProvider getColorProvider(String type) {
        IConfigurationElement extension;
        if (this.fColorProviders == null) {
            this.fColorProviders = new HashMap();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "consoleColorProviders");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension2 = elements[i];
                this.fColorProviders.put(extension2.getAttributeAsIs("processType"), extension2);
                ++i;
            }
        }
        if ((extension = (IConfigurationElement)this.fColorProviders.get(type)) != null) {
            try {
                Object colorProvider = extension.createExecutableExtension("class");
                if (colorProvider instanceof IConsoleColorProvider) {
                    return (IConsoleColorProvider)colorProvider;
                }
                DebugUIPlugin.logErrorMessage(MessageFormat.format(ConsoleMessages.getString("ConsoleDocumentManager.1"), extension.getDeclaringExtension().getUniqueIdentifier()));
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        if (this.fDefaultColorProvider == null) {
            this.fDefaultColorProvider = new ConsoleColorProvider();
        }
        return this.fDefaultColorProvider;
    }

    public IConsoleLineTracker[] getLineTrackers(IProcess process) {
        List lineTrackerExtensions;
        String type = process.getAttribute(IProcess.ATTR_PROCESS_TYPE);
        if (this.fLineTrackers == null) {
            this.fLineTrackers = new HashMap();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "consoleLineTrackers");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension = elements[i];
                String processType = extension.getAttributeAsIs("processType");
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.fLineTrackers.get(processType);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    this.fLineTrackers.put(processType, list);
                }
                list.add(extension);
                ++i;
            }
        }
        ArrayList<Object> trackers = new ArrayList<Object>();
        if (type != null && (lineTrackerExtensions = (List)this.fLineTrackers.get(type)) != null) {
            Iterator i = lineTrackerExtensions.iterator();
            while (i.hasNext()) {
                IConfigurationElement element = (IConfigurationElement)i.next();
                try {
                    trackers.add(element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return trackers.toArray(new IConsoleLineTracker[0]);
    }

    private List getRemovedProcesses(ILaunch launch) {
        ArrayList<IProcess> removed = null;
        if (this.fProcesses == null) {
            this.fProcesses = new HashMap();
        }
        IProcess[] old = (IProcess[])this.fProcesses.get(launch);
        Object[] curr = launch.getProcesses();
        if (old != null) {
            int i = 0;
            while (i < old.length) {
                IProcess process = old[i];
                if (!this.contains(curr, process)) {
                    if (removed == null) {
                        removed = new ArrayList<IProcess>();
                    }
                    removed.add(process);
                }
                ++i;
            }
        }
        this.fProcesses.put(launch, curr);
        return removed;
    }

    private boolean contains(Object[] list, Object object) {
        int i = 0;
        while (i < list.length) {
            Object object2 = list[i];
            if (object2.equals(object)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

