/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.DebugViewDecoratingLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewInterimLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewLabelDecorator;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.launch.DebugViewContentProvider;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewContextListener;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;

public class LaunchView
extends AbstractDebugEventHandlerView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IPropertyChangeListener,
IResourceChangeListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2 {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private IStackFrame fStackFrame = null;
    private ISourceLookupResult fResult = null;
    private boolean fIsActive = true;
    private IResourceDeltaVisitor fVisitor = null;
    private IDebugEditorPresentation fEditorPresentation = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    private AddToFavoritesAction fAddToFavoritesAction = null;
    private EditSourceLookupPathAction fEditSourceAction = null;
    private LookupSourceAction fLookupAction = null;
    private LaunchViewContextListener fContextListener;
    private Job fSourceLookupJob = null;
    private Job fSourceDisplayJob = null;
    static /* synthetic */ Class class$0;

    public LaunchView() {
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.DEBUG_VIEW;
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction(this.getSite().getWorkbenchWindow().getShell(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        Runnable r = new Runnable(){

            public void run() {
                LaunchView.this.initializeSelection();
            }
        };
        this.asyncExec(r);
    }

    protected Viewer createViewer(Composite parent) {
        LaunchViewer lv = new LaunchViewer(parent);
        lv.addPostSelectionChangedListener(this);
        lv.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        lv.setContentProvider((IContentProvider)new DebugViewContentProvider(lv, this.getSite()));
        DelegatingModelPresentation presentation = new DelegatingModelPresentation();
        DebugViewDecoratingLabelProvider labelProvider = new DebugViewDecoratingLabelProvider((StructuredViewer)lv, new DebugViewInterimLabelProvider(presentation), new DebugViewLabelDecorator(presentation));
        lv.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fEditorPresentation = presentation;
        this.getSite().setSelectionProvider((ISelectionProvider)lv);
        lv.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.setEventHandler(new LaunchViewEventHandler(this));
        this.setActive(this.getSite().getPage().findView(this.getSite().getId()) != null);
        return lv;
    }

    public DebugViewLabelDecorator getLabelDecorator() {
        return (DebugViewLabelDecorator)((DebugViewDecoratingLabelProvider)((LaunchViewer)this.getViewer()).getLabelProvider()).getLabelDecorator();
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_1"), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_selected__2"))) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.getString("LaunchView.Exceptions_occurred_attempting_to_terminate_and_remove_3"), null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_4"), DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_failed_5"), (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void terminateAndRemove(Object element) throws DebugException {
        if (!(element instanceof ITerminate)) {
            return;
        }
        ITerminate terminable = (ITerminate)element;
        if (!terminable.canTerminate() && !terminable.isTerminated()) {
            return;
        }
        try {
            if (!terminable.isTerminated()) {
                terminable.terminate();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            LaunchView.remove(element);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        LaunchView.remove(element);
    }

    private static void remove(Object element) {
        ILaunch launch = null;
        if (element instanceof ILaunch) {
            launch = (ILaunch)element;
        } else if (element instanceof IDebugElement) {
            launch = ((IDebugElement)element).getLaunch();
        } else if (element instanceof IProcess) {
            launch = ((IProcess)element).getLaunch();
        } else {
            return;
        }
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        lManager.removeLaunch(launch);
    }

    protected void initializeSelection() {
        if (!this.isAvailable()) {
            return;
        }
        TreeViewer tv = (TreeViewer)this.getViewer();
        tv.expandToLevel(2);
        Object[] elements = tv.getExpandedElements();
        int i = 0;
        while (i < elements.length) {
            IStackFrame frame;
            if (elements[i] instanceof ILaunch && (frame = this.findFrame((ILaunch)elements[i])) != null) {
                this.autoExpand(frame, true);
            }
            ++i;
        }
    }

    protected IStackFrame findFrame(ILaunch launch) {
        IDebugTarget target = launch.getDebugTarget();
        if (target != null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        return threads[i].getTopStackFrame();
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        if (memento == null) {
            return;
        }
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    public void dispose() {
        RemoteTreeViewer viewer = (RemoteTreeViewer)this.getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(this);
            viewer.cancelJobs();
        }
        if (this.fContextListener != null) {
            this.fContextListener.dispose();
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        this.cleanup();
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void cleanup() {
        this.setSourceLookupResult(null);
        this.setStackFrame(null);
    }

    private void setSourceLookupResult(ISourceLookupResult result) {
        this.fResult = result;
    }

    private ISourceLookupResult getSourceLookupResult() {
        return this.fResult;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.clearStatusLine();
        this.updateObjects();
        this.showEditorForCurrentSelection();
        if (this.isActive()) {
            this.fContextListener.updateForSelection(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        }
    }

    public void redoSourceLookup() {
        this.setStackFrame(null);
        this.selectionChanged(null);
    }

    protected void cleanupLaunches(ILaunch[] launches) {
        this.fContextListener.launchesTerminated(launches);
        IStackFrame frame = this.getStackFrame();
        if (frame != null) {
            ILaunch frameLaunch = frame.getLaunch();
            int i = 0;
            while (i < launches.length) {
                ILaunch launch = launches[i];
                if (launch.equals(frameLaunch)) {
                    this.setStackFrame(null);
                }
                ++i;
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tViewer;
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        boolean expanded = (tViewer = (TreeViewer)this.getViewer()).getExpandedState(o);
        tViewer.setExpandedState(o, !expanded);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
        this.showEditorForCurrentSelection();
        if (this.isActive()) {
            this.fContextListener.updateForSelection(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        if (this.fContextListener != null) {
            this.fContextListener.perspectiveChanged(changeId);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (this.fContextListener != null) {
            this.fContextListener.perspectiveChanged(partRef, changeId);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
            this.showEditorForCurrentSelection();
            if (this.fContextListener != null) {
                this.fContextListener.loadTrackViews();
            }
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    protected void showEditorForCurrentSelection() {
        if (!this.isActive()) {
            return;
        }
        ISelection selection = this.getViewer().getSelection();
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (!(obj instanceof IStackFrame)) {
            return;
        }
        this.openEditorForStackFrame((IStackFrame)obj);
    }

    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fEditorPresentation).getPresentation(id);
    }

    protected void openEditorForStackFrame(IStackFrame stackFrame) {
        if (!stackFrame.isSuspended()) {
            return;
        }
        if (!stackFrame.equals(this.getStackFrame()) || this.getEditorInput() == null || this.getEditorId() == null) {
            this.setStackFrame(stackFrame);
            this.scheduleSourceLookup();
        } else {
            this.setStackFrame(stackFrame);
            this.scheduleSourceDisplay();
        }
    }

    private void scheduleSourceLookup() {
        if (this.fSourceLookupJob == null) {
            this.fSourceLookupJob = new SourceLookupJob();
        }
        this.fSourceLookupJob.schedule();
    }

    private void scheduleSourceDisplay() {
        if (this.fSourceDisplayJob == null) {
            this.fSourceDisplayJob = new SourceDisplayJob();
        }
        this.fSourceDisplayJob.schedule();
    }

    private IEditorInput getEditorInput() {
        if (this.fResult != null) {
            return this.fResult.getEditorInput();
        }
        return null;
    }

    private String getEditorId() {
        if (this.fResult != null) {
            return this.fResult.getEditorId();
        }
        return null;
    }

    public void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        action.setEnabled(action.isApplicableForSelection());
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    public void autoExpand(Object element, boolean selectNeeded) {
        boolean refresh = false;
        if (element instanceof IThread) {
            refresh = this.threadRefreshNeeded((IThread)element);
        }
        if (refresh) {
            this.getStructuredViewer().refresh(element);
        }
        LaunchViewer launchViewer = (LaunchViewer)this.getViewer();
        launchViewer.deferExpansion(element);
        if (selectNeeded) {
            launchViewer.setDeferredSelection(element);
        }
    }

    protected boolean threadRefreshNeeded(IThread thread) {
        LaunchViewer viewer = (LaunchViewer)this.getStructuredViewer();
        ILaunch launch = thread.getLaunch();
        TreeItem[] launches = viewer.getTree().getItems();
        int i = 0;
        block2: while (i < launches.length) {
            if (launches[i].getData() == launch) {
                IDebugTarget target = thread.getDebugTarget();
                TreeItem[] targets = launches[i].getItems();
                int j = 0;
                while (j < targets.length) {
                    if (targets[j].getData() == target) {
                        TreeItem[] threads = targets[j].getItems();
                        int k = 0;
                        while (k < threads.length) {
                            if (threads[k].getData() == thread) {
                                IStackFrame[] frames = null;
                                try {
                                    frames = thread.getStackFrames();
                                }
                                catch (DebugException debugException) {
                                    return true;
                                }
                                TreeItem[] treeFrames = threads[k].getItems();
                                if (frames.length != treeFrames.length) {
                                    return true;
                                }
                                int l = 0;
                                int numFrames = treeFrames.length;
                                while (l < numFrames) {
                                    if (treeFrames[l].getData() != frames[l]) {
                                        return true;
                                    }
                                    ++l;
                                }
                                break block2;
                            }
                            ++k;
                        }
                        break block2;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return false;
    }

    protected IStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected void setStackFrame(IStackFrame frame) {
        this.fStackFrame = frame;
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES)) {
            this.fContextListener.reloadAutoManagePerspectives(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        } else if (property.equals(LaunchViewContextListener.PREF_OPENED_VIEWS) && this.fContextListener != null) {
            this.fContextListener.loadOpenedViews();
        } else if (property.equals(LaunchViewContextListener.PREF_VIEWS_TO_NOT_OPEN) && this.fContextListener != null) {
            this.fContextListener.reloadViewsToNotOpen(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        } else if (property.equals(IInternalDebugUIConstants.PREF_TRACK_VIEWS) && this.fContextListener != null) {
            this.fContextListener.loadTrackViews();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(this.getVisitor());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    protected IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new LaunchViewVisitor();
        }
        return this.fVisitor;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.isEmpty() || !selection.getFirstElement().equals(this.getStackFrame())) {
            this.initializeSelection();
        }
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            this.getViewer().setSelection(selection, true);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection;
        if (this.isActive() && !(selection = (IStructuredSelection)this.getViewer().getSelection()).isEmpty()) {
            Object sourceElement = null;
            if (this.fResult != null) {
                sourceElement = this.fResult.getSourceElement();
            }
            if (sourceElement instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)sourceElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) {
                    return new ShowInContext(null, (ISelection)new StructuredSelection(sourceElement));
                }
            }
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet(IDebugUIConstants.DEBUG_ACTION_SET);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.fContextListener = new LaunchViewContextListener(this);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    class SourceLookupJob
    extends Job {
        public SourceLookupJob() {
            super(DebugUIViewsMessages.getString("LaunchView.0"));
            this.setPriority(10);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                IStackFrame frame = LaunchView.this.getStackFrame();
                ISourceLookupResult result = null;
                if (frame != null) {
                    result = DebugUITools.lookupSource(frame, null);
                }
                LaunchView.this.setSourceLookupResult(result);
                LaunchView.this.scheduleSourceDisplay();
            }
            return Status.OK_STATUS;
        }
    }

    class SourceDisplayJob
    extends UIJob {
        public SourceDisplayJob() {
            super(DebugUIViewsMessages.getString("LaunchView.1"));
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ISourceLookupResult result;
            if (!monitor.isCanceled() && (result = LaunchView.this.getSourceLookupResult()) != null) {
                DebugUITools.displaySource(result, LaunchView.this.getSite().getPage());
            }
            return Status.OK_STATUS;
        }
    }

    class LaunchViewVisitor
    implements IResourceDeltaVisitor {
        LaunchViewVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if ((delta.getFlags() & 0x4000) != 0) {
                IProject project;
                if (resource instanceof IProject && !(project = (IProject)resource).isOpen()) {
                    LaunchView.this.cleanup();
                }
                return false;
            }
            return resource instanceof IWorkspaceRoot;
        }
    }
}

