/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractTableViewTabLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected ITableMemoryViewTab fViewTab;
    protected AbstractMemoryRenderer fRenderer;

    public AbstractTableViewTabLabelProvider() {
    }

    public AbstractTableViewTabLabelProvider(ITableMemoryViewTab viewTab, AbstractMemoryRenderer renderer) {
        this.fViewTab = viewTab;
        this.setRenderer(renderer);
    }

    public void setViewTab(ITableMemoryViewTab viewTab) {
        this.fViewTab = viewTab;
    }

    public void setRenderer(AbstractMemoryRenderer renderer) {
        this.fRenderer = renderer;
        renderer.setViewTab(this.fViewTab);
    }

    public AbstractMemoryRenderer getRenderer() {
        return this.fRenderer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        int endOffset;
        if (columnIndex == 0) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
        }
        if (columnIndex > this.fViewTab.getBytesPerLine() / this.fViewTab.getBytesPerColumn()) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
        }
        int startOffset = (columnIndex - 1) * this.fViewTab.getBytesPerColumn();
        if (((MemoryViewLine)element).isRangeChange(startOffset, endOffset = startOffset + this.fViewTab.getBytesPerColumn() - 1)) {
            return DebugPluginImages.getImage("IMG_OBJECT_MEMORY_CHANGED");
        }
        return DebugPluginImages.getImage("IMG_OBJECT_MEMORY");
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnLabel = null;
        if (columnIndex == 0) {
            columnLabel = ((MemoryViewLine)element).getAddress();
        } else if (columnIndex > this.fViewTab.getBytesPerLine() / this.fViewTab.getBytesPerColumn()) {
            columnLabel = " ";
        } else {
            int start = (columnIndex - 1) * this.fViewTab.getBytesPerColumn();
            int end = start + this.fViewTab.getBytesPerColumn();
            MemoryViewLine line = (MemoryViewLine)element;
            MemoryByte[] bytes = ((MemoryViewLine)element).getBytes(start, end);
            BigInteger address = new BigInteger(((MemoryViewLine)element).getAddress(), 16);
            address = address.add(BigInteger.valueOf(start));
            columnLabel = this.fRenderer.getString(this.fViewTab.getRenderingId(), address, bytes, line.getPaddedString());
        }
        return columnLabel;
    }
}

