/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockExtensionRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockModelPresentation;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMultipaneMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IRenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.MonitorMemoryBlockDialog;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class AddMemoryBlockAction
extends Action
implements ISelectionListener,
IDebugEventSetListener {
    private static String PREFIX = "AddMemoryBlockAction.";
    private static String TITLE = String.valueOf(PREFIX) + "title";
    private static String TOOLTIP = String.valueOf(PREFIX) + "tooltip";
    private static String FAILED = String.valueOf(PREFIX) + "failed";
    private static String EXPR_EVAL_FAILED = String.valueOf(PREFIX) + "expressionEvalFailed";
    private static String NO_MEMORY_BLOCK = String.valueOf(PREFIX) + "noMemoryBlock";
    protected ISelection fCurrentSelection = null;
    protected IMemoryBlock fLastMemoryBlock;
    private boolean fAddDefaultRenderings = true;
    protected IMemoryViewPane fViewPane;
    static /* synthetic */ Class class$0;

    public AddMemoryBlockAction(IMemoryViewPane viewPane) {
        this.initialize(viewPane);
    }

    AddMemoryBlockAction(IMemoryViewPane viewPane, boolean addDefaultRenderings) {
        this.initialize(viewPane);
        this.fAddDefaultRenderings = addDefaultRenderings;
    }

    private void initialize(IMemoryViewPane viewPane) {
        ISelection selection;
        this.fViewPane = viewPane;
        this.setText(DebugUIMessages.getString(TITLE));
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fCurrentSelection = selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public AddMemoryBlockAction(String text, int style) {
        super(text, style);
        ISelection selection;
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fCurrentSelection = selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void run() {
        IMemoryBlockRetrieval standardMemRetrieval;
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IDebugElement iDebugElement = (IDebugElement)elem;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((standardMemRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
            standardMemRetrieval = debugTarget;
        }
        if (standardMemRetrieval == null) {
            return;
        }
        Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        MonitorMemoryBlockDialog dialog = new MonitorMemoryBlockDialog(shell, standardMemRetrieval);
        dialog.open();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            return;
        }
        String expression = dialog.getExpression();
        try {
            if (standardMemRetrieval instanceof IMemoryBlockExtensionRetrieval) {
                IMemoryBlockExtensionRetrieval memRetrieval = (IMemoryBlockExtensionRetrieval)standardMemRetrieval;
                IMemoryBlockExtension memBlock = memRetrieval.getExtendedMemoryBlock(expression, (IDebugElement)elem);
                if (memBlock != null) {
                    this.fLastMemoryBlock = memBlock;
                    MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(new IMemoryBlock[]{memBlock});
                    if (this.fAddDefaultRenderings) {
                        this.addDefaultRenderings((IMemoryBlock)memBlock);
                    }
                    this.switchMemoryBlockToTop(this.fLastMemoryBlock);
                } else {
                    MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(NO_MEMORY_BLOCK), null);
                }
            } else {
                IMemoryBlock memBlock;
                String hexPrefix;
                if ((expression = expression.toUpperCase()).startsWith(hexPrefix = "0X")) {
                    expression = expression.substring(hexPrefix.length());
                }
                BigInteger address = new BigInteger(expression, 16);
                long longAddress = address.longValue();
                String strLength = dialog.getLength();
                long length = Long.parseLong(strLength);
                if (length == 0L) {
                    length = 16L;
                }
                if ((memBlock = standardMemRetrieval.getMemoryBlock(longAddress, length)) instanceof IMemoryBlockExtension) {
                    Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "IMemoryBlockRetrieval returns IMemoryBlockExtension.  This may result in unexpected behavior.", null);
                    DebugUIPlugin.log((IStatus)status);
                }
                if (memBlock != null) {
                    this.fLastMemoryBlock = memBlock;
                    MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(new IMemoryBlock[]{memBlock});
                    if (this.fAddDefaultRenderings) {
                        this.addDefaultRenderings(memBlock);
                    }
                    this.switchMemoryBlockToTop(this.fLastMemoryBlock);
                } else {
                    MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(NO_MEMORY_BLOCK), null);
                }
            }
        }
        catch (DebugException e1) {
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(FAILED), (Exception)((Object)e1));
        }
        catch (NumberFormatException numberFormatException) {
            String message = String.valueOf(DebugUIMessages.getString(FAILED)) + "\n" + DebugUIMessages.getString(EXPR_EVAL_FAILED);
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), message, null);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        this.fCurrentSelection = selection;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    private void handleDebugEvent(DebugEvent event) {
        Object src = event.getSource();
        IDebugTarget srcDT = null;
        IDebugTarget selectionDT = null;
        if (event.getKind() == 8) {
            Object elem;
            if (src instanceof ITerminate && src instanceof IDebugElement) {
                srcDT = ((IDebugElement)src).getDebugTarget();
            }
            if (this.fCurrentSelection instanceof IStructuredSelection && (elem = ((IStructuredSelection)this.fCurrentSelection).getFirstElement()) instanceof IDebugElement) {
                selectionDT = ((IDebugElement)elem).getDebugTarget();
            }
            if (srcDT == selectionDT) {
                this.setEnabled(false);
            }
        }
    }

    public IMemoryBlock getLastMemoryBlock() {
        return this.fLastMemoryBlock;
    }

    private void switchMemoryBlockToTop(IMemoryBlock memoryBlock) {
        IMemoryView memoryView;
        IMemoryViewTab topTap;
        IMemoryViewPane viewPane;
        IWorkbenchPage p = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (p == null) {
            return;
        }
        Object view = null;
        view = p.findView("org.eclipse.debug.ui.MemoryView");
        if (view == null) {
            try {
                IWorkbenchPart activePart = p.getActivePart();
                view = (MemoryView)p.showView("org.eclipse.debug.ui.MemoryView");
                p.activate(activePart);
            }
            catch (PartInitException partInitException) {
                return;
            }
        }
        if (view instanceof IMultipaneMemoryView && (viewPane = ((IMultipaneMemoryView)view).getViewPane(this.fViewPane.getPaneId())) != null && viewPane instanceof IMemoryView && (topTap = (memoryView = (IMemoryView)((Object)viewPane)).getTopMemoryTab()) != null && topTap.getMemoryBlock() != memoryBlock) {
            IMemoryViewTab[] allTabs = memoryView.getAllViewTabs();
            IMemoryViewTab moveToTop = null;
            int i = 0;
            while (i < allTabs.length) {
                if (allTabs[i].getMemoryBlock() == memoryBlock) {
                    moveToTop = allTabs[i];
                    break;
                }
                ++i;
            }
            if (moveToTop != null) {
                memoryView.moveToTop(moveToTop);
            }
        }
    }

    protected void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock) {
        IMemoryRenderingType[] renderingTypes = MemoryRenderingManager.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                String[] viewIds = renderingTypes[i].getSupportedViewIds();
                boolean viewSupported = false;
                int j = 0;
                while (j < viewIds.length) {
                    if (viewIds[j].indexOf(IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE) != -1) {
                        viewSupported = true;
                        break;
                    }
                    ++j;
                }
                if (viewSupported) {
                    IMemoryViewPane viewPane;
                    IMemoryRendering rendering;
                    String paneId = IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE_1;
                    IDebugModelPresentation modelPresentation = DebugUIPlugin.getModelPresentation();
                    if (modelPresentation instanceof IMemoryBlockModelPresentation) {
                        paneId = ((IMemoryBlockModelPresentation)modelPresentation).getViewPaneIdForDefault(memoryBlock, renderingTypes[i]);
                    }
                    if (paneId == null) {
                        paneId = IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE_1;
                    }
                    if ((rendering = MemoryRenderingManager.getMemoryRenderingManager().createRendering(memoryBlock, renderingTypes[i].getRenderingId())) != null && (viewPane = this.getDefualtViewPane(paneId)) != null && viewPane instanceof IRenderingViewPane) {
                        ((IRenderingViewPane)viewPane).addMemoryRendering(rendering);
                    }
                }
            }
            catch (DebugException debugException) {
                DebugUIPlugin.logErrorMessage("Cannot create default rendering: " + renderingTypes[i].getRenderingId());
            }
            ++i;
        }
    }

    private IMemoryViewPane getDefualtViewPane(String paneId) {
        IWorkbenchPage p = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (p == null) {
            return null;
        }
        IViewPart view = null;
        view = p.findView("org.eclipse.debug.ui.MemoryView");
        if (view != null && view instanceof IMultipaneMemoryView) {
            IMultipaneMemoryView memoryView = (IMultipaneMemoryView)view;
            IMemoryViewPane viewPane = memoryView.getViewPane(paneId);
            return viewPane;
        }
        return null;
    }
}

