/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class FormatColumnAction
extends Action {
    private static final String PREFIX = "FormatColumnAction.";
    private static final String UNIT = "FormatColumnAction.unit";
    private static final String UNITS = "FormatColumnAction.units";
    ITableMemoryViewTab fViewTab;
    int fNumBytesPerCol;

    public FormatColumnAction(int numUnits, int addressibleSize, ITableMemoryViewTab viewTab) {
        String label = numUnits > 1 ? String.valueOf(String.valueOf(numUnits)) + " " + DebugUIMessages.getString(UNIT) : String.valueOf(String.valueOf(numUnits)) + " " + DebugUIMessages.getString(UNITS);
        super.setText(label);
        this.fViewTab = viewTab;
        if (numUnits * addressibleSize == this.fViewTab.getBytesPerColumn()) {
            this.setChecked(true);
        }
        this.fNumBytesPerCol = numUnits * addressibleSize;
        WorkbenchHelp.setHelp((IAction)this, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".FormatColumnAction_context"));
    }

    public void run() {
        this.fViewTab.format(this.fViewTab.getBytesPerLine(), this.fNumBytesPerCol);
    }

    public int getColumnSize() {
        return this.fNumBytesPerCol;
    }
}

