/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMultipaneMemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.SetDefaultColumnSizePrefAction;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class MemoryView
extends ViewPart
implements IMultipaneMemoryView {
    protected MemoryViewSelectionProvider fSelectionProvider;
    private MemoryViewPartListener fPartListener;
    private SashForm fSashForm;
    private Hashtable fViewPanes = new Hashtable();
    private Hashtable fViewPaneControls = new Hashtable();
    private ArrayList fVisibleViewPanes = new ArrayList();
    private boolean fVisible;
    private ArrayList fWeights = new ArrayList();
    private static final String VISIBILITY_PREF = "org.eclipse.debug.ui.MemoryView.viewPanesVisibility";
    private String[] defaultVisiblePaneIds = new String[]{MemoryBlocksTreeViewPane.PANE_ID, IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE_1};
    private MemoryBlocksTreeViewPane fMemBlkViewer;

    public void createPartControl(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryView_context"));
        this.fSashForm = new SashForm(parent, 256);
        this.fSelectionProvider = new MemoryViewSelectionProvider();
        this.createMemoryBlocksTreeViewPane((Composite)this.fSashForm);
        this.createRenderingViewPane(IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE_1);
        this.createRenderingViewPane(IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE_2);
        this.setVisible(true);
        Integer[] weights = this.fWeights.toArray(new Integer[this.fWeights.size()]);
        int[] intWeights = new int[weights.length];
        int i = 0;
        while (i < weights.length) {
            intWeights[i] = weights[i];
            ++i;
        }
        this.fSashForm.setWeights(intWeights);
        this.loadViewPanesVisibility();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.contributeToActionBars();
        this.fPartListener = new MemoryViewPartListener(this);
        this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        this.restoreView();
    }

    private void createMemoryBlocksTreeViewPane(Composite parent) {
        this.fMemBlkViewer = new MemoryBlocksTreeViewPane((IViewPart)this);
        this.fViewPanes.put(MemoryBlocksTreeViewPane.PANE_ID, this.fMemBlkViewer);
        ViewForm viewerViewForm = new ViewForm(parent, 0x800000);
        this.fViewPaneControls.put(MemoryBlocksTreeViewPane.PANE_ID, viewerViewForm);
        this.fWeights.add(new Integer(15));
        this.fMemBlkViewer.addSelectionListener(this.fSelectionProvider);
        Control viewerControl = this.fMemBlkViewer.createViewPane((Composite)viewerViewForm, MemoryBlocksTreeViewPane.PANE_ID);
        viewerViewForm.setContent(viewerControl);
        ISelection selection = this.fMemBlkViewer.getSelectionProvider().getSelection();
        if (selection != null) {
            this.fSelectionProvider.setSelection(selection);
        }
        ToolBarManager viewerToolBarMgr = new ToolBarManager(0x800000);
        IAction[] actions = this.fMemBlkViewer.getActions();
        int i = 0;
        while (i < actions.length) {
            viewerToolBarMgr.add(actions[i]);
            ++i;
        }
        ToolBar viewerToolbar = viewerToolBarMgr.createControl((Composite)viewerViewForm);
        viewerViewForm.setTopRight((Control)viewerToolbar);
        Label viewerLabel = new Label((Composite)viewerViewForm, 64);
        viewerLabel.setText(DebugUIMessages.getString("MemoryView.Memory_monitors"));
        viewerViewForm.setTopLeft((Control)viewerLabel);
    }

    public void createRenderingViewPane(String paneId) {
        RenderingViewPane renderingPane = new RenderingViewPane((IViewPart)this);
        this.fViewPanes.put(paneId, renderingPane);
        ViewForm renderingViewForm = new ViewForm((Composite)this.fSashForm, 0x800000);
        this.fViewPaneControls.put(paneId, renderingViewForm);
        this.fWeights.add(new Integer(40));
        Control renderingControl = renderingPane.createViewPane((Composite)renderingViewForm, paneId);
        renderingViewForm.setContent(renderingControl);
        renderingPane.addSelectionListener(this.fSelectionProvider);
        ToolBarManager renderingViewMgr = new ToolBarManager(0x800000);
        IAction[] renderingActions = renderingPane.getActions();
        int i = 0;
        while (i < renderingActions.length) {
            renderingViewMgr.add(renderingActions[i]);
            ++i;
        }
        ToolBar renderingToolbar = renderingViewMgr.createControl((Composite)renderingViewForm);
        renderingViewForm.setTopRight((Control)renderingToolbar);
        Label renderingLabel = new Label((Composite)renderingViewForm, 0);
        renderingLabel.setText(DebugUIMessages.getString("MemoryView.Memory_renderings"));
        renderingViewForm.setTopLeft((Control)renderingLabel);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)new SetDefaultColumnSizePrefAction());
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        Enumeration enumeration = this.fViewPanes.elements();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof IMemoryViewPane)) continue;
            ((IMemoryViewPane)element).dispose();
        }
        this.fViewPaneControls.clear();
        super.dispose();
    }

    private void setVisible(boolean visible) {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            if (this.fVisible) {
                viewPanes[i].setVisible(visible && viewPanes[i].isVisible());
            } else if (this.isViewPaneVisible(viewPanes[i].getPaneId())) {
                viewPanes[i].setVisible(visible);
            }
            ++i;
        }
        this.fVisible = visible;
    }

    public IMemoryViewPane getViewPane(String paneId) {
        return (IMemoryViewPane)this.fViewPanes.get(paneId);
    }

    public IMemoryViewPane[] getViewPanes() {
        IMemoryViewPane[] viewPanes = new IMemoryViewPane[this.fViewPanes.size()];
        Enumeration enumeration = this.fViewPanes.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            viewPanes[i] = (IMemoryViewPane)enumeration.nextElement();
            ++i;
        }
        return viewPanes;
    }

    private void restoreView() {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            viewPanes[i].restoreViewPane();
            ++i;
        }
    }

    public void showViewPane(boolean show, String paneId) {
        Control viewPaneControl = (Control)this.fViewPaneControls.get(paneId);
        if (viewPaneControl != null) {
            Control[] children = this.fSashForm.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == viewPaneControl) {
                    children[i].setVisible(show);
                    IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
                    if (viewPane != null) {
                        viewPane.setVisible(show);
                    }
                }
                ++i;
            }
            this.fSashForm.layout();
        }
        this.storeViewPaneVisibility();
    }

    public boolean isViewPaneVisible(String paneId) {
        return this.fVisibleViewPanes.contains(paneId);
    }

    private void storeViewPaneVisibility() {
        this.fVisibleViewPanes.clear();
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        StringBuffer visibleViewPanes = new StringBuffer();
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            String paneId = (String)enumeration.nextElement();
            Control control = (Control)this.fViewPaneControls.get(paneId);
            if (!control.isVisible()) continue;
            visibleViewPanes.append(paneId);
            visibleViewPanes.append(",");
            this.fVisibleViewPanes.add(paneId);
        }
        prefs.setValue(VISIBILITY_PREF, visibleViewPanes.toString());
    }

    private void loadViewPanesVisibility() {
        String paneId;
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        String visiblePanes = prefs.getString(VISIBILITY_PREF);
        if (visiblePanes != null && visiblePanes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(visiblePanes, ",");
            while (tokenizer.hasMoreTokens()) {
                paneId = tokenizer.nextToken();
                this.fVisibleViewPanes.add(paneId);
            }
        } else {
            int i = 0;
            while (i < this.defaultVisiblePaneIds.length) {
                this.fVisibleViewPanes.add(this.defaultVisiblePaneIds[i]);
                ++i;
            }
        }
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            paneId = (String)enumeration.nextElement();
            boolean visible = false;
            if (this.fVisibleViewPanes.contains(paneId)) {
                visible = true;
            }
            Control control = (Control)this.fViewPaneControls.get(paneId);
            control.setVisible(visible);
            IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
            viewPane.setVisible(visible);
        }
        this.fSashForm.layout();
    }

    class MemoryViewSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        ArrayList fListeners = new ArrayList();
        ISelection fSelections = new StructuredSelection();

        MemoryViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return this.fSelections;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListeners.contains(listener)) {
                this.fListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            this.fSelections = selection;
            this.fireChanged();
        }

        public void fireChanged() {
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < this.fListeners.size()) {
                ((ISelectionChangedListener)this.fListeners.get(i)).selectionChanged(evt);
                ++i;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection viewPaneSelection = event.getSelection();
            if (viewPaneSelection instanceof IStructuredSelection) {
                Object selected = ((IStructuredSelection)viewPaneSelection).getFirstElement();
                StructuredSelection strucSelection = new StructuredSelection(new Object[]{selected});
                this.setSelection((ISelection)strucSelection);
            }
        }
    }

    class MemoryViewPartListener
    implements IPartListener2 {
        IMultipaneMemoryView fView = null;

        public MemoryViewPartListener(IMultipaneMemoryView view) {
            this.fView = view;
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(false);
            }
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(true);
                MemoryView.this.restoreView();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    }
}

