/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IRenderingViewPane;

public class RemoveMemoryRenderingAction
extends AbstractMemoryAction {
    private IMemoryViewPane fViewPane;

    public RemoveMemoryRenderingAction(IMemoryViewPane viewPane) {
        super(DebugUIMessages.getString("RemoveMemoryRenderingAction.Remove_rendering"), 1);
        this.setText(DebugUIMessages.getString("RemoveMemoryRenderingAction.Remove_rendering"));
        this.setToolTipText(DebugUIMessages.getString("RemoveMemoryRenderingAction.Remove_rendering"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
        this.fViewPane = viewPane;
    }

    public void run() {
        IMemoryRendering rendering;
        IMemoryViewTab topTab = this.getViewTab();
        if (topTab != null && (rendering = topTab.getRendering()) != null && this.fViewPane instanceof IRenderingViewPane) {
            ((IRenderingViewPane)this.fViewPane).removeMemoryRendering(rendering);
        }
    }

    IMemoryViewTab getViewTab() {
        if (this.fViewPane instanceof IMemoryView) {
            return ((IMemoryView)((Object)this.fViewPane)).getTopMemoryTab();
        }
        return null;
    }
}

