/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.CreateRenderingTab;
import org.eclipse.debug.internal.ui.views.memory.EmptyViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTabFactory;
import org.eclipse.debug.internal.ui.views.memory.IRenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RemoveMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneRenderingMgr;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class RenderingViewPane
extends AbstractMemoryViewPane
implements IRenderingViewPane {
    public static final String RENDERING_VIEW_PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.RenderingViewPane";
    private static final String VIEW_TAB_FACTORY = "viewTabFactory";
    private static final String RENDERER = "renderer";
    private static final String VALUE = "value";
    private Hashtable fTabFolderForMemoryBlock = new Hashtable();
    private Hashtable fMemoryBlockFromTabFolder = new Hashtable();
    private AddMemoryRenderingAction fAddMemoryRenderingAction;
    private IAction fRemoveMemoryRenderingAction;
    private ViewPaneRenderingMgr fRenderingMgr;
    static /* synthetic */ Class class$0;

    public RenderingViewPane(IViewPart parent) {
        super(parent);
    }

    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            IMemoryBlock memory = memoryBlocks[i];
            if (this.fTabFolderForMemoryBlock.containsKey(memory)) {
                if (this.fStackLayout.topControl != (TabFolder)this.fTabFolderForMemoryBlock.get(memory)) {
                    this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memory));
                    this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memory), this.fTabFolderForMemoryBlock.get(memory));
                    this.fViewPaneCanvas.layout();
                }
            } else {
                TabFolder folder = new TabFolder(this.fViewPaneCanvas, 0);
                TabItem newItem = new TabItem(folder, 0);
                CreateRenderingTab createTab = new CreateRenderingTab(memory, newItem, this.getInstance());
                folder.setSelection(0);
                this.fTabFolderForMemoryBlock.put(memory, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memory);
                this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memory), folder);
                this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memory));
                this.setRenderingSelection(createTab);
                MenuManager menuMgr = this.createContextMenuManager();
                Menu menu = menuMgr.createContextMenu((Control)folder);
                folder.setMenu(menu);
                this.fMenuMgr.put(folder, menuMgr);
                this.fViewPaneCanvas.layout();
            }
            this.updateToolBarActionsEnablement();
            ++i;
        }
    }

    private IMemoryBlockRetrieval getMemoryBlockRetrieval(IMemoryBlock memoryBlock) {
        IMemoryBlockRetrieval retrieval;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((retrieval = (IMemoryBlockRetrieval)memoryBlock.getAdapter((Class)clazz)) == null) {
            retrieval = memoryBlock.getDebugTarget();
        }
        return retrieval;
    }

    public void memoryBlocksRemoved(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                int j = 0;
                while (j < memoryBlocks.length) {
                    IMemoryBlock memory = memoryBlocks[j];
                    if (RenderingViewPane.this.fTabFolderForMemoryBlock == null) {
                        return;
                    }
                    IMemoryRendering[] renderings = RenderingViewPane.this.fRenderingMgr.getRenderingsFromMemoryBlock(memory);
                    int k = 0;
                    while (k < renderings.length) {
                        RenderingViewPane.this.removeMemoryRendering(renderings[k]);
                        ++k;
                    }
                    TabFolder tabFolder = (TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory);
                    if (tabFolder == null) {
                        return;
                    }
                    RenderingViewPane.this.fTabFolderForMemoryBlock.remove(memory);
                    RenderingViewPane.this.fMemoryBlockFromTabFolder.remove(tabFolder);
                    RenderingViewPane.this.fTabFolderForDebugView.remove(RenderingViewPane.this.getMemoryBlockRetrieval(memory));
                    if (!tabFolder.isDisposed()) {
                        IMemoryBlockRetrieval retrieve;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((retrieve = (IMemoryBlockRetrieval)memory.getAdapter((Class)clazz)) == null) {
                            retrieve = memory.getDebugTarget();
                        }
                        if (RenderingViewPane.this.fTabFolderForDebugView.contains(tabFolder)) {
                            RenderingViewPane.this.fTabFolderForDebugView.remove(retrieve);
                        }
                        TabItem[] items = tabFolder.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].getData() instanceof IMemoryViewTab) {
                                RenderingViewPane.this.disposeViewTab((IMemoryViewTab)items[i].getData(), items[i]);
                            }
                            ++i;
                        }
                        MenuManager menuMgr = (MenuManager)RenderingViewPane.this.fMenuMgr.get(tabFolder);
                        if (menuMgr != null) {
                            menuMgr.dispose();
                        }
                        tabFolder.dispose();
                        if (tabFolder == RenderingViewPane.this.fStackLayout.topControl) {
                            ISelection selection = DebugUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
                            IMemoryBlock blk = RenderingViewPane.this.getMemoryBlock(selection);
                            if (blk != null) {
                                if (blk != memory) {
                                    RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                                } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget()).length > 0) {
                                    blk = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget())[0];
                                    RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                                } else {
                                    RenderingViewPane.this.emptyFolder();
                                }
                            } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget()).length > 0) {
                                blk = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget())[0];
                                RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                            } else {
                                RenderingViewPane.this.emptyFolder();
                            }
                        }
                    }
                    RenderingViewPane.this.updateToolBarActionsEnablement();
                    ++j;
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        block14: {
            try {
                if (part == this) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                if (selection == null || selection.isEmpty()) {
                    if (part.getSite().getId().equals("org.eclipse.debug.ui.MemoryView")) {
                        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
                        if (lastViewTab != null) {
                            lastViewTab.setEnabled(false);
                        }
                        this.emptyFolder();
                    }
                    return;
                }
                IMemoryViewTab lastViewTab = this.getTopMemoryTab();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                if (elem instanceof IMemoryBlock) {
                    IMemoryBlock memBlock = (IMemoryBlock)elem;
                    if (this.fTabFolderForMemoryBlock == null) {
                        if (lastViewTab != null) {
                            lastViewTab.setEnabled(false);
                        }
                        this.emptyFolder();
                        return;
                    }
                    this.handleMemoryBlockSelection(lastViewTab, memBlock);
                    break block14;
                }
                if (elem instanceof IDebugElement) {
                    this.handleDebugElementSelection(lastViewTab, (IDebugElement)elem);
                    break block14;
                }
                if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                    if (lastViewTab != null) {
                        lastViewTab.setEnabled(false);
                    }
                    this.emptyFolder();
                }
                this.updateToolBarActionsEnablement();
                return;
            }
            catch (SWTException se) {
                DebugUIPlugin.log(se);
            }
        }
    }

    public void handleMemoryBlockSelection(final IMemoryViewTab lastViewTab, final IMemoryBlock memBlock) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IMemoryBlock currentBlk;
                if (memBlock.getDebugTarget().isDisconnected() || memBlock.getDebugTarget().isTerminated()) {
                    RenderingViewPane.this.emptyFolder();
                    return;
                }
                TabFolder currentFolder = (TabFolder)RenderingViewPane.this.fStackLayout.topControl;
                if (currentFolder != null && !currentFolder.isDisposed() && (currentBlk = (IMemoryBlock)RenderingViewPane.this.fMemoryBlockFromTabFolder.get(currentFolder)) != null && currentBlk == memBlock) {
                    return;
                }
                if (RenderingViewPane.this.getTopMemoryTab() != null && RenderingViewPane.this.getTopMemoryTab().getMemoryBlock() == memBlock) {
                    return;
                }
                if (RenderingViewPane.this.fTabFolderForMemoryBlock.containsKey(memBlock)) {
                    if (RenderingViewPane.this.fStackLayout.topControl != (TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memBlock)) {
                        RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memBlock));
                        RenderingViewPane.this.fViewPaneCanvas.layout();
                    }
                } else {
                    TabFolder folder = new TabFolder(RenderingViewPane.this.fViewPaneCanvas, 0);
                    RenderingViewPane.this.fTabFolderForMemoryBlock.put(memBlock, folder);
                    RenderingViewPane.this.fMemoryBlockFromTabFolder.put(folder, memBlock);
                    RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memBlock));
                    RenderingViewPane.this.fViewPaneCanvas.layout();
                }
                RenderingViewPane.this.fTabFolderForDebugView.put(RenderingViewPane.this.getMemoryBlockRetrieval(memBlock), RenderingViewPane.this.fTabFolderForMemoryBlock.get(memBlock));
                IMemoryRendering[] renderings = RenderingViewPane.this.fRenderingMgr.getRenderingsFromMemoryBlock(memBlock);
                TabFolder toDisplay = (TabFolder)RenderingViewPane.this.fStackLayout.topControl;
                RenderingViewPane.this.fTabFolderForDebugView.put(RenderingViewPane.this.getMemoryBlockRetrieval(memBlock), toDisplay);
                if (toDisplay.getItemCount() == 0) {
                    RenderingViewPane.this.restoreViewTabs(renderings);
                }
                IMemoryViewTab newViewTab = RenderingViewPane.this.getTopMemoryTab();
                if (lastViewTab != null && lastViewTab != newViewTab) {
                    lastViewTab.setEnabled(false);
                }
                if (newViewTab != null && !newViewTab.isEnabled() && RenderingViewPane.this.fVisible) {
                    newViewTab.setEnabled(RenderingViewPane.this.fVisible);
                }
                IMemoryViewTab viewTab = RenderingViewPane.this.getTopMemoryTab();
                RenderingViewPane.this.setRenderingSelection(viewTab);
                if (viewTab == null) {
                    TabItem newItem = new TabItem(toDisplay, 0);
                    CreateRenderingTab createTab = new CreateRenderingTab(memBlock, newItem, RenderingViewPane.this.getInstance());
                    RenderingViewPane.this.setRenderingSelection(createTab);
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    public void memoryBlockRenderingAdded(IMemoryRendering rendering) {
        String renderingId = rendering.getRenderingId();
        IMemoryBlock memoryblk = rendering.getBlock();
        IMemoryViewTabFactory viewTabFactory = this.getViewTabFactory(renderingId);
        if (viewTabFactory != null) {
            AbstractMemoryRenderer renderer;
            MenuManager menuMgr;
            TabItem tab;
            IMemoryViewTab viewTab;
            TabItem item;
            if (this.getTopMemoryTab() != null) {
                this.getTopMemoryTab().setEnabled(false);
            }
            if (this.fTabFolderForMemoryBlock.containsKey(memoryblk)) {
                if (this.fStackLayout.topControl != (TabFolder)this.fTabFolderForMemoryBlock.get(memoryblk)) {
                    this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memoryblk));
                    this.fViewPaneCanvas.layout();
                }
            } else {
                TabFolder folder = new TabFolder(this.fViewPaneCanvas, 0);
                this.fTabFolderForMemoryBlock.put(memoryblk, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memoryblk);
                this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memoryblk));
                this.fViewPaneCanvas.layout();
            }
            TabFolder tabFolder = (TabFolder)this.fStackLayout.topControl;
            this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memoryblk), tabFolder);
            if (tabFolder != null && tabFolder.getItemCount() >= 1 && (item = tabFolder.getItem(0)) != null && item.getData() instanceof CreateRenderingTab) {
                ((CreateRenderingTab)item.getData()).dispose();
                item.dispose();
            }
            if ((viewTab = viewTabFactory.createViewTab(memoryblk, tab = new TabItem(tabFolder, 0), menuMgr = this.createContextMenuManager(), rendering, renderer = this.getRenderer(renderingId))) != null) {
                tabFolder.setSelection(tabFolder.indexOf(tab));
                this.fMenuMgr.put(viewTab, menuMgr);
                this.setRenderingSelection(viewTab);
            } else {
                viewTab = new EmptyViewTab(memoryblk, tab, menuMgr, rendering);
                tabFolder.setSelection(tabFolder.indexOf(tab));
                this.fMenuMgr.put(viewTab, menuMgr);
                this.setRenderingSelection(viewTab);
            }
        } else {
            Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5013, String.valueOf(DebugUIMessages.getString("RenderingViewPane.NoViewTabFactory")) + renderingId, null);
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIMessages.getString("RenderingViewPane.Failed_To_Create_Rendering"), DebugUIMessages.getString("RenderingViewPane.Failed_To_Create_Selected_Rendering"), (IStatus)stat);
            }
            DebugUIPlugin.log((IStatus)stat);
            this.fRenderingMgr.removeMemoryBlockRendering(rendering.getBlock(), rendering.getRenderingId());
        }
        IMemoryViewTab top = this.getTopMemoryTab();
        if (top != null && !this.fVisible) {
            top.setEnabled(this.fVisible);
        }
        this.updateToolBarActionsEnablement();
    }

    public void memoryBlockRenderingRemoved(final IMemoryRendering rendering) {
        final IMemoryBlock memory = rendering.getBlock();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IMemoryViewTab top;
                TabFolder tabFolder = (TabFolder)RenderingViewPane.this.fStackLayout.topControl;
                if (tabFolder.isDisposed()) {
                    return;
                }
                TabItem[] tabs = tabFolder.getItems();
                boolean foundTab = false;
                int i = 0;
                while (i < tabs.length) {
                    IMemoryViewTab viewTab = (IMemoryViewTab)tabs[i].getData();
                    if (!tabs[i].isDisposed() && viewTab.getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                        foundTab = true;
                        RenderingViewPane.this.disposeViewTab(viewTab, tabs[i]);
                        break;
                    }
                    ++i;
                }
                if (!foundTab) {
                    Enumeration enumeration = RenderingViewPane.this.fTabFolderForMemoryBlock.elements();
                    block1: while (enumeration.hasMoreElements()) {
                        TabFolder otherTabFolder = (TabFolder)enumeration.nextElement();
                        tabs = otherTabFolder.getItems();
                        IMemoryViewTab viewTab = null;
                        int i2 = 0;
                        while (i2 < tabs.length) {
                            viewTab = (IMemoryViewTab)tabs[i2].getData();
                            if (viewTab.getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                                foundTab = true;
                                RenderingViewPane.this.disposeViewTab(viewTab, tabs[i2]);
                                continue block1;
                            }
                            ++i2;
                        }
                    }
                }
                if ((top = RenderingViewPane.this.getTopMemoryTab()) != null) {
                    RenderingViewPane.this.setRenderingSelection(top);
                } else if (tabFolder != RenderingViewPane.this.fEmptyTabFolder) {
                    TabItem newItem = new TabItem(tabFolder, 0);
                    CreateRenderingTab createTab = new CreateRenderingTab(memory, newItem, RenderingViewPane.this.getInstance());
                    tabFolder.setSelection(0);
                    RenderingViewPane.this.setRenderingSelection(createTab);
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    public IMemoryViewTabFactory getViewTabFactory(String renderingId) {
        IMemoryRenderingType info;
        if (this.fRenderingInfoTable == null) {
            this.fRenderingInfoTable = new Hashtable();
        }
        if ((info = (IMemoryRenderingType)this.fRenderingInfoTable.get(renderingId)) == null) {
            info = MemoryRenderingManager.getMemoryRenderingManager().getRenderingTypeById(renderingId);
            this.fRenderingInfoTable.put(renderingId, info);
        }
        if (info == null) {
            return null;
        }
        IConfigurationElement element = info.getPropertyConfigElement(VIEW_TAB_FACTORY);
        if (element == null) {
            return null;
        }
        try {
            if (element != null) {
                Object obj = element.createExecutableExtension(VALUE);
                if (obj instanceof IMemoryViewTabFactory) {
                    return (IMemoryViewTabFactory)obj;
                }
                return null;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public AbstractMemoryRenderer getRenderer(String renderingId) {
        IMemoryRenderingType info;
        if (this.fRenderingInfoTable == null) {
            this.fRenderingInfoTable = new Hashtable();
        }
        if ((info = (IMemoryRenderingType)this.fRenderingInfoTable.get(renderingId)) == null) {
            info = MemoryRenderingManager.getMemoryRenderingManager().getRenderingTypeById(renderingId);
            this.fRenderingInfoTable.put(renderingId, info);
        }
        if (info == null) {
            return null;
        }
        IConfigurationElement element = info.getPropertyConfigElement(RENDERER);
        if (element == null) {
            return null;
        }
        try {
            if (element != null) {
                Object obj = element.createExecutableExtension(VALUE);
                if (obj instanceof AbstractMemoryRenderer) {
                    return (AbstractMemoryRenderer)obj;
                }
                return null;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void setRenderingSelection(IMemoryViewTab viewTab) {
        IMemoryRendering rendering;
        if (viewTab != null && (rendering = viewTab.getRendering()) != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    private void restoreViewTabs(IMemoryRendering[] renderings) {
        int i = 0;
        while (i < renderings.length) {
            this.memoryBlockRenderingAdded(renderings[i]);
            ++i;
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IDebugElement element) {
        Class<?> clazz;
        if (element.getDebugTarget() == null) {
            return;
        }
        if (element.getDebugTarget().isDisconnected() || element.getDebugTarget().isTerminated()) {
            this.emptyFolder();
            return;
        }
        IMemoryBlockRetrieval currentRetrieve = null;
        TabFolder tabFolder = (TabFolder)this.fStackLayout.topControl;
        IMemoryBlock currentBlock = (IMemoryBlock)this.fMemoryBlockFromTabFolder.get(tabFolder);
        if (currentBlock != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((currentRetrieve = (IMemoryBlockRetrieval)currentBlock.getAdapter((Class)clazz2)) == null) {
                currentRetrieve = currentBlock.getDebugTarget();
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMemoryBlockRetrieval retrieve = (IMemoryBlockRetrieval)element.getAdapter((Class)clazz);
        IDebugTarget debugTarget = element.getDebugTarget();
        if (retrieve == null) {
            retrieve = debugTarget;
        }
        if (debugTarget == null || debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            this.emptyFolder();
            return;
        }
        if (retrieve != currentRetrieve) {
            TabFolder folder = (TabFolder)this.fTabFolderForDebugView.get(retrieve);
            if (folder != null) {
                this.setTabFolder(folder);
                this.fTabFolderForDebugView.put(retrieve, folder);
                this.fViewPaneCanvas.layout();
            } else {
                IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve);
                if (blocks.length > 0) {
                    this.handleMemoryBlockSelection(null, blocks[0]);
                } else {
                    this.emptyFolder();
                    this.fTabFolderForDebugView.put(retrieve, this.fEmptyTabFolder);
                    this.fViewPaneCanvas.layout();
                }
            }
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null) {
            if (!newViewTab.isEnabled() && this.fVisible) {
                newViewTab.setEnabled(this.fVisible);
            }
            this.setRenderingSelection(newViewTab);
        }
        this.updateToolBarActionsEnablement();
    }

    protected void addListeners() {
        super.addListeners();
    }

    protected void removeListeners() {
        super.removeListeners();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.getTopMemoryTab() == null) {
            return;
        }
        IMemoryRendering rendering = this.getTopMemoryTab().getRendering();
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Object getCurrentSelection() {
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering() != null) {
            return this.getTopMemoryTab().getRendering();
        }
        return new Object();
    }

    public IMemoryViewTab[] getAllViewTabs() {
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.setRenderingSelection(tab);
                this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                break;
            }
            ++i;
        }
    }

    public void restoreViewPane() {
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
        IMemoryBlock memoryBlock = this.getMemoryBlock(selection);
        if (memoryBlock == null && MemoryViewUtil.isValidSelection(selection = this.fSelectionProvider.getSelection())) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (!(elem instanceof IMemoryBlock)) {
                return;
            }
            memoryBlock = (IMemoryBlock)elem;
        }
        if (memoryBlock != null) {
            IMemoryViewTab top;
            TabFolder toDisplay;
            if (!this.fTabFolderForMemoryBlock.containsKey(memoryBlock)) {
                TabFolder folder = new TabFolder(this.fViewPaneCanvas, 0);
                this.fTabFolderForMemoryBlock.put(memoryBlock, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memoryBlock);
                this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock));
                this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memoryBlock), this.fTabFolderForMemoryBlock.get(memoryBlock));
                this.fViewPaneCanvas.layout();
            }
            if (this.fTabFolderForMemoryBlock.containsKey(memoryBlock) && (toDisplay = (TabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock)) != null) {
                this.setTabFolder(toDisplay);
                this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memoryBlock), toDisplay);
                this.fViewPaneCanvas.layout();
                IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
                if (toDisplay.getItemCount() == 0 || this.getTopMemoryTab() instanceof CreateRenderingTab) {
                    this.restoreViewTabs(renderings);
                }
            }
            if ((top = this.getTopMemoryTab()) != null) {
                top.setEnabled(this.fVisible);
            } else {
                TabFolder folder = (TabFolder)this.fStackLayout.topControl;
                TabItem newItem = new TabItem(folder, 0);
                new CreateRenderingTab(memoryBlock, newItem, this.getInstance());
                folder.setSelection(0);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.fAddMemoryRenderingAction.dispose();
        this.fTabFolderForMemoryBlock.clear();
        this.fTabFolderForMemoryBlock = null;
        this.fMemoryBlockFromTabFolder.clear();
        this.fMemoryBlockFromTabFolder = null;
        this.fRenderingMgr.dispose();
        this.fRenderingMgr = null;
    }

    public Control createViewPane(Composite parent, String paneId) {
        Control control = super.createViewPane(parent, paneId);
        this.fRenderingMgr = new ViewPaneRenderingMgr(this);
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryRenderingView_context"));
        return control;
    }

    public IAction[] getActions() {
        ArrayList<AddMemoryRenderingAction> actions = new ArrayList<AddMemoryRenderingAction>();
        if (this.fAddMemoryRenderingAction == null) {
            this.fAddMemoryRenderingAction = new AddMemoryRenderingAction(this);
        }
        actions.add(this.fAddMemoryRenderingAction);
        if (this.fRemoveMemoryRenderingAction == null) {
            this.fRemoveMemoryRenderingAction = new RemoveMemoryRenderingAction(this);
        }
        this.fRemoveMemoryRenderingAction.setEnabled(false);
        actions.add((AddMemoryRenderingAction)this.fRemoveMemoryRenderingAction);
        return actions.toArray(new IAction[actions.size()]);
    }

    protected void updateToolBarActionsEnablement() {
        IDebugTarget target = this.getSelectedDebugTarget();
        if (target != null) {
            IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(target);
            if (blocks.length > 0) {
                this.fRemoveMemoryRenderingAction.setEnabled(true);
            } else {
                this.fRemoveMemoryRenderingAction.setEnabled(false);
            }
        } else {
            this.fRemoveMemoryRenderingAction.setEnabled(false);
        }
    }

    private IDebugTarget getSelectedDebugTarget() {
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem != null && elem instanceof IDebugElement) {
                return ((IDebugElement)elem).getDebugTarget();
            }
            return null;
        }
        return null;
    }

    protected void emptyFolder() {
        super.emptyFolder();
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(new Object[0]));
    }

    public void addMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingAdded(rendering);
        this.fRenderingMgr.addMemoryBlockRendering(rendering);
    }

    public void removeMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingRemoved(rendering);
        this.fRenderingMgr.removeMemoryBlockRendering(rendering);
    }

    private RenderingViewPane getInstance() {
        return this;
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getBlock();
        }
        return null;
    }
}

