/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class ViewPaneSelectionProvider
implements ISelectionProvider {
    ArrayList fListeners = new ArrayList();
    ISelection fSelection;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListeners.contains(listener)) {
            this.fListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fSelection instanceof IStructuredSelection && selection instanceof IStructuredSelection) {
            Object newSel;
            Object currentSel = ((IStructuredSelection)this.fSelection).getFirstElement();
            if (currentSel != (newSel = ((IStructuredSelection)selection).getFirstElement())) {
                this.fSelection = selection;
                this.fireChanged();
            }
        } else if (this.fSelection != selection) {
            this.fSelection = selection;
            this.fireChanged();
        }
    }

    public void fireChanged() {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        int i = 0;
        while (i < this.fListeners.size()) {
            ((ISelectionChangedListener)this.fListeners.get(i)).selectionChanged(evt);
            ++i;
        }
    }
}

