/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.IConsole;

public class DebugUITools {
    public static Image getImage(String key) {
        return DebugPluginImages.getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DebugPluginImages.getImageDescriptor(key);
    }

    public static ImageDescriptor getDefaultImageDescriptor(Object element) {
        String imageKey = DebugUITools.getDefaultImageKey(element);
        if (imageKey == null) {
            return null;
        }
        return DebugPluginImages.getImageDescriptor(imageKey);
    }

    private static String getDefaultImageKey(Object element) {
        return ((DefaultLabelProvider)DebugUIPlugin.getDefaultLabelProvider()).getImageKey(element);
    }

    public static IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static IDebugModelPresentation newDebugModelPresentation() {
        return new DelegatingModelPresentation();
    }

    public static IDebugModelPresentation newDebugModelPresentation(String identifier) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null && id.equals(identifier)) {
                        return new LazyModelPresentation(elt);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IAdaptable getDebugContext() {
        return SelectedResourceManager.getDefault().getDebugContext();
    }

    public static IResource getSelectedResource() {
        return SelectedResourceManager.getDefault().getSelectedResource();
    }

    public static IProcess getCurrentProcess() {
        ILaunch[] launches;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()).length > 0) {
            context = launches[launches.length - 1];
        }
        if (context instanceof IDebugElement) {
            return ((IDebugElement)context).getDebugTarget().getProcess();
        }
        if (context instanceof IProcess) {
            return (IProcess)context;
        }
        if (context instanceof ILaunch) {
            IProcess process;
            ILaunch launch = (ILaunch)context;
            IDebugTarget target = launch.getDebugTarget();
            if (target != null && (process = target.getProcess()) != null) {
                return process;
            }
            IProcess[] ps = launch.getProcesses();
            if (ps.length > 0) {
                return ps[ps.length - 1];
            }
        }
        return null;
    }

    public static int openLaunchConfigurationDialog(Shell shell, IStructuredSelection selection, String mode) {
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        int i = 0;
        while (i < groups.length) {
            ILaunchGroup group = groups[i];
            if (group.getMode().equals(mode) && group.getCategory() == null) {
                return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, group.getIdentifier());
            }
            ++i;
        }
        return 1;
    }

    public static int openLaunchConfigurationDialogOnGroup(Shell shell, IStructuredSelection selection, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, groupIdentifier, null);
    }

    public static int openLaunchConfigurationDialogOnGroup(final Shell shell, final IStructuredSelection selection, final String groupIdentifier, final IStatus status) {
        final int[] result = new int[1];
        Runnable r = new Runnable(){

            public void run() {
                LaunchConfigurationsDialog dialog = (LaunchConfigurationsDialog)LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
                if (dialog != null) {
                    dialog.setInitialSelection(selection);
                    dialog.doInitialTreeSelection();
                    if (status != null) {
                        dialog.handleStatus(status);
                    }
                    result[0] = 0;
                } else {
                    dialog = new LaunchConfigurationsDialog(shell, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier));
                    dialog.setOpenMode(3);
                    dialog.setInitialSelection(selection);
                    dialog.setInitialStatus(status);
                    result[0] = dialog.open();
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return result[0];
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationPropertiesDialog(shell, configuration, groupIdentifier, null);
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationPropertiesDialog dialog = new LaunchConfigurationPropertiesDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationDialog dialog = new LaunchConfigurationDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static boolean saveAndBuildBeforeLaunch() {
        return DebugUIPlugin.saveAndBuild();
    }

    public static boolean saveBeforeLaunch() {
        return DebugUIPlugin.preLaunchSave();
    }

    public static void launch(ILaunchConfiguration configuration, String mode) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (launchInBackground) {
            DebugUIPlugin.launchInBackground(configuration, mode);
        } else {
            DebugUIPlugin.launchInForeground(configuration, mode);
        }
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
    }

    public static String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        return DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, mode);
    }

    public static void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        DebugUIPlugin.getDefault().getPerspectiveManager().setLaunchPerspective(type, mode, perspective);
    }

    public static boolean isPrivate(ILaunchConfiguration configuration) {
        return !LaunchConfigurationManager.isVisible(configuration);
    }

    public static void setUseStepFilters(boolean useStepFilters) {
        DebugUIPlugin.getDefault().getStepFilterManager().setUseStepFilters(useStepFilters);
    }

    public static boolean isUseStepFilters() {
        return DebugUIPlugin.getDefault().getStepFilterManager().isUseStepFilters();
    }

    public static IConsole getConsole(IProcess process) {
        return DebugUIPlugin.getDefault().getProcessConsoleManager().getConsole(process);
    }

    public static IConsole getConsole(IDebugElement element) {
        IProcess process = element.getDebugTarget().getProcess();
        if (process != null) {
            return DebugUITools.getConsole(process);
        }
        return null;
    }

    public static ILaunchGroup[] getLaunchGroups() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroups();
    }

    public static ILaunchGroup getLaunchGroup(ILaunchConfiguration configuration, String mode) {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configuration, mode);
    }

    public static ISourceLookupResult lookupSource(Object artifact, ISourceLocator locator) {
        return SourceLookupFacility.getDefault().lookup(artifact, locator);
    }

    public static void displaySource(ISourceLookupResult result, IWorkbenchPage page) {
        SourceLookupFacility.getDefault().display(result, page);
    }
}

