/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.SimilarityType;

public interface OrthoPairFilter {
    public boolean accept(OrthoPair var1);

    public static class ByRef
    implements OrthoPairFilter {
        String regex;

        public ByRef(String regex) {
            this.regex = regex;
        }

        public boolean accept(OrthoPair pair) {
            if (pair.getSimilarity() == SimilarityType.CURATED) {
                return pair.getRef().matches(this.regex);
            }
            return false;
        }
    }

    public static class BySimilarityType
    implements OrthoPairFilter {
        SimilarityType type;

        public BySimilarityType(SimilarityType type) {
            this.type = type;
        }

        public boolean accept(OrthoPair pair) {
            return pair.getSimilarity() == this.type;
        }
    }

    public static class ByMaxIdentity
    implements OrthoPairFilter {
        double hiLimit;

        public ByMaxIdentity(double hiLimit) {
            this.hiLimit = hiLimit;
        }

        public boolean accept(OrthoPair pair) {
            SimilarityType pairType = pair.getSimilarity();
            if (pairType == SimilarityType.TWIN || pairType == SimilarityType.MULTIPLE) {
                return pair.getPercentIdentity() < this.hiLimit;
            }
            return false;
        }
    }

    public static class ByMinIdentity
    implements OrthoPairFilter {
        double lowLimit;

        public ByMinIdentity(double lowLimit) {
            this.lowLimit = lowLimit;
        }

        public boolean accept(OrthoPair pair) {
            SimilarityType pairType = pair.getSimilarity();
            if (pairType == SimilarityType.TWIN || pairType == SimilarityType.MULTIPLE) {
                return pair.getPercentIdentity() >= this.lowLimit;
            }
            return false;
        }
    }

    public static final class Xor
    implements OrthoPairFilter {
        OrthoPairFilter a;
        OrthoPairFilter b;

        public Xor(OrthoPairFilter a, OrthoPairFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPair pair) {
            return this.a.accept(pair) ^ this.b.accept(pair);
        }
    }

    public static final class And
    implements OrthoPairFilter {
        OrthoPairFilter a;
        OrthoPairFilter b;

        public And(OrthoPairFilter a, OrthoPairFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPair pair) {
            return this.a.accept(pair) && this.b.accept(pair);
        }
    }

    public static final class Or
    implements OrthoPairFilter {
        OrthoPairFilter a;
        OrthoPairFilter b;

        public Or(OrthoPairFilter a, OrthoPairFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPair pair) {
            return this.a.accept(pair) || this.b.accept(pair);
        }
    }

    public static final class Not
    implements OrthoPairFilter {
        OrthoPairFilter a;

        public Not(OrthoPairFilter a) {
            this.a = a;
        }

        public boolean accept(OrthoPair pair) {
            return !this.a.accept(pair);
        }
    }

    public static final class AcceptAll
    implements OrthoPairFilter {
        public boolean accept(OrthoPair pair) {
            return true;
        }
    }
}

