/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.bio.program.ssaha.SearchListener;

public class HitMerger
implements SearchListener {
    private List hitList = new ArrayList();
    private int minLength;
    private SearchListener delegate;

    public HitMerger(SearchListener delegate, int minLength) {
        this.delegate = delegate;
        this.minLength = minLength;
    }

    public void startSearch(String seqID) {
        this.hitList.clear();
        this.delegate.startSearch(seqID);
    }

    public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
        Hit hit = new Hit(hitID, queryOffset, hitOffset, hitLength);
        this.hitList.add(hit);
    }

    public void endSearch(String seqID) {
        Collections.sort(this.hitList);
        block0: for (int i = 0; i < this.hitList.size(); ++i) {
            Hit low = (Hit)this.hitList.get(i);
            int ubound = low.queryOffset + low.hitOffset + low.hitLength * 2;
            for (int j = i + 1; j < this.hitList.size(); ++j) {
                Hit high = (Hit)this.hitList.get(j);
                if (ubound < high.queryOffset + high.hitOffset) break;
                if (!this.doOverlap(low, high)) continue;
                this.hitList.set(j, this.merge(low, high));
                continue block0;
            }
            if (low.hitLength < this.minLength) continue;
            this.delegate.hit(low.hitID, low.queryOffset, low.hitOffset, low.hitLength);
        }
        this.delegate.endSearch(seqID);
    }

    private Hit merge(Hit a, Hit b) {
        int qo = Math.min(a.queryOffset, b.queryOffset);
        int ho = Math.min(a.hitOffset, b.hitOffset);
        int len = Math.max(a.queryOffset + a.hitLength, b.queryOffset + b.hitLength) - qo;
        return new Hit(a.hitID, qo, ho, len);
    }

    private boolean doOverlap(Hit a, Hit b) {
        return a.hitID == b.hitID && a.queryOffset + a.hitLength >= b.queryOffset && a.queryOffset <= b.queryOffset + b.hitLength && a.queryOffset - b.queryOffset == a.hitOffset - b.hitOffset;
    }

    private static class Hit
    implements Comparable {
        public int hitID;
        public int queryOffset;
        public int hitOffset;
        public int hitLength;

        public Hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
            this.hitID = hitID;
            this.queryOffset = queryOffset;
            this.hitOffset = hitOffset;
            this.hitLength = hitLength;
        }

        public boolean equals(Object o) {
            if (o instanceof Hit) {
                Hit r = (Hit)o;
                return this.hitID == r.hitID && this.queryOffset == r.queryOffset && this.hitOffset == r.hitOffset && this.hitLength == r.hitLength;
            }
            return false;
        }

        public int compareTo(Object o) {
            Hit r = (Hit)o;
            if (this.hitID > r.hitID) {
                return 1;
            }
            if (this.hitID < r.hitID) {
                return -1;
            }
            int relDist = this.queryOffset + this.hitOffset - (r.queryOffset + r.hitOffset);
            if (relDist > 0) {
                return 1;
            }
            if (relDist < 0) {
                return -1;
            }
            if (this.hitOffset > r.hitOffset) {
                return 1;
            }
            if (this.hitOffset < r.hitOffset) {
                return -1;
            }
            if (this.hitLength > r.hitLength) {
                return 1;
            }
            if (this.hitLength < r.hitLength) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.hitID + " " + this.queryOffset + " " + this.hitOffset + " " + this.hitLength;
        }
    }
}

