/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.DummySequence;
import org.biojava.bio.seq.impl.RevCompSequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.impl.SubSequence;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public final class SequenceTools {
    private SequenceTools() {
    }

    public static Sequence createSequence(SymbolList syms, String uri, String name, Annotation ann) {
        return new SimpleSequence(syms, uri, name, ann);
    }

    public static Sequence subSequence(Sequence seq, int start, int end) throws IndexOutOfBoundsException {
        return new SubSequence(seq, start, end);
    }

    public static Sequence subSequence(Sequence seq, int start, int end, String name) throws IndexOutOfBoundsException {
        return new SubSequence(seq, start, end, name);
    }

    public static Sequence subSequence(Sequence seq, int start, int end, String name, StrandedFeature.Strand strand) throws IndexOutOfBoundsException, IllegalAlphabetException {
        Sequence s = SequenceTools.subSequence(seq, start, end, name);
        if (strand == StrandedFeature.NEGATIVE) {
            s = SequenceTools.reverseComplement(s);
        }
        return s;
    }

    public static Sequence reverseComplement(Sequence seq) throws IllegalAlphabetException {
        return new RevCompSequence(seq);
    }

    public static ViewSequence view(Sequence seq) {
        return new ViewSequence(seq);
    }

    public static ViewSequence view(Sequence seq, String name) {
        return new ViewSequence(seq, name);
    }

    public static ViewSequence view(Sequence seq, FeatureRealizer fr) {
        return new ViewSequence(seq, fr);
    }

    public static GappedSequence gappedView(Sequence seq) {
        return new SimpleGappedSequence(seq);
    }

    public static Sequence maskSequence(Sequence seq, RangeLocation loc) throws IndexOutOfBoundsException, IllegalArgumentException {
        GappedSequence gSeq = SequenceTools.gappedView(SequenceTools.subSequence(seq, loc.getMin(), loc.getMax(), seq.getName() + ":" + loc.toString()));
        gSeq.addGapsInSource(1, loc.getMin());
        gSeq.addGapsInSource(seq.length(), gSeq.length() - gSeq.length());
        return gSeq;
    }

    public static Sequence createDummy(String uri, String name) {
        return new DummySequence(uri, name);
    }

    public static Sequence createDummy(Alphabet alpha, int length, Symbol sym, String uri, String name) throws IllegalSymbolException {
        return SequenceTools.createSequence(new DummySymbolList(alpha, length, sym), uri, name, new SmallAnnotation());
    }

    public static void addAllFeatures(Sequence seq, FeatureHolder fh) throws ChangeVetoException, BioException {
        SequenceTools.addFeatures(seq, fh);
    }

    private static void addFeatures(FeatureHolder toAddTo, FeatureHolder thingsToAdd) throws ChangeVetoException, BioException {
        Iterator i = thingsToAdd.features();
        while (i.hasNext()) {
            Feature f2add = (Feature)i.next();
            Feature added = toAddTo.createFeature(f2add.makeTemplate());
            SequenceTools.addFeatures(added, f2add);
        }
    }
}

