/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.EmblFileFormer;
import org.biojava.bio.seq.io.GenEmblFeatureComparator;
import org.biojava.bio.seq.io.GenEmblPropertyComparator;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.ReferenceAnnotation;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SwissprotFileFormer;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class EmblLikeFormat
implements SequenceFormat,
Serializable,
ParseErrorSource,
ParseErrorListener {
    public static final String DEFAULT = "EMBL";
    protected static final String ID_TAG = "ID";
    protected static final String SIZE_TAG = "SIZE";
    protected static final String STRAND_NUMBER_TAG = "STRANDS";
    protected static final String TYPE_TAG = "TYPE";
    protected static final String CIRCULAR_TAG = "CIRCULAR";
    protected static final String DIVISION_TAG = "DIVISION";
    protected static final String DR_TAG = "DR";
    protected static final String ACCESSION_TAG = "AC";
    protected static final String VERSION_TAG = "SV";
    protected static final String DATE_TAG = "DT";
    protected static final String DEFINITION_TAG = "DE";
    protected static final String KEYWORDS_TAG = "KW";
    protected static final String SOURCE_TAG = "OS";
    protected static final String ORGANISM_TAG = "OC";
    protected static final String ORGANISM_XREF_TAG = "OX";
    protected static final String REFERENCE_TAG = "RN";
    protected static final String COORDINATE_TAG = "RP";
    protected static final String REF_ACCESSION_TAG = "RX";
    protected static final String AUTHORS_TAG = "RA";
    protected static final String TITLE_TAG = "RT";
    protected static final String JOURNAL_TAG = "RL";
    protected static final String COMMENT_TAG = "CC";
    protected static final String FEATURE_TAG = "FH";
    protected static final String SEPARATOR_TAG = "XX";
    protected static final String FEATURE_TABLE_TAG = "FT";
    protected static final String START_SEQUENCE_TAG = "SQ";
    protected static final String END_SEQUENCE_TAG = "//";
    private boolean elideSymbols = false;
    private Vector mListeners = new Vector();
    static /* synthetic */ Class class$org$biojava$bio$seq$io$ReferenceAnnotation;

    public void setElideSymbols(boolean b) {
        this.elideSymbols = b;
    }

    public boolean getElideSymbols() {
        return this.elideSymbols;
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        String line;
        if (listener instanceof ParseErrorSource) {
            ((ParseErrorSource)((Object)listener)).addParseErrorListener(this);
        }
        StreamParser sparser = null;
        boolean hasMoreSequence = true;
        boolean hasInternalWhitespace = false;
        listener.startSequence();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(END_SEQUENCE_TAG)) {
                block19: {
                    if (sparser != null) {
                        sparser.close();
                        sparser = null;
                    }
                    while (true) {
                        reader.mark(1);
                        int c = reader.read();
                        if (c == -1) {
                            hasMoreSequence = false;
                            break block19;
                        }
                        if (!Character.isWhitespace((char)c)) break;
                        hasInternalWhitespace = true;
                    }
                    if (hasInternalWhitespace) {
                        System.err.println("Warning: whitespace found between sequence entries");
                    }
                    reader.reset();
                }
                listener.endSequence();
                return hasMoreSequence;
            }
            if (line.startsWith(START_SEQUENCE_TAG)) {
                listener.addSequenceProperty(SEPARATOR_TAG, "");
                sparser = symParser.parseStream(listener);
                continue;
            }
            if (sparser == null) {
                String tag = line.substring(0, 2);
                String rest = null;
                if (line.length() > 5) {
                    rest = line.substring(5);
                }
                if (tag.equals(REFERENCE_TAG)) {
                    try {
                        ReferenceAnnotation refAnnot = new ReferenceAnnotation();
                        refAnnot.setProperty(tag, rest);
                        while (!tag.equals(SEPARATOR_TAG)) {
                            line = reader.readLine();
                            tag = line.substring(0, 2);
                            rest = line.length() > 5 ? line.substring(5) : null;
                            if (refAnnot.containsProperty(tag)) {
                                Object property = refAnnot.getProperty(tag);
                                if (property instanceof String) {
                                    ArrayList<Object> properties = new ArrayList<Object>();
                                    properties.add(property);
                                    properties.add(rest);
                                    refAnnot.setProperty(tag, properties);
                                }
                                if (property instanceof ArrayList) {
                                    ((ArrayList)property).add(rest);
                                }
                            } else {
                                refAnnot.setProperty(tag, rest);
                            }
                            if (!tag.equals(JOURNAL_TAG)) continue;
                        }
                        listener.addSequenceProperty(class$org$biojava$bio$seq$io$ReferenceAnnotation == null ? EmblLikeFormat.class$("org.biojava.bio.seq.io.ReferenceAnnotation") : class$org$biojava$bio$seq$io$ReferenceAnnotation, refAnnot);
                    }
                    catch (ChangeVetoException cve) {
                        cve.printStackTrace();
                    }
                    continue;
                }
                listener.addSequenceProperty(tag, rest);
                continue;
            }
            if (this.elideSymbols) continue;
            this.processSequenceLine(line, sparser);
        }
        if (sparser != null) {
            sparser.close();
        }
        throw new IOException("Premature end of stream or missing end tag '//' for EMBL");
    }

    protected void processSequenceLine(String line, StreamParser parser) throws IllegalSymbolException, ParseException {
        char[] cline = line.toCharArray();
        int parseStart = 0;
        int parseEnd = 0;
        while (parseStart < cline.length) {
            while (parseStart < cline.length && cline[parseStart] == ' ') {
                ++parseStart;
            }
            if (parseStart >= cline.length) break;
            if (Character.isDigit(cline[parseStart])) {
                return;
            }
            for (parseEnd = parseStart + 1; parseEnd < cline.length && cline[parseEnd] != ' '; ++parseEnd) {
                if (cline[parseEnd] != '.' && cline[parseEnd] != '~') continue;
                cline[parseEnd] = 45;
            }
            parser.characters(cline, parseStart, parseEnd - parseStart);
            parseStart = parseEnd;
        }
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        this.writeSequence(seq, this.getDefaultFormat(), os);
    }

    /*
     * WARNING - void declaration
     */
    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        void var4_4;
        AbstractGenEmblFileFormer former;
        if (format.equalsIgnoreCase(DEFAULT)) {
            former = new EmblFileFormer();
        } else if (format.equalsIgnoreCase("SWISSPROT")) {
            former = new SwissprotFileFormer();
        } else {
            throw new IllegalArgumentException("Unknown format '" + format + "'");
        }
        var4_4.setPrintStream(os);
        SeqIOEventEmitter emitter = new SeqIOEventEmitter(GenEmblPropertyComparator.INSTANCE, GenEmblFeatureComparator.INSTANCE);
        emitter.getSeqIOEvents(seq, (SeqIOListener)var4_4);
    }

    public String getDefaultFormat() {
        return DEFAULT;
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        EmblLikeFormat emblLikeFormat = this;
        synchronized (emblLikeFormat) {
            listeners = (Vector)this.mListeners.clone();
        }
        for (int index = 0; index < listeners.size(); ++index) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
        }
    }
}

