/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;

public class StructureImpl
implements Structure {
    String pdb_id;
    ArrayList models = new ArrayList();
    HashMap header;
    ArrayList connections;
    String name = "";
    boolean nmrflag = false;

    public void setPDBCode(String pdb_id_) {
        this.pdb_id = pdb_id_;
    }

    public String getPDBCode() {
        return this.pdb_id;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public void setHeader(HashMap h) {
        this.header = h;
    }

    public HashMap getHeader() {
        return this.header;
    }

    public void setConnections(ArrayList conns) {
        this.connections = conns;
    }

    public ArrayList getConnections() {
        return this.connections;
    }

    public void addChain(Chain chain) {
        int modelnr = 0;
        this.addChain(chain, modelnr);
    }

    public void addChain(Chain chain, int modelnr) {
        ArrayList model = (ArrayList)this.models.get(modelnr);
        model.add(chain);
    }

    public Chain getChain(int number) {
        int modelnr = 0;
        return this.getChain(modelnr, number);
    }

    public Chain getChain(int modelnr, int number) {
        ArrayList model = (ArrayList)this.models.get(modelnr);
        Chain chain = (Chain)model.get(number);
        return chain;
    }

    public void addModel(ArrayList model) {
        this.models.add(model);
    }

    public String toString() {
        String str = "structure " + this.name + " " + this.pdb_id;
        if (this.isNmr()) {
            str = str + " models: " + this.nrModels() + "\n";
        }
        str = str + this.header;
        for (int i = 0; i < this.nrModels(); ++i) {
            if (this.isNmr()) {
                str = str + " model[" + i + "]:";
            }
            str = str + " chains:";
            str = str + "\n";
            for (int j = 0; j < this.size(i); ++j) {
                Chain cha = this.getChain(i, j);
                ArrayList agr = cha.getGroups("amino");
                ArrayList hgr = cha.getGroups("hetatm");
                ArrayList ngr = cha.getGroups("nucleotide");
                str = str + "chain: >" + cha.getName() + "<" + " length: " + cha.getLength() + " aminos: " + agr.size() + " hetatms: " + hgr.size() + " nucleotides: " + ngr.size() + "\n";
            }
        }
        return str;
    }

    public int size() {
        int modelnr = 0;
        ArrayList model = null;
        if (this.models.size() <= 0) {
            return 0;
        }
        model = (ArrayList)this.models.get(modelnr);
        return model.size();
    }

    public int size(int modelnr) {
        return this.getChains(modelnr).size();
    }

    public int nrModels() {
        return this.models.size();
    }

    public boolean isNmr() {
        return this.nmrflag;
    }

    public void setNmr(boolean nmr) {
        this.nmrflag = nmr;
    }

    public ArrayList getChains(int modelnr) {
        return this.getModel(modelnr);
    }

    public ArrayList getModel(int modelnr) {
        ArrayList model = (ArrayList)this.models.get(modelnr);
        return model;
    }

    private String alignRight(String input, int length) {
        String str = "";
        int diff = length - input.length();
        for (int i = length; i > 0; --i) {
            if (i <= diff) {
                str = " " + str;
                continue;
            }
            int pos = input.length() - length + i - 1;
            str = input.charAt(pos) + str;
        }
        return str;
    }

    public String toPDB() {
        GroupIterator iter = new GroupIterator(this);
        String str = "";
        int i = 0;
        DecimalFormat d3 = new DecimalFormat("0.000");
        DecimalFormat d2 = new DecimalFormat("0.00");
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            String type = g.getType();
            String record = "";
            record = type.equals("hetatm") ? "HETATM" : "ATOM  ";
            AtomIterator aiter = new AtomIterator(g);
            String line = "";
            while (aiter.hasNext()) {
                ++i;
                Atom a = (Atom)aiter.next();
                int seri = a.getPDBserial();
                String serial = this.alignRight("" + seri, 5);
                String fullname = a.getFullName();
                String altLoc = " ";
                String chainID = " ";
                String resseq = this.alignRight("" + g.getPDBCode(), 4);
                String resName = g.getPDBName();
                String x = this.alignRight("" + d3.format(a.getX()), 8);
                String y = this.alignRight("" + d3.format(a.getY()), 8);
                String z = this.alignRight("" + d3.format(a.getZ()), 8);
                String occupancy = this.alignRight("" + d2.format(a.getOccupancy()), 6);
                String tempfactor = this.alignRight("" + d2.format(a.getTempFactor()), 6);
                line = record + serial + " " + fullname + altLoc + resName + " " + chainID + resseq + "    " + x + y + z + occupancy + tempfactor;
                str = str + line + "\n";
            }
        }
        return str;
    }
}

