/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.biojava.utils.xml.AppException;
import org.biojava.utils.xml.Initializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBeans {
    public static final XMLBeans INSTANCE = new XMLBeans();

    protected XMLBeans() {
    }

    public Object instantiateBean(Element bel) throws AppException {
        return this.instantiateBean(bel, ClassLoader.getSystemClassLoader(), new HashMap());
    }

    public Object instantiateBean(Element bel, ClassLoader cloader, Map beanRefs) throws AppException {
        String cl = bel.getAttribute("jclass");
        if (cl == null) {
            throw new AppException("No jclass attribute");
        }
        Object bean = null;
        try {
            Class<?> clazz = cloader.loadClass(cl);
            bean = clazz.newInstance();
            this.configureBean(bean, bel, beanRefs);
            if (bean instanceof Initializable) {
                ((Initializable)bean).init();
            }
        }
        catch (ClassNotFoundException ex) {
            throw new AppException("Couldn't load bean class " + cl);
        }
        catch (ClassCastException ex) {
            throw new AppException("Does not implement AppBean: " + cl);
        }
        catch (InstantiationException ex) {
            throw new AppException("Couldn't intantiate bean " + cl);
        }
        catch (IllegalAccessException ex) {
            throw new AppException("Couldn't access constructor for bean " + cl);
        }
        return bean;
    }

    private void configureBean(Object bean, Element el, Map refs) throws AppException {
        Class<?> clazz = bean.getClass();
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            String value;
            if (!(child instanceof Element)) continue;
            Element echild = (Element)child;
            String tag = echild.getTagName();
            String name = echild.getAttribute("name");
            Serializable valueObject = null;
            Class<Object> valueType = null;
            if (tag.equals("string")) {
                valueObject = echild.getAttribute("value");
                valueType = valueObject.getClass();
            } else if (tag.equals("bean") || tag.equals("child")) {
                String ref = echild.getAttribute("ref");
                Object targ = null;
                if (!ref.equals("")) {
                    targ = refs.get(ref);
                    if (targ == null) {
                        throw new NullPointerException("Can't find target for: " + ref);
                    }
                } else {
                    targ = this.instantiateBean(echild);
                }
                valueObject = targ;
                valueType = targ.getClass();
            } else if (tag.equals("int")) {
                value = echild.getAttribute("value");
                try {
                    int val = Integer.parseInt(value);
                    valueObject = new Integer(val);
                    valueType = Integer.TYPE;
                }
                catch (NumberFormatException ex) {
                    throw new AppException("Invalid int: " + value);
                }
            } else if (tag.equals("double")) {
                value = echild.getAttribute("value");
                try {
                    double val = Double.parseDouble(value);
                    valueObject = new Double(val);
                    valueType = Double.TYPE;
                }
                catch (NumberFormatException ex) {
                    throw new AppException("Invalid double: " + value);
                }
            } else if (tag.equals("boolean")) {
                value = echild.getAttribute("value");
                valueObject = new Boolean(value);
                valueType = Boolean.TYPE;
            } else if (tag.equals("set")) {
                valueObject = new HashSet();
                this.configureBean(valueObject, echild, refs);
                valueType = valueObject.getClass();
            } else if (tag.equals("list")) {
                valueObject = new ArrayList();
                this.configureBean(valueObject, echild, refs);
                valueType = valueObject.getClass();
            } else {
                throw new AppException("Unknown element `" + tag + "' in XML-bean");
            }
            if (name != null && name.length() > 0) {
                this.setProp(clazz, bean, name, valueObject, valueType);
                continue;
            }
            if (bean instanceof Collection) {
                ((Collection)bean).add(valueObject);
                continue;
            }
            throw new AppException("Anonymous beans are only allowed as children of Collections");
        }
    }

    private void setProp(Class clazz, Object bean, String prop, Object value, Class ourType) throws AppException {
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new AppException("Couldn't introspect class " + bean.getClass().getName());
        }
        PropertyDescriptor[] descs = bi.getPropertyDescriptors();
        for (int i = 0; i < descs.length; ++i) {
            if (!descs[i].getName().equals(prop)) continue;
            PropertyDescriptor desc = descs[i];
            if (!desc.getPropertyType().isAssignableFrom(ourType)) {
                throw new AppException("Property " + prop + " is not assignable from " + ourType.getName());
            }
            Object[] obj = new Object[]{value};
            try {
                desc.getWriteMethod().invoke(bean, obj);
            }
            catch (Exception ex) {
                throw new AppException("Invocation failed");
            }
            return;
        }
        throw new AppException("Couldn't find property " + prop + " in class " + clazz.getName());
    }
}

