/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.QNameMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxWriter
implements HierarchicalStreamWriter {
    private final QNameMap qnameMap;
    private final XMLStreamWriter out;
    private final boolean writeEnclosingDocument;
    private int tagDepth;

    public StaxWriter(QNameMap qnameMap, XMLStreamWriter out) throws XMLStreamException {
        this(qnameMap, out, true);
    }

    public StaxWriter(QNameMap qnameMap, XMLStreamWriter out, boolean writeEnclosingDocument) throws XMLStreamException {
        this.qnameMap = qnameMap;
        this.out = out;
        this.writeEnclosingDocument = writeEnclosingDocument;
        if (writeEnclosingDocument) {
            out.writeStartDocument();
        }
    }

    public void flush() {
        try {
            this.out.close();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void addAttribute(String name, String value) {
        try {
            this.out.writeAttribute(name, value);
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void endNode() {
        try {
            --this.tagDepth;
            this.out.writeEndElement();
            if (this.tagDepth == 0 && this.writeEnclosingDocument) {
                this.out.writeEndDocument();
            }
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void setValue(String text) {
        try {
            this.out.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void startNode(String name) {
        try {
            QName qname = this.qnameMap.getQName(name);
            String prefix = qname.getPrefix();
            String uri = qname.getNamespaceURI();
            if (prefix != null && prefix.length() > 0) {
                this.out.setPrefix(prefix, uri);
            } else if (uri != null && uri.length() > 0) {
                this.out.setDefaultNamespace(uri);
            }
            this.out.writeStartElement(prefix, qname.getLocalPart(), uri);
            ++this.tagDepth;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }
}

