/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.stats;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.stats.BundleStats;
import org.eclipse.osgi.framework.stats.ClassStats;
import org.eclipse.osgi.framework.stats.ClassloaderStats;
import org.osgi.framework.Bundle;

public class StatsManager
implements BundleWatcher {
    private Hashtable bundles = new Hashtable(20);
    private Map activationStacks = new HashMap(5);
    private static boolean booting = true;
    private static StatsManager defaultInstance;
    public static boolean MONITOR_ACTIVATION;
    public static boolean MONITOR_CLASSES;
    public static boolean MONITOR_RESOURCES;
    public static String TRACE_FILENAME;
    public static String TRACE_FILTERS;
    public static boolean TRACE_CLASSES;
    public static boolean TRACE_BUNDLES;
    public static final String FRAMEWORK_SYMBOLICNAME = "org.eclipse.osgi";
    private static final String OPTION_MONITOR_ACTIVATION = "org.eclipse.osgi/monitor/activation";
    private static final String OPTION_MONITOR_CLASSES = "org.eclipse.osgi/monitor/classes";
    private static final String OPTION_MONITOR_RESOURCES = "org.eclipse.osgi/monitor/resources";
    private static final String OPTION_TRACE_BUNDLES = "org.eclipse.osgi/trace/activation";
    private static final String OPTION_TRACE_CLASSES = "org.eclipse.osgi/trace/classLoading";
    private static final String OPTION_TRACE_FILENAME = "org.eclipse.osgi/trace/filename";
    private static final String OPTION_TRACE_FILTERS = "org.eclipse.osgi/trace/filters";

    static {
        MONITOR_ACTIVATION = false;
        MONITOR_CLASSES = false;
        MONITOR_RESOURCES = false;
        TRACE_FILENAME = "runtime.traces";
        TRACE_FILTERS = "trace.properties";
        TRACE_CLASSES = false;
        TRACE_BUNDLES = false;
        StatsManager.setDebugOptions();
    }

    public static StatsManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new StatsManager();
            defaultInstance.initialize();
        }
        return defaultInstance;
    }

    public static void setDebugOptions() {
        DebugOptions options = DebugOptions.getDefault();
        if (options == null) {
            return;
        }
        MONITOR_ACTIVATION = options.getBooleanOption(OPTION_MONITOR_ACTIVATION, false);
        MONITOR_CLASSES = options.getBooleanOption(OPTION_MONITOR_CLASSES, false);
        MONITOR_RESOURCES = options.getBooleanOption(OPTION_MONITOR_RESOURCES, false);
        TRACE_CLASSES = options.getBooleanOption(OPTION_TRACE_CLASSES, false);
        TRACE_BUNDLES = options.getBooleanOption(OPTION_TRACE_BUNDLES, false);
        TRACE_FILENAME = options.getOption(OPTION_TRACE_FILENAME, TRACE_FILENAME);
        TRACE_FILTERS = options.getOption(OPTION_TRACE_FILTERS, TRACE_FILTERS);
    }

    public static void doneBooting() {
        booting = false;
    }

    public static boolean isBooting() {
        return booting;
    }

    public static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private void initialize() {
        BundleStats bundle = this.findBundle(FRAMEWORK_SYMBOLICNAME, 0L);
        bundle.setTimestamp(System.currentTimeMillis());
        bundle.setActivationOrder(this.bundles.size());
        bundle.setDuringStartup(booting);
    }

    public void startActivation(Bundle bundle) {
        BundleStats info = this.findBundle(bundle.getSymbolicName(), bundle.getBundleId());
        info.setTimestamp(System.currentTimeMillis());
        info.setActivationOrder(this.bundles.size());
        info.setDuringStartup(booting);
        Stack<BundleStats> activationStack = (Stack<BundleStats>)this.activationStacks.get(Thread.currentThread());
        if (activationStack == null) {
            activationStack = new Stack<BundleStats>();
            this.activationStacks.put(Thread.currentThread(), activationStack);
        }
        if (activationStack.size() != 0) {
            BundleStats activatedBy = (BundleStats)activationStack.peek();
            activatedBy.activated(info);
            info.setActivatedBy(activatedBy);
        }
        activationStack.push(info);
        if (TRACE_BUNDLES) {
            this.traceActivate(bundle, info);
        }
    }

    public void endActivation(Bundle symbolicName) {
        Stack activationStack = (Stack)this.activationStacks.get(Thread.currentThread());
        BundleStats info = (BundleStats)activationStack.pop();
        info.endActivation();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceActivate(Bundle bundle, BundleStats info) {
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(ClassloaderStats.traceFile.getAbsolutePath(), true));
            try {
                long startPosition = ClassloaderStats.traceFile.length();
                output.println("Activating bundle: " + bundle.getSymbolicName());
                output.println("Bundle activation stack:");
                Stack activationStack = (Stack)this.activationStacks.get(Thread.currentThread());
                int i = activationStack.size() - 1;
                while (true) {
                    if (i < 0) break;
                    output.println("\t" + ((BundleStats)activationStack.get(i)).getSymbolicName());
                    --i;
                }
                output.println("Class loading stack:");
                Stack classStack = ClassloaderStats.getClassStack();
                int i2 = classStack.size() - 1;
                while (true) {
                    block7: {
                        if (i2 >= 0) break block7;
                        output.println("Stack trace:");
                        new Throwable().printStackTrace(output);
                        info.setTraceStart(startPosition);
                        break;
                    }
                    output.println("\t" + ((ClassStats)classStack.get(i2)).getClassName());
                    --i2;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                output.close();
                info.setTraceEnd(ClassloaderStats.traceFile.length());
                throw throwable;
            }
            {
                Object var9_12 = null;
                output.close();
                info.setTraceEnd(ClassloaderStats.traceFile.length());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BundleStats findBundle(String symbolicName, long id) {
        BundleStats result = (BundleStats)this.bundles.get(new Long(id));
        try {
            if (result == null) {
                result = new BundleStats(symbolicName, id);
                this.bundles.put(new Long(id), result);
            }
        }
        catch (IllegalAccessError e) {
            e.printStackTrace();
        }
        return result;
    }

    public BundleStats[] getBundles() {
        return this.bundles.values().toArray(new BundleStats[this.bundles.size()]);
    }

    public BundleStats getBundle(long id) {
        return (BundleStats)this.bundles.get(new Long(id));
    }
}

