/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.ISourceExecutor;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Util;
import bilab.seq;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOnManager {
    private XStream xstream = new XStream();
    private Map<String, ExternalFunction> externalFunctions;
    private ResourceManager rm;
    private ISourceExecutor executor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public AddOnManager(ResourceManager resourceManager, ISourceExecutor executor) {
        this.xstream.alias("addons", AddOns.class);
        this.xstream.alias("group", ExternalFunctionGroup.class);
        this.xstream.alias("command", ExternalCommand.class);
        this.xstream.alias("param", ExternalCommand.ParamInfo.class);
        this.xstream.alias("variable", ExternalFunction.Var.class);
        this.xstream.alias("file", ExternalCommand.File.class);
        this.xstream.addDefaultImplementation(LinkedList.class, List.class);
        this.xstream.addImplicitCollection(AddOns.class, "groups");
        this.externalFunctions = new HashMap<String, ExternalFunction>();
        this.rm = resourceManager;
        this.executor = executor;
    }

    public boolean processConfiguration(InputStream configStream) {
        AddOns newAddOns = null;
        try {
            newAddOns = (AddOns)this.xstream.fromXML((Reader)new InputStreamReader(configStream));
            for (ExternalFunctionGroup funcGroup : newAddOns.groups) {
                if (funcGroup.namespace == null) {
                    funcGroup.namespace = "";
                }
                for (ExternalFunction extFunc : funcGroup.externalFunctions) {
                    extFunc.group = funcGroup;
                    if (extFunc.namespace == null || extFunc.namespace.length() == 0) {
                        extFunc.namespace = funcGroup.namespace;
                    }
                    extFunc.debug = extFunc.debug || funcGroup.debug;
                    this.externalFunctions.put(String.valueOf(extFunc.namespace) + "." + extFunc.name, extFunc);
                }
            }
            configStream.close();
        }
        catch (Throwable t) {
            Notify.logError(this, "unable to read external addon configuration stream, may be invalid format (some external functions may be consequently unavailable):\n " + t.getMessage());
            return false;
        }
        try {
            for (ExternalFunctionGroup funcGroup : newAddOns.groups) {
                this.defneExternalFunctions(funcGroup.externalFunctions);
            }
        }
        catch (Exception e) {
            Notify.logError(this, "unable to define external functions from addon configuration stream, may be invalid format (some external functions may be consequently unavailable):\n " + e.getMessage());
            return false;
        }
        return true;
    }

    private void defneExternalFunctions(List<ExternalFunction> functions) {
        StringBuffer src = new StringBuffer();
        String namespaceName = null;
        String prevNamespace = null;
        boolean firstFunc = true;
        boolean blockOpen = false;
        src.append("{\n");
        for (ExternalFunction extFunc : functions) {
            if (extFunc instanceof ExternalCommand) {
                ExternalCommand cmd = (ExternalCommand)extFunc;
                namespaceName = cmd.namespace;
                if (firstFunc || !namespaceName.equals(prevNamespace)) {
                    if (blockOpen) {
                        src.append("  };\n");
                    }
                    blockOpen = true;
                    if (namespaceName != null && namespaceName.length() > 0) {
                        src.append("  namespace " + namespaceName + " {\n");
                    } else {
                        src.append("  {\n");
                    }
                }
                if (cmd.summary != null) {
                    src.append("    @[bilab.Summary(\"" + cmd.summary + "\")]\n");
                }
                if (cmd.docTextOrURL != null) {
                    src.append("    @[bilab.Doc(\"" + cmd.docTextOrURL + "\")]\n");
                }
                if (cmd.sophistication != null && !cmd.sophistication.equals("normal")) {
                    if (cmd.sophistication.equals("advanced")) {
                        src.append("    @[bilab.Sophistication(2)]\n");
                    } else if (cmd.sophistication.equals("developer")) {
                        src.append("    @[bilab.Sophistication(3)]\n");
                    } else {
                        Notify.devWarning(this, "invalid sophistication in configuration file for command '" + cmd.namespace + "." + cmd.name + "' (must be normal, advanced or developer)");
                    }
                }
                src.append("    let " + cmd.name + " = func(");
                int pi = 0;
                while (pi < cmd.params.size()) {
                    ExternalCommand.ParamInfo pinfo = cmd.params.get(pi);
                    src.append(String.valueOf(pinfo.name) + " :" + pinfo.type);
                    if (!pinfo.required) {
                        String defaultValue = this.substVariables(cmd, pinfo.defaultValue);
                        if (pinfo.type.equals("string") && defaultValue.charAt(0) != '\"') {
                            defaultValue = "\"" + defaultValue + "\"";
                        }
                        src.append(" = " + defaultValue);
                    }
                    if (pi != cmd.params.size() - 1) {
                        src.append(", ");
                    }
                    ++pi;
                }
                String returnType = cmd.returns == null || cmd.returns.length() == 0 ? "any" : cmd.returns;
                src.append("-> " + returnType + ") {\n");
                if (cmd.preProcess != null) {
                    src.append("      // pre-processing");
                    src.append("      " + cmd.preProcess + ";\n");
                }
                src.append("      let result = bilab.AddOnManager.callExtFunc(\"" + cmd.namespace + "\", \"" + cmd.name + "\"");
                if (cmd.params.size() > 0) {
                    src.append(", ");
                }
                int pi2 = 0;
                while (pi2 < cmd.params.size()) {
                    ExternalCommand.ParamInfo pinfo = cmd.params.get(pi2);
                    src.append(pinfo.name);
                    if (pi2 != cmd.params.size() - 1) {
                        src.append(", ");
                    }
                    ++pi2;
                }
                src.append(");\n");
                if (cmd.postProcess == null) {
                    src.append("      result;\n");
                } else {
                    src.append("      // post-processing");
                    src.append("      " + cmd.postProcess + ";\n");
                }
                src.append("    };\n\n");
            } else {
                Notify.devError(this, "unhandled ExternalFunction subtype:" + extFunc.getClass());
            }
            prevNamespace = namespaceName;
            firstFunc = false;
        }
        if (blockOpen) {
            src.append("  };\n");
        }
        src.append("}\n");
        try {
            this.executor.executeSource(src.toString());
        }
        catch (Exception e) {
            Notify.devError(this, "error Scigol source:" + e.getMessage() + "\n" + src.toString());
        }
    }

    public static Object callExtFunc(String namespaceName, String name, Object ... args) {
        return BilabPlugin.getAddOnManager().callExternalFunction(namespaceName, name, args);
    }

    public Object callExternalFunction(String namespaceName, String name, Object ... args) {
        ExternalFunction extFunc = this.externalFunctions.get(String.valueOf(namespaceName) + "." + name);
        if (extFunc == null) {
            throw new BilabException("no external function named '" + namespaceName + "." + name + "' has been registered");
        }
        if (extFunc instanceof ExternalCommand) {
            return this.callExternalCommand((ExternalCommand)extFunc, args);
        }
        Notify.devError(this, "unhandled ExternalFunction subtype:" + extFunc.getClass());
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object callExternalCommand(ExternalCommand cmd, Object ... args) {
        block71: {
            block69: {
                a = 0;
                fileIndex = 0;
                sawOptionalParam = false;
                p = 0;
                while (p < cmd.params.size()) {
                    pinfo = cmd.params.get(p);
                    argValue = null;
                    if (!pinfo.required) {
                        sawOptionalParam = true;
                        if (a < args.length) {
                            argValue = args[a];
                            ++a;
                        } else {
                            argValue = this.substVariables(cmd, pinfo.defaultValue);
                        }
                    } else {
                        if (sawOptionalParam) {
                            throw new BilabException("external command configuration for '" + cmd.namespace + "." + cmd.name + "' specifies a required parameter after an optional one, which isn't allowed.");
                        }
                        argValue = args[a];
                        ++a;
                    }
                    if (pinfo.allowedValues != null) {
                        if (pinfo.viaFile) {
                            throw new BilabException("external command configuration for '" + cmd.name + "' specified a set of allowed values for an input file parameter, which isn't legal.");
                        }
                        found = false;
                        v = 0;
                        while (v < pinfo.allowedValues.length && !found) {
                            if (((String)argValue).equals(pinfo.allowedValues[v])) {
                                found = true;
                            }
                            ++v;
                        }
                        if (!found) {
                            throw new BilabException("Illegal argument value for parameter '" + pinfo.name + "' of external function '" + cmd.namespace + "." + cmd.name + "'.");
                        }
                    }
                    if (!pinfo.viaFile) {
                        pinfo.value = argValue.toString();
                    } else {
                        if (cmd.inFiles == null || fileIndex >= cmd.inFiles.size()) {
                            throw new BilabException("Parameter '" + pinfo.name + "' of external function '" + cmd.namespace + "." + cmd.name + "' is marked as 'viaFile' but" + "there aren't enough <file>s in the <inFiles> element");
                        }
                        fileSpec = cmd.inFiles.get(fileIndex++);
                        requiredResType = fileSpec.resourceType;
                        resourceName = this.getExistingResourceName(argValue, requiredResType);
                        v0 = existingResourceAvail = resourceName != null ? 1 : 0;
                        if (existingResourceAvail == 0) {
                            resourceName = fileSpec.name;
                            if (resourceName.equals("$unique$")) {
                                resourceName = this.rm.uniqueTemporaryResourceName(requiredResType);
                                fileSpec.temporary = true;
                            } else {
                                resourceName = ResourceManager.filenameToResourceName(this.substVariables(cmd, resourceName));
                            }
                            this.rm.exportObjectToResource(argValue, requiredResType, resourceName);
                        }
                        fileSpec.actualName = this.rm.resourceNameToNativeFileName(resourceName);
                        pinfo.value = resourceName;
                    }
                    ++p;
                }
                if (cmd.outFiles != null) {
                    fi = 0;
                    while (fi < cmd.outFiles.size()) {
                        fileSpec = cmd.outFiles.get(fi);
                        name = fileSpec.name;
                        name = name.equals("$unique$") != false ? this.rm.uniqueTemporaryResourceName(fileSpec.resourceType) : ResourceManager.filenameToResourceName(this.substVariables(cmd, name));
                        fileSpec.actualName = this.rm.resourceNameToNativeFileName(name);
                        ++fi;
                    }
                    for (ExternalCommand.File file : cmd.outFiles) {
                        try {
                            this.rm.deleteResource(ResourceManager.filenameToResourceName(file.actualName));
                        }
                        catch (IOException v1) {}
                    }
                }
                commandDir = Util.toNativePathSeparator(this.substVariables(cmd, cmd.externalDir));
                commandName = cmd.executable != null ? this.substVariables(cmd, cmd.executable) : cmd.name;
                cmdargs = cmd.argumentTemplate != null ? this.substVariables(cmd, cmd.argumentTemplate) : "";
                cmdLineStrings = new LinkedList<String>();
                cmdLineStrings.add(String.valueOf(Util.toNativePathSeparator(String.valueOf(commandDir) + "/" + commandName)) + ResourceManager.exeSuffix);
                cmdArgStrings = cmdargs.split(" ");
                var14_20 = cmdArgStrings;
                existingResourceAvail = 0;
                var13_21 = var14_20.length;
                while (existingResourceAvail < var13_21) {
                    argStr = var14_20[existingResourceAvail];
                    cmdLineStrings.add(argStr);
                    ++existingResourceAvail;
                }
                if (cmd.debug) {
                    Notify.devInfo(this, "Executing command: " + commandName + ResourceManager.exeSuffix + " " + cmdargs);
                }
                pb = new ProcessBuilder(cmdLineStrings);
                env = pb.environment();
                if (cmd.env != null) {
                    for (ExternalFunction.Var envVar : cmd.env) {
                        name = this.substVariables(cmd, envVar.name);
                        value = this.substVariables(cmd, envVar.value);
                        env.put(name, value);
                    }
                }
                if (cmd.group.env != null) {
                    for (ExternalFunction.Var envVar : cmd.group.env) {
                        name = this.substVariables(cmd, envVar.name);
                        if (env.containsKey(name)) continue;
                        value = this.substVariables(cmd, envVar.value);
                        env.put(name, value);
                    }
                }
                v2 = workingDirStr = cmd.workingDir != null && cmd.workingDir.length() > 0 ? cmd.workingDir : cmd.group.workingDir;
                if (workingDirStr == null) {
                    workingDirStr = "";
                    Notify.devWarning(this, "no workingDir specified in configuration file for command '" + cmd.namespace + "." + cmd.name + "'");
                }
                workingDir = Util.toNativePathSeparator(this.substVariables(cmd, workingDirStr));
                pb.directory(new File(workingDir));
                pb.redirectErrorStream(cmd.returnStderrText);
                result = null;
                try {
                    block72: {
                        process = pb.start();
                        outputText = null;
                        stdin = null;
                        if (cmd.stdinText != null) {
                            stdinText = this.substVariables(cmd, cmd.stdinText);
                            stdinStream = process.getOutputStream();
                            stdin = new BufferedWriter(new OutputStreamWriter(stdinStream));
                            stdin.write(stdinText);
                            stdin.flush();
                            if (cmd.debug) {
                                Notify.devInfo(this, "Piped to command stdin:" + stdinText);
                            }
                        }
                        terminated = false;
                        terminated = true;
                        if (cmd.returnStdoutText || !terminated) {
                            cmdResultStream = process.getInputStream();
                            cmdResultReader = new InputStreamReader(cmdResultStream);
                            str = new StringBuilder();
                            c = cmdResultReader.read();
                            while (true) {
                                if (c == -1) {
                                    outputText = str.toString();
                                    break;
                                }
                                str.append((char)c);
                                c = cmdResultReader.read();
                            }
                        }
                        process.waitFor();
                        if (stdin != null) {
                            stdin.close();
                        }
                        if (terminated) break block72;
                        if (outputText == null) {
                            outputText = "";
                        }
                        Notify.logError(this, "Output of failed external command " + commandName + ResourceManager.exeSuffix + " " + cmdargs + ":\n" + outputText + "\n---\n");
                        Notify.userError(this, "external command failed to terminate.  See log for details");
                        var25_36 = null;
                        if (cmd.inFiles == null) break block69;
                        var27_37 = cmd.inFiles.iterator();
                        if (true) ** GOTO lbl193
                    }
                    if (cmd.stdoutResType != null) {
                        if (cmd.stdoutResType.equals("TEXT")) {
                            result = outputText;
                        } else {
                            Notify.unimplemented(this, "converting stdout to object via resource type " + cmd.stdoutResType);
                        }
                    } else if (cmd.returnStdoutText && outputText.length() > 0) {
                        Notify.devWarning(this, "output to console stream not implemented.");
                        System.out.println("stdout/stderr:\n" + outputText);
                    }
                    if (cmd.debug && (cmd.returnStdoutText || cmd.returnStderrText)) {
                        Notify.devInfo(this, "\n--- Command output:\n" + outputText + "\n---\n");
                    }
                    if (cmd.outFiles == null) {
                    }
                    if (cmd.outFiles.size() > 0) {
                        fileSpec = cmd.outFiles.get(0);
                        resourceName = ResourceManager.filenameToResourceName(fileSpec.actualName);
                        result = this.rm.instantiateObjectFromResource(resourceName, fileSpec.resourceType);
                    }
                }
                catch (InterruptedException v3) {
                    throw new BilabException("function '" + cmd.namespace + "." + cmd.name + "' was interrupted.");
                }
                catch (IOException e) {
                    throw new BilabException("An I/O error occured while executing function '" + cmd.namespace + "." + cmd.name + "' - " + e.getMessage());
                }
                finally {
                    if (cmd.inFiles == null) break block71;
                    var27_39 = cmd.inFiles.iterator();
                    if (true) ** GOTO lbl212
                }
                do {
                    file = var27_37.next();
                    if (!file.temporary) continue;
                    try {
                        this.rm.deleteResource(ResourceManager.filenameToResourceName(file.actualName));
                    }
                    catch (Exception e) {
                        Notify.devWarning(this, "unable to delete a resource - " + e.getMessage());
                    }
lbl193:
                    // 4 sources

                } while (var27_37.hasNext());
            }
            if (cmd.outFiles != null) {
                for (ExternalCommand.File file : cmd.outFiles) {
                    try {
                        this.rm.deleteResource(ResourceManager.filenameToResourceName(file.actualName));
                    }
                    catch (Exception e) {
                        Notify.devWarning(this, "unable to delete a resource - " + e.getMessage());
                    }
                }
            }
            return var25_36;
            do {
                file = var27_39.next();
                if (!file.temporary) continue;
                try {
                    this.rm.deleteResource(ResourceManager.filenameToResourceName(file.actualName));
                }
                catch (Exception e) {
                    Notify.devWarning(this, "unable to delete a resource - " + e.getMessage());
                }
lbl212:
                // 4 sources

            } while (var27_39.hasNext());
        }
        if (cmd.outFiles != null) {
            for (ExternalCommand.File file : cmd.outFiles) {
                try {
                    this.rm.deleteResource(ResourceManager.filenameToResourceName(file.actualName));
                }
                catch (Exception e) {
                    Notify.devWarning(this, "unable to delete a resource - " + e.getMessage());
                }
            }
        }
        return result;
    }

    private String substVariables(ExternalCommand cmd, String s) {
        String original = s;
        if (s.length() > 0 && s.charAt(0) == '!') {
            return Util.toNativePathSeparator(this.substVariables(cmd, s.substring(1)));
        }
        if (s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int i = s.indexOf(36);
        while (i != -1) {
            int fileIndex;
            sb.append(s.substring(0, i));
            s = s.substring(i + 1);
            int i2 = s.indexOf(36);
            if (i2 == -1) {
                Notify.devWarning(this, "mismatched '$' in add-on configuration file for command '" + cmd.namespace + "." + cmd.name + "' in string '" + original + "'");
                return original;
            }
            String varname = s.substring(0, i2);
            s = i2 + 1 < s.length() ? s.substring(i2 + 1) : "";
            String varvalue = "UNDEFINED";
            if (varname.equalsIgnoreCase("pluginRoot")) {
                try {
                    varvalue = this.rm.getPluginFilesystemRoot();
                }
                catch (IOException iOException) {
                    Notify.devError(this, "IO exception retrieving plugin root");
                }
            } else if (varname.startsWith("infile")) {
                fileIndex = Integer.parseInt(varname.substring(6));
                if (fileIndex < 0 || fileIndex >= cmd.inFiles.size()) {
                    Notify.devWarning(this, "invalid infile index in add-on configuration file for command '" + cmd.namespace + "." + cmd.name + "' in string '" + original + "'");
                    return original;
                }
                varvalue = cmd.inFiles.get((int)fileIndex).actualName;
            } else if (varname.startsWith("outfile")) {
                fileIndex = Integer.parseInt(varname.substring(7));
                if (fileIndex < 0 || fileIndex >= cmd.outFiles.size()) {
                    Notify.devWarning(this, "invalid outfile index in add-on configuration file for command '" + cmd.namespace + "." + cmd.name + "' in string '" + original + "'");
                    return original;
                }
                varvalue = cmd.outFiles.get((int)fileIndex).actualName;
            } else if (varname.charAt(0) == '?') {
                int ci = varname.indexOf(58);
                String condvalue = this.lookupVar(cmd, varname.substring(1, ci));
                varvalue = condvalue.equals("true") ? varname.substring(ci + 1) : "";
            } else if (varname.contains("[") && varname.contains("]")) {
                int li = varname.indexOf(91);
                int ri = varname.indexOf(93);
                String paramName = varname.substring(li + 1, ri);
                ExternalCommand.ParamInfo paramInfo = null;
                for (ExternalCommand.ParamInfo pinfo : cmd.params) {
                    if (!pinfo.name.equals(paramName)) continue;
                    paramInfo = pinfo;
                    break;
                }
                if (paramInfo == null) {
                    Notify.devWarning(this, "undefined parameter name '" + paramName + "' in add-on configuration file for command '" + cmd.namespace + "." + cmd.name + "' in string '" + original + "'");
                    return original;
                }
                varvalue = paramInfo.value.equals(paramInfo.defaultValue) ? "" : String.valueOf(varname.substring(0, li)) + paramInfo.value + varname.substring(ri + 1);
            } else {
                varvalue = this.lookupVar(cmd, varname);
                if (varvalue == null) {
                    Notify.devWarning(this, "invalid variable '" + varname + "' in add-on configuration file for command '" + cmd.namespace + "." + cmd.name + "' in string '" + original + "'");
                    return original;
                }
            }
            sb.append(this.substVariables(cmd, varvalue));
            i = s.indexOf(36);
        }
        sb.append(s);
        return sb.toString();
    }

    private String lookupVar(ExternalCommand cmd, String varname) {
        String platformEnvVar;
        int paramIndex;
        if (Character.isDigit(varname.charAt(0)) && ((paramIndex = Integer.parseInt(varname)) >= 0 || paramIndex < cmd.params.size())) {
            return cmd.params.get((int)paramIndex).value;
        }
        for (ExternalCommand.ParamInfo pinfo : cmd.params) {
            if (!pinfo.name.equals(varname)) continue;
            return pinfo.value;
        }
        if (cmd.env != null) {
            for (ExternalFunction.Var envVar : cmd.env) {
                if (!envVar.name.equals(varname)) continue;
                return envVar.value;
            }
        }
        if (cmd.group.env != null) {
            for (ExternalFunction.Var envVar : cmd.group.env) {
                if (!envVar.name.equals(varname)) continue;
                return envVar.value;
            }
        }
        if (cmd.group.vars != null) {
            for (ExternalFunction.Var var : cmd.group.vars) {
                if (!var.name.equals(varname)) continue;
                return var.value;
            }
        }
        if ((platformEnvVar = System.getenv(varname)) != null && platformEnvVar.length() > 0) {
            return platformEnvVar;
        }
        return null;
    }

    private String getExistingResourceName(Object value, String requiredResourceFormat) {
        if (!(value instanceof seq)) {
            return null;
        }
        seq sequence = (seq)value;
        String resourceName = sequence.get_AssociatedResource();
        if (resourceName == null) {
            return null;
        }
        List<String> typesForExtension = this.rm.getResourceTypesWithExtension(Util.extension(resourceName));
        if (typesForExtension.size() == 0) {
            return null;
        }
        if (typesForExtension.size() > 1) {
            return null;
        }
        try {
            if (typesForExtension.contains(requiredResourceFormat)) {
                return new URL(resourceName).getFile();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    public void writeTestConfig(OutputStream configStream) {
        ExternalCommand cmd = new ExternalCommand();
        cmd.name = "antigenic";
        cmd.namespace = "bilab.emboss";
        cmd.summary = "predicts potentially antigenic regions of a protein sequence, using the method of Kolaskar and Tongaonkar";
        cmd.docTextOrURL = "file:EMBOSS/doc/html/antigenic.html";
        cmd.executable = "antigenic";
        cmd.workingDir = cmd.externalDir = "$pluginRoot$/EMBOSS";
        cmd.env.add(new ExternalFunction.Var("{($platform$==//win//)?//EMBOSSWIN//://EMBOSS//}", cmd.externalDir));
        cmd.inFiles.add(new ExternalCommand.File("$unique1$", "FASTA"));
        ExternalCommand.ParamInfo param1 = new ExternalCommand.ParamInfo();
        param1.name = "sequence";
        param1.type = "bilab.seq";
        param1.required = true;
        param1.viaFile = true;
        param1.defaultValue = null;
        param1.allowedValues = null;
        cmd.params.add(param1);
        cmd.argumentTemplate = "-auto -rformat $1$ fasta::$file1$";
        ExternalFunctionGroup group = new ExternalFunctionGroup();
        group.name = "emboss";
        group.namespace = "bilab.emboss";
        group.externalFunctions.add(cmd);
        AddOns addOns = new AddOns();
        addOns.groups.add(group);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(configStream);
            this.xstream.toXML((Object)addOns, (Writer)writer);
            ((Writer)writer).flush();
            configStream.close();
        }
        catch (IOException e) {
            Notify.userWarning(this, "unable to write external addon configuration stream - " + e.getMessage());
        }
    }

    private static class ExternalFunctionGroup {
        public String name = null;
        public Set<ExternalFunction.Var> vars = null;
        public String namespace = null;
        public boolean debug = false;
        public String workingDir = "";
        public Set<ExternalFunction.Var> env = null;
        public List<ExternalFunction> externalFunctions = new LinkedList<ExternalFunction>();
    }

    private static abstract class ExternalFunction {
        public String name = "untitled";
        public String namespace = "bilab";
        public String summary = "";
        public String docTextOrURL = "";
        public String sophistication = "normal";
        public boolean debug = false;
        public transient ExternalFunctionGroup group;

        public static class Var {
            public String name;
            public String value;

            public Var() {
            }

            public Var(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }

    private static class ExternalCommand
    extends ExternalFunction {
        public String executable;
        public String externalDir;
        public String workingDir;
        public Set<ExternalFunction.Var> env;
        public String stdinText;
        public String stdoutResType;
        public String preProcess;
        public String postProcess;
        public boolean returnStdoutText;
        public boolean returnStderrText;
        public List<File> inFiles;
        public List<File> outFiles;
        public List<ParamInfo> params;
        public String returns;
        public String argumentTemplate;

        public ExternalCommand() {
            this.executable = this.name;
            this.externalDir = "/";
            this.workingDir = "/";
            this.env = new HashSet<ExternalFunction.Var>();
            this.stdinText = null;
            this.stdoutResType = null;
            this.returnStdoutText = true;
            this.returnStderrText = true;
            this.inFiles = new LinkedList<File>();
            this.outFiles = new LinkedList<File>();
            this.params = new LinkedList<ParamInfo>();
            this.argumentTemplate = "";
        }

        private static class ParamInfo {
            public String name;
            public String type;
            public boolean required;
            public boolean viaFile;
            public String[] allowedValues;
            public String defaultValue;
            public transient String value;

            ParamInfo() {
            }
        }

        private static class File {
            public String name;
            public String resourceType;
            public transient String actualName;
            public transient boolean temporary;

            public File() {
            }

            public File(String name, String resourceType) {
                this.name = name;
                this.resourceType = resourceType;
                this.actualName = null;
                this.temporary = false;
            }
        }
    }

    private static class AddOns {
        public ArrayList<ExternalFunctionGroup> groups = new ArrayList();
    }
}

