/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.Doc;
import bilab.ExternalApps;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Summary;
import bilab.Util;
import bilab.picture;
import bilab.protein;
import bilab.seq;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import scigol.Any;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Emboss {
    protected static Runtime runtime = Runtime.getRuntime();
    static /* synthetic */ Class class$0;

    @Summary(value="thresholded dotplot of two sequences")
    public static picture dotmatcher(seq sa, seq sb, int windowSize, int threshold) {
        String result = "";
        try {
            boolean existingResourceAAvailable = ExternalApps.isInputResourceAvailable(sa, "FASTA");
            String resourceNameA = ExternalApps.getInputResource(sa, "FASTA");
            boolean existingResourceBAvailable = ExternalApps.isInputResourceAvailable(sb, "FASTA");
            String resourceNameB = ExternalApps.getInputResource(sb, "FASTA");
            String outputResourceName = BilabPlugin.getResourceManager().uniqueTemporaryResourceName("PNG");
            LinkedList<String> args = new LinkedList<String>();
            args.add("fasta::" + Util.toNativePathSeparator(resourceNameA));
            args.add("fasta::" + Util.toNativePathSeparator(resourceNameB));
            args.add("-auto");
            args.add("-goutfile");
            args.add(Util.toNativePathSeparator(outputResourceName));
            args.add("-graph");
            args.add("win3");
            args.add("-windowsize");
            args.add("" + windowSize);
            args.add("-threshold");
            args.add("" + threshold);
            result = Emboss.exec("dotmatcher", args);
            try {
                if (!existingResourceAAvailable) {
                    BilabPlugin.getResourceManager().deleteResource(resourceNameA);
                }
            }
            catch (IOException iOException) {}
            try {
                if (!existingResourceBAvailable) {
                    BilabPlugin.getResourceManager().deleteResource(resourceNameB);
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (Exception e) {
            Notify.logError(Emboss.class, "dotmatcher:" + result);
            throw new BilabException("error executing dotmatcher - " + e);
        }
    }

    @Summary(value="predicts potentially antigenic regions of a protein sequence, using the method of Kolaskar and Tongaonkar")
    @Doc(value="file:EMBOSS/doc/html/antigenic.html")
    public static Any antigenic(seq sequence, int minLength, String format) {
        Object[] args = new Object[]{sequence, minLength, format};
        return new Any(BilabPlugin.getAddOnManager().callExternalFunction("bilab.emboss", "antigenic", args));
    }

    @Summary(value="Protein proteolytic enzyme or reagent cleavage digest")
    @Doc(value="file:EMBOSS/doc/html/digest.html")
    public static String digest(seq sequence, int reagent, boolean unfavoured, boolean overlap, boolean allpartials) {
        boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
        String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
        LinkedList<String> args = new LinkedList<String>();
        args.add("-auto");
        args.add("-menu");
        args.add("" + reagent);
        if (unfavoured) {
            args.add("-unfavoured");
        }
        if (overlap) {
            args.add("-overlap");
        }
        if (allpartials) {
            args.add("-allpartials");
        }
        args.add("fasta::" + Util.toNativePathSeparator(resourceName));
        String result = Emboss.exec("digest", args);
        try {
            if (!existingResourceAvailable) {
                BilabPlugin.getResourceManager().deleteResource(resourceName);
            }
        }
        catch (IOException iOException) {}
        return Emboss.filterEMBOSSReportOutput(result);
    }

    @Summary(value="Protein pattern search (PROSITE-style)")
    @Doc(value="file:EMBOSS/doc/html/fuzzpro.html")
    public static String fuzzpro(seq sequence, String pattern, int mismatch) {
        boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
        String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
        LinkedList<String> args = new LinkedList<String>();
        args.add("-auto");
        args.add("-mismatch");
        args.add("" + mismatch);
        args.add("-pattern");
        args.add(pattern);
        args.add("fasta::" + Util.toNativePathSeparator(resourceName));
        String result = Emboss.exec("fuzzpro", args);
        try {
            if (!existingResourceAvailable) {
                BilabPlugin.getResourceManager().deleteResource(resourceName);
            }
        }
        catch (IOException iOException) {}
        return Emboss.filterEMBOSSReportOutput(result);
    }

    @Summary(value="Protein pattern search after translation (PROSITE-style)")
    @Doc(value="file:EMBOSS/doc/html/fuzztran.html")
    public static String fuzztran(seq sequence, String pattern, String frame, int code, int mismatch) {
        boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
        String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
        LinkedList<String> args = new LinkedList<String>();
        args.add("-auto");
        args.add("-mismatch");
        args.add("" + mismatch);
        args.add("-pattern");
        args.add(pattern);
        args.add("-frame");
        args.add(frame);
        args.add("-table");
        args.add("" + code);
        if (sequence instanceof protein) {
            args.add("-sprotein1");
        }
        args.add("fasta::" + Util.toNativePathSeparator(resourceName));
        String result = Emboss.exec("fuzztran", args);
        try {
            if (!existingResourceAvailable) {
                BilabPlugin.getResourceManager().deleteResource(resourceName);
            }
        }
        catch (IOException iOException) {}
        return Emboss.filterEMBOSSReportOutput(result);
    }

    @Summary(value="Report nucleic acid binding motifs")
    @Doc(value="file:EMBOSS/doc/html/helixturnhelix.html")
    public static String helixturnhelix(seq sequence, double mean, double sd, double minsd) {
        boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
        String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
        LinkedList<String> args = new LinkedList<String>();
        args.add("-auto");
        args.add("-mean");
        args.add("" + mean);
        args.add("-sd");
        args.add("" + sd);
        args.add("-minsd");
        args.add("" + minsd);
        if (sequence instanceof protein) {
            args.add("-sprotein1");
        }
        args.add("fasta::" + Util.toNativePathSeparator(resourceName));
        String result = Emboss.exec("helixturnhelix", args);
        try {
            if (!existingResourceAvailable) {
                BilabPlugin.getResourceManager().deleteResource(resourceName);
            }
        }
        catch (IOException iOException) {}
        return Emboss.filterEMBOSSReportOutput(result);
    }

    @Summary(value="Reports protein signal cleavage sites")
    @Doc(value="file:EMBOSS/doc/html/sigcleave.html")
    public static String sigcleave(seq sequence, double minWeight, boolean prokaryote) {
        if (!(sequence instanceof protein)) {
            throw new BilabException("a protein sequence is required");
        }
        boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
        String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
        LinkedList<String> args = new LinkedList<String>();
        args.add("-auto");
        args.add("-minweight");
        args.add("" + minWeight);
        if (prokaryote) {
            args.add("-prokaryote");
        }
        args.add("-sprotein1");
        args.add("fasta::" + Util.toNativePathSeparator(resourceName));
        String result = Emboss.exec("sigcleave", args);
        try {
            if (!existingResourceAvailable) {
                BilabPlugin.getResourceManager().deleteResource(resourceName);
            }
        }
        catch (IOException iOException) {}
        return Emboss.filterEMBOSSReportOutput(result);
    }

    protected static String exec(String commandName, List<String> args) {
        try {
            String pluginRoot = BilabPlugin.getResourceManager().getPluginFilesystemRoot();
            String EMBOSSRoot = String.valueOf(pluginRoot) + '/' + "EMBOSS";
            LinkedList<String> cmdline = new LinkedList<String>();
            cmdline.add(String.valueOf(EMBOSSRoot) + '/' + commandName + ExternalApps.exeSuffix);
            cmdline.addAll(args);
            StringBuilder cmdlineStr = new StringBuilder();
            for (String s : cmdline) {
                cmdlineStr.append(String.valueOf(s) + " ");
            }
            Notify.logInfo(Emboss.class, "invoking external command:" + cmdlineStr.toString());
            ProcessBuilder pb = new ProcessBuilder(cmdline);
            Map<String, String> env = pb.environment();
            env.put("EMBOSSWIN", EMBOSSRoot);
            pb.directory(new File(EMBOSSRoot));
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream cmdResultStream = process.getInputStream();
            InputStreamReader cmdResultReader = new InputStreamReader(cmdResultStream);
            StringBuilder str = new StringBuilder();
            int c = cmdResultReader.read();
            while (c != -1) {
                str.append((char)c);
                c = cmdResultReader.read();
            }
            process.waitFor();
            return str.toString();
        }
        catch (Exception e) {
            throw new BilabException("unable to execute command (external EMBOSS invocation failed) - " + e);
        }
    }

    public static String filterEMBOSSReportOutput(String report) {
        String terminator = ResourceManager.platformOS().equals("win") ? "\r\n" : "\n";
        String[] lines = report.split(terminator);
        StringBuilder filtered = new StringBuilder();
        String[] stringArray = lines;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String line = stringArray[n];
            if (line.length() == 0 || line.charAt(0) != '#') {
                filtered.append(String.valueOf(line) + terminator);
            } else if (!(line.startsWith("#####") || line.startsWith("# Program") || line.startsWith("# Rundate") || line.startsWith("# Report"))) {
                filtered.append(String.valueOf(line) + terminator);
            }
            ++n;
        }
        return filtered.toString();
    }
}

